/*
 * Decompiled with CFR 0.152.
 */
package com.ksso.scim.service;

import com.ksso.scim.ScimRequest;
import com.ksso.scim.ScimRequestContext;
import com.ksso.scim.ScimResponse;
import com.ksso.scim.ScimResponseCode;
import com.ksso.scim.SearchResult;
import com.ksso.scim.schema.marshaller.ScimErrorMarshaller;
import com.ksso.scim.schema.marshaller.ScimResponseMarshaller;
import com.ksso.scim.schema.marshaller.ScimResponseMarshallerFactory;
import com.ksso.scim.schema.requests.CreateGroupRequest;
import com.ksso.scim.schema.requests.CreateUserRequest;
import com.ksso.scim.schema.requests.ReplaceGroupRequest;
import com.ksso.scim.schema.requests.ReplaceUserRequest;
import com.ksso.scim.schema.requests.SearchRequest;
import com.ksso.scim.schema.validation.ScimRequestValidator;
import com.ksso.scim.schema.validation.ValidationError;
import com.ksso.scim.schema.vo.ScimGroup;
import com.ksso.scim.schema.vo.ScimUser;
import io.vavr.collection.List;
import io.vavr.collection.Seq;
import io.vavr.control.Validation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractScimService {
    private static final Logger log = LoggerFactory.getLogger(AbstractScimService.class);
    final ScimRequestValidator requestValidator;
    final ScimErrorMarshaller errorMarshaller;

    public AbstractScimService(ScimRequestValidator requestValidator, ScimErrorMarshaller errorMarshaller) {
        this.requestValidator = requestValidator;
        this.errorMarshaller = errorMarshaller;
    }

    public ScimResponse getUsers(ScimRequestContext ctx) {
        Validation<ValidationError, SearchRequest> validation = this.requestValidator.validateSearchRequest(ctx);
        if (validation.isInvalid()) {
            return this.errorMarshaller.errorResponse(ScimResponseCode.BAD_REQUEST, List.of(validation.getError()));
        }
        SearchRequest req = validation.get();
        ScimResponseMarshaller marshaller = ScimResponseMarshallerFactory.responseMarshaller(ctx);
        return ctx.getSpi().searchUsers(req).map(sr -> marshaller.userListResponse(req, (SearchResult<ScimUser>)sr)).getOrElseGet(this.errorMarshaller::errorResponse);
    }

    public ScimResponse getUserById(ScimRequestContext ctx) {
        ScimRequest req = ctx.getScimRequest();
        String uid = req.getResourceId().getOrElseThrow(() -> new RuntimeException("??? getUserById without resourceId present on request"));
        ScimResponseMarshaller marshaller = ScimResponseMarshallerFactory.responseMarshaller(ctx);
        return ctx.getSpi().getUserById(uid).map(marshaller::userResponse).getOrElseGet(this.errorMarshaller::errorResponse);
    }

    public ScimResponse createUser(ScimRequestContext ctx) {
        ScimRequest scimRequest = ctx.getScimRequest();
        ScimResponseMarshaller marshaller = ScimResponseMarshallerFactory.responseMarshaller(ctx);
        Validation<Seq<ValidationError>, CreateUserRequest> validation = this.requestValidator.validateCreateUserRequest(scimRequest);
        if (validation.isInvalid()) {
            return this.errorMarshaller.errorResponse(ScimResponseCode.BAD_REQUEST, validation.getError());
        }
        CreateUserRequest createUserRequest = validation.get();
        return ctx.getSpi().createUser(createUserRequest).map(marshaller::userCreatedResponse).getOrElseGet(this.errorMarshaller::errorResponse);
    }

    public ScimResponse replaceUser(ScimRequestContext ctx) {
        ScimResponseMarshaller marshaller = ScimResponseMarshallerFactory.responseMarshaller(ctx);
        Validation<Seq<ValidationError>, ReplaceUserRequest> validation = this.requestValidator.validateReplaceUserRequest(ctx.getScimRequest());
        if (validation.isInvalid()) {
            return this.errorMarshaller.errorResponse(ScimResponseCode.BAD_REQUEST, validation.getError());
        }
        ReplaceUserRequest replaceUserRequest = validation.get();
        return ctx.getSpi().replaceUser(replaceUserRequest).map(marshaller::userModifiedResponse).getOrElseGet(this.errorMarshaller::errorResponse);
    }

    public ScimResponse deleteUser(ScimRequestContext ctx) {
        ScimRequest req = ctx.getScimRequest();
        ScimResponseMarshaller marshaller = ScimResponseMarshallerFactory.responseMarshaller(ctx);
        String uid = req.getResourceId().getOrElseThrow(() -> new RuntimeException("??? deleteGroup without resourceId present on request"));
        return ctx.getSpi().deleteUserById(uid).map(b -> marshaller.emptyOk()).getOrElseGet(this.errorMarshaller::errorResponse);
    }

    public ScimResponse getGroups(ScimRequestContext ctx) {
        Validation<ValidationError, SearchRequest> validation = this.requestValidator.validateSearchRequest(ctx);
        if (validation.isInvalid()) {
            return this.errorMarshaller.errorResponse(ScimResponseCode.BAD_REQUEST, List.of(validation.getError()));
        }
        SearchRequest req = validation.get();
        ScimResponseMarshaller marshaller = ScimResponseMarshallerFactory.responseMarshaller(ctx);
        return ctx.getSpi().searchGroups(req).map(res -> marshaller.groupListResponse(req, (SearchResult<ScimGroup>)res)).getOrElseGet(this.errorMarshaller::errorResponse);
    }

    public ScimResponse getGroupById(ScimRequestContext ctx) {
        ScimRequest req = ctx.getScimRequest();
        String gid = req.getResourceId().getOrElseThrow(() -> new RuntimeException("??? getGroupById without resourceId present on request"));
        ScimResponseMarshaller marshaller = ScimResponseMarshallerFactory.responseMarshaller(ctx);
        return ctx.getSpi().getGroupById(gid).map(marshaller::groupResponse).getOrElseGet(this.errorMarshaller::errorResponse);
    }

    public ScimResponse createGroup(ScimRequestContext ctx) {
        ScimRequest scimRequest = ctx.getScimRequest();
        ScimResponseMarshaller marshaller = ScimResponseMarshallerFactory.responseMarshaller(ctx);
        Validation<Seq<ValidationError>, CreateGroupRequest> validation = this.requestValidator.validateCreateGroupRequest(scimRequest);
        if (validation.isInvalid()) {
            return this.errorMarshaller.errorResponse(ScimResponseCode.BAD_REQUEST, validation.getError());
        }
        CreateGroupRequest createGroupRequest = validation.get();
        return ctx.getSpi().createGroup(createGroupRequest).map(marshaller::groupCreatedResponse).getOrElseGet(this.errorMarshaller::errorResponse);
    }

    public ScimResponse replaceGroup(ScimRequestContext ctx) {
        ScimResponseMarshaller marshaller = ScimResponseMarshallerFactory.responseMarshaller(ctx);
        Validation<Seq<ValidationError>, ReplaceGroupRequest> validation = this.requestValidator.validateReplaceGroupRequest(ctx.getScimRequest());
        if (validation.isInvalid()) {
            return this.errorMarshaller.errorResponse(ScimResponseCode.BAD_REQUEST, validation.getError());
        }
        ReplaceGroupRequest replaceGroupRequest = validation.get();
        return ctx.getSpi().replaceGroup(replaceGroupRequest).map(marshaller::groupModifiedResponse).getOrElseGet(this.errorMarshaller::errorResponse);
    }

    public ScimResponse deleteGroup(ScimRequestContext ctx) {
        ScimRequest req = ctx.getScimRequest();
        ScimResponseMarshaller marshaller = ScimResponseMarshallerFactory.responseMarshaller(ctx);
        String gid = req.getResourceId().getOrElseThrow(() -> new RuntimeException("??? deleteGroup without resourceId present on request"));
        return ctx.getSpi().deleteGroupById(gid).map(b -> marshaller.emptyOk()).getOrElseGet(this.errorMarshaller::errorResponse);
    }
}

