/*
 * Decompiled with CFR 0.152.
 */
package com.ksso.scim.schema.vo;

import com.ksso.scim.ScimResource;
import com.ksso.scim.schema.vo.ScimMembership;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;

public class ScimUserGroup
implements ScimMembership,
Comparable<ScimUserGroup> {
    private final String value;
    private final String display;
    private final Type type;

    public ScimUserGroup(String value, String display) {
        this(value, display, Type.DIRECT);
    }

    public ScimUserGroup(String value, String display, Type type) {
        this.value = Objects.requireNonNull(value);
        this.display = Objects.requireNonNull(display);
        this.type = Objects.requireNonNull(type);
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public String getDisplay() {
        return this.display;
    }

    @Override
    public ScimResource getResource() {
        return ScimResource.GROUPS;
    }

    @Override
    public String getType() {
        return this.type.toString().toLowerCase();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScimUserGroup that = (ScimUserGroup)o;
        return Objects.equals(this.value, that.value) && Objects.equals(this.display, that.display) && this.type == that.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.value, this.display, this.type});
    }

    public String toString() {
        return "ScimUserGroup{value='" + this.value + '\'' + ", display='" + this.display + '\'' + ", type=" + (Object)((Object)this.type) + '}';
    }

    @Override
    public int compareTo(ScimUserGroup o) {
        return this.getValue().compareTo(o.getValue());
    }

    public static enum Type {
        DIRECT,
        INDIRECT;


        public static Type fromTypeString(String type) {
            return Type.valueOf(StringUtils.upperCase((String)type));
        }
    }
}

