/*
 * Decompiled with CFR 0.152.
 */
package com.ksso.scim.schema.vo;

import com.ksso.scim.ScimResource;
import com.ksso.scim.schema.vo.ScimCommonAttr;
import io.vavr.control.Option;
import java.time.Instant;
import java.util.Objects;

public abstract class ScimObject {
    protected final ScimCommonAttr commonAttr;

    public ScimObject(ScimCommonAttr commonAttr) {
        this.commonAttr = Objects.requireNonNull(commonAttr);
    }

    public String getId() {
        return this.commonAttr.getId();
    }

    public Option<String> getExternalId() {
        return this.commonAttr.getExternalId();
    }

    public Instant getCreated() {
        return this.commonAttr.getCreated();
    }

    public Instant getLastModified() {
        return this.commonAttr.getLastModified();
    }

    public String weakEtag() {
        String version = Integer.toUnsignedString(this.hashCode(), 16);
        return String.format("W/\"%s\"", version);
    }

    public abstract ScimResource getResourceType();
}

