/*
 * Decompiled with CFR 0.152.
 */
package com.ksso.scim.schema.validation;

import com.ksso.scim.ScimErrorType;
import io.vavr.API;
import io.vavr.collection.List;
import io.vavr.collection.Seq;
import io.vavr.control.Validation;

public class ValidationError {
    private final ScimErrorType errorType;
    private final String description;

    public ValidationError(ScimErrorType errorType, String attributeName, String description) {
        this(errorType, String.format("'%s' is missing or invalid: %s", attributeName, description));
    }

    public ValidationError(ScimErrorType errorType, String description) {
        this.errorType = errorType;
        this.description = description;
    }

    public ScimErrorType getErrorType() {
        return this.errorType;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return "ValidationError{errorType=" + (Object)((Object)this.errorType) + ", description='" + this.description + '\'' + '}';
    }

    public static <T> Validation<ValidationError, T> invalidAttribute(String attributeName, String description) {
        ValidationError ve = new ValidationError(ScimErrorType.INVALID_VALUE, attributeName, description);
        return Validation.invalid(ve);
    }

    public static <T> Validation<Seq<ValidationError>, T> invalidAttributeSeq(String attributeName, String description) {
        ValidationError ve = new ValidationError(ScimErrorType.INVALID_VALUE, attributeName, description);
        return Validation.invalid(API.Seq(ve));
    }

    public static <T> Validation<ValidationError, T> resourceIdMismatch(String attributeName, String resourceId, String jsonId) {
        ValidationError ve = new ValidationError(ScimErrorType.INVALID_SYNTAX, String.format("%s '%s' in payload does not match URL resource identifier (%s)", attributeName, resourceId, jsonId));
        return Validation.invalid(ve);
    }

    public static <T> Validation<ValidationError, T> requiredAttributeMissing(String attributeName) {
        ValidationError ve = new ValidationError(ScimErrorType.INVALID_SYNTAX, String.format("'%s' is required but was not found in JSON fragment", attributeName));
        return Validation.invalid(ve);
    }

    public static <T> Validation<Seq<ValidationError>, T> emptyBody() {
        ValidationError ve = new ValidationError(ScimErrorType.INVALID_SYNTAX, "Empty JSON request body");
        return Validation.invalid(List.of(ve));
    }
}

