/*
 * Decompiled with CFR 0.152.
 */
package com.ksso.scim.schema.validation;

import com.atlassian.json.jsonorg.JSONObject;
import com.ksso.scim.ScimErrorType;
import com.ksso.scim.ScimRequest;
import com.ksso.scim.ScimVersion;
import com.ksso.scim.filter.FilterContextFactory;
import com.ksso.scim.filter.ScimFilterParser;
import com.ksso.scim.patch.PatchOperation;
import com.ksso.scim.schema.validation.AbstractRequestValidator;
import com.ksso.scim.schema.validation.PatchFix;
import com.ksso.scim.schema.validation.ScimRequestValidator;
import com.ksso.scim.schema.validation.ValidationError;
import com.ksso.scim.util.JsonUtils;
import io.vavr.collection.LinearSeq;
import io.vavr.collection.List;
import io.vavr.collection.Seq;
import io.vavr.control.Option;
import io.vavr.control.Try;
import io.vavr.control.Validation;
import org.apache.commons.lang3.StringUtils;

public class ScimRequestValidatorV2
extends AbstractRequestValidator
implements ScimRequestValidator {
    public ScimRequestValidatorV2() {
        super(ScimVersion.V2_0);
    }

    @Override
    ScimVersion scimVersion() {
        return ScimVersion.V2_0;
    }

    public Validation<Seq<ValidationError>, Seq<PatchOperation>> validatePatchRequest(ScimRequest request) {
        Validation<ValidationError, JSONObject> bodyValidation = this.fv.validateBody(request.getJsonBody(), List.of("urn:ietf:params:scim:api:messages:2.0:PatchOp"));
        return bodyValidation.fold(ve -> Validation.invalid(List.of(ve)), json -> {
            LinearSeq stream = JsonUtils.jsonObjectStream(json.optJSONArray("Operations")).map(this::validatePatchOperation).map(validation -> validation.mapError(List::of));
            return Validation.sequence(stream);
        });
    }

    public Validation<ValidationError, PatchOperation> validatePatchOperation(JSONObject json) {
        Validation opValidation = Option.of(json.optString("op", null)).map(v -> Try.of(() -> PatchOperation.Type.valueOf(v.toUpperCase())).toValidation().mapError(t -> new ValidationError(ScimErrorType.INVALID_VALUE, "op", "Invalid patch operation '" + v + "'"))).getOrElse(Validation.valid(PatchOperation.Type.ADD));
        if (opValidation.isInvalid()) {
            return Validation.invalid(opValidation.getError());
        }
        PatchOperation.Type opType = opValidation.get();
        String rawPath = json.optString("path", "$");
        Object patchValue = json.opt("value");
        if (opType == PatchOperation.Type.REMOVE) {
            if (StringUtils.equals("$", rawPath)) {
                return Validation.invalid(new ValidationError(ScimErrorType.NO_TARGET, "'path' is required for REMOVE"));
            }
            if (patchValue != null) {
                return PatchFix.convertToFilter(rawPath, patchValue).map(converted -> new PatchOperation(PatchOperation.Type.REMOVE, (ScimFilterParser.PatchPathContext)converted._2, (String)converted._1, null));
            }
        } else if (patchValue == null) {
            return Validation.invalid(new ValidationError(ScimErrorType.INVALID_VALUE, "'value' is required"));
        }
        return Try.of(() -> FilterContextFactory.parsePatchPath(rawPath)).map(path -> new PatchOperation(opType, (ScimFilterParser.PatchPathContext)path, rawPath, patchValue)).toValidation(t -> new ValidationError(ScimErrorType.INVALID_PATH, "Invalid PATCH target expr '" + rawPath + "': " + t.getMessage()));
    }
}

