/*
 * Decompiled with CFR 0.152.
 */
package com.ksso.scim.schema.validation;

import com.atlassian.json.jsonorg.JSONArray;
import com.atlassian.json.jsonorg.JSONObject;
import com.ksso.scim.ScimErrorType;
import com.ksso.scim.filter.FilterContextFactory;
import com.ksso.scim.filter.ScimFilterParser;
import com.ksso.scim.schema.validation.ValidationError;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.collection.Iterator;
import io.vavr.collection.List;
import io.vavr.control.Validation;
import org.apache.commons.lang3.StringUtils;

public class PatchFix {
    public static Validation<ValidationError, Tuple2<String, ScimFilterParser.PatchPathContext>> convertToFilter(String rawPath, Object value) {
        if (!StringUtils.isAlphanumeric(rawPath)) {
            return Validation.invalid(new ValidationError(ScimErrorType.INVALID_VALUE, "Can't convert 'value' to filter: 'path' must be simple/direct attribute name"));
        }
        try {
            JSONArray array = (JSONArray)value;
            JSONObject jsonObject = array.getJSONObject(0);
            List keys2 = Iterator.ofAll(jsonObject.keys()).toList();
            String stringValue = jsonObject.getString((String)keys2.get());
            String key = (String)keys2.get();
            if (array.length() > 1 || keys2.size() > 1) {
                return Validation.invalid(new ValidationError(ScimErrorType.INVALID_VALUE, "Can't convert 'value' to filter: Exactly one key-value pair is required"));
            }
            String filter = String.format("%s[%s eq \"%s\"]", rawPath, key, stringValue);
            ScimFilterParser.PatchPathContext ctx = FilterContextFactory.parsePatchPath(filter);
            return Validation.valid(Tuple.of(filter, ctx));
        }
        catch (Exception e) {
            return Validation.invalid(new ValidationError(ScimErrorType.INVALID_VALUE, "Can't convert 'value' to filter: Unsupported JSON value"));
        }
    }
}

