/*
 * Decompiled with CFR 0.152.
 */
package com.ksso.scim.schema.validation;

import com.atlassian.json.jsonorg.JSONObject;
import com.ksso.scim.ScimErrorType;
import com.ksso.scim.ScimQueryParams;
import com.ksso.scim.ScimRequest;
import com.ksso.scim.ScimRequestContext;
import com.ksso.scim.ScimVersion;
import com.ksso.scim.filter.ScimFilter;
import com.ksso.scim.schema.requests.CreateGroupRequest;
import com.ksso.scim.schema.requests.CreateUserRequest;
import com.ksso.scim.schema.requests.ReplaceGroupRequest;
import com.ksso.scim.schema.requests.ReplaceUserRequest;
import com.ksso.scim.schema.requests.SearchRequest;
import com.ksso.scim.schema.validation.FragmentValidator;
import com.ksso.scim.schema.validation.ScimRequestValidator;
import com.ksso.scim.schema.validation.ValidationError;
import com.ksso.scim.schema.vo.ScimGroupMember;
import com.ksso.scim.schema.vo.ScimName;
import com.ksso.scim.schema.vo.ScimUserEnterpriseAttrs;
import com.ksso.scim.schema.vo.ScimUserGroup;
import io.vavr.collection.List;
import io.vavr.collection.Seq;
import io.vavr.control.Option;
import io.vavr.control.Try;
import io.vavr.control.Validation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRequestValidator
implements ScimRequestValidator {
    static final int DEFAULT_MAX_PAGE_SIZE = 50;
    private static final Logger log = LoggerFactory.getLogger(AbstractRequestValidator.class);
    final FragmentValidator fv;
    private final ScimVersion version;

    public AbstractRequestValidator(ScimVersion version) {
        this.version = version;
        this.fv = new FragmentValidator(version);
    }

    ScimVersion scimVersion() {
        return this.version;
    }

    @Override
    public Validation<ValidationError, SearchRequest> validateSearchRequest(ScimRequestContext ctx) {
        ScimQueryParams qry = ctx.getScimRequest().getQueryParams();
        int count = Math.min(50, qry.count().getOrElse(50));
        int startIndex = qry.startIndex().getOrElse(1);
        return this.validateScimFilter(qry).map(maybeEvaluator -> new SearchRequest(startIndex, count, (Option<ScimFilter>)maybeEvaluator));
    }

    Validation<ValidationError, Option<ScimFilter>> validateScimFilter(ScimQueryParams qry) {
        return qry.filter().fold(() -> Validation.valid(Option.none()), filterString -> Try.of(() -> new ScimFilter((String)filterString)).onFailure(throwable -> log.debug("Invalid SCIM filter '{}': {}", filterString, (Object)throwable.getMessage())).toValidation().map(Option::of).mapError(throwable -> new ValidationError(ScimErrorType.INVALID_FILTER, throwable.getMessage())));
    }

    @Override
    public Validation<Seq<ValidationError>, CreateUserRequest> validateCreateUserRequest(ScimRequest request) {
        return this.validateCreateUserRequest(request.getJsonBody());
    }

    @Override
    public Validation<Seq<ValidationError>, CreateUserRequest> validateCreateUserRequest(Option<JSONObject> maybeBody) {
        List requiredSchema = this.scimVersion().fold(() -> List.of("urn:scim:schemas:core:1.0"), () -> List.of("urn:ietf:params:scim:schemas:core:2.0:User"));
        Validation<ValidationError, JSONObject> bodyValidation = this.fv.validateBody(maybeBody, requiredSchema);
        if (bodyValidation.isInvalid()) {
            return Validation.invalid(List.of(bodyValidation.getError()));
        }
        JSONObject json = bodyValidation.get();
        Option.of(json.optString("id", null)).peek(id -> log.debug("Ignoring id '{}' in user creation request", id));
        Validation<ValidationError, ScimName> nameValidation = this.fv.validateScimName(json);
        Validation<ValidationError, String> userNameValidation = this.fv.validateName("userName", json);
        Validation emailValidation = this.fv.findMultiValuePrimaryWithFallback(json.optJSONArray("emails")).toValidation(new ValidationError(ScimErrorType.INVALID_SYNTAX, "emails", "Found no email address designated as primary"));
        Validation<ValidationError, ScimUserEnterpriseAttrs> enterpriseAttrsValidation = this.fv.validateUserEnterpriseAttrs(json);
        boolean active = json.optBoolean("active", true);
        String externalId = json.optString("externalId");
        Validation membershipsValidation = this.fv.validateMemberships(json.optJSONArray("groups"), this.fv::validateUserGroup);
        return Validation.combine(userNameValidation, emailValidation, nameValidation, membershipsValidation, enterpriseAttrsValidation).ap((userName, email, name, memberships, enterpriseAttrs) -> new CreateUserRequest((String)userName, (String)email, externalId, (ScimName)name, (List<ScimUserGroup>)memberships, active, (ScimUserEnterpriseAttrs)enterpriseAttrs));
    }

    @Override
    public Validation<Seq<ValidationError>, ReplaceUserRequest> validateReplaceUserRequest(ScimRequest request) {
        return request.getResourceId().map(rid -> this.validateReplaceUserRequest(request.getJsonBody(), (String)rid, request.getScimHeaders().getIfMatch())).getOrElse(Validation.invalid(List.of(new ValidationError(ScimErrorType.INVALID_SYNTAX, "ResourceID is required"))));
    }

    @Override
    public Validation<Seq<ValidationError>, ReplaceUserRequest> validateReplaceUserRequest(Option<JSONObject> maybeBody, String uid, Option<String> maybeIfMatch) {
        Validation<Seq<ValidationError>, CreateUserRequest> createUserRequest = this.validateCreateUserRequest(maybeBody);
        JSONObject json = maybeBody.get();
        Validation<Seq, String> idValidation = this.fv.validateResourceId(uid, json).mapError(List::of);
        return Validation.combine(createUserRequest, idValidation).ap((create, id) -> new ReplaceUserRequest((CreateUserRequest)create, (String)id, maybeIfMatch)).mapError(seq -> seq.foldLeft(List.empty(), List::appendAll));
    }

    @Override
    public Validation<Seq<ValidationError>, CreateGroupRequest> validateCreateGroupRequest(ScimRequest request) {
        return this.validateCreateGroupRequest(request.getJsonBody());
    }

    @Override
    public Validation<Seq<ValidationError>, CreateGroupRequest> validateCreateGroupRequest(Option<JSONObject> maybeBody) {
        List requiredSchema = this.scimVersion().fold(() -> List.of("urn:scim:schemas:core:1.0"), () -> List.of("urn:ietf:params:scim:schemas:core:2.0:Group"));
        Validation<ValidationError, JSONObject> bodyValidation = this.fv.validateBody(maybeBody, requiredSchema);
        if (bodyValidation.isInvalid()) {
            return Validation.invalid(List.of(bodyValidation.getError()));
        }
        JSONObject json = bodyValidation.get();
        Option.of(json.optString("id", null)).peek(id -> log.debug("Ignoring id '{}' in group creation request", id));
        Validation<ValidationError, String> groupNameValidation = this.fv.validateGroupName("displayName", json);
        Validation membersValidation = this.fv.validateMemberships(json.optJSONArray("members"), this.fv::validateGroupMember);
        String externalId = json.optString("externalId");
        return Validation.combine(groupNameValidation, membersValidation).ap((groupName, memberships) -> new CreateGroupRequest(externalId, (String)groupName, (List<ScimGroupMember>)memberships));
    }

    @Override
    public Validation<Seq<ValidationError>, ReplaceGroupRequest> validateReplaceGroupRequest(ScimRequest request) {
        return request.getResourceId().map(rid -> this.validateReplaceGroupRequest(request.getJsonBody(), (String)rid, request.getScimHeaders().getIfMatch())).getOrElse(Validation.invalid(List.of(new ValidationError(ScimErrorType.INVALID_SYNTAX, "ResourceID is required"))));
    }

    @Override
    public Validation<Seq<ValidationError>, ReplaceGroupRequest> validateReplaceGroupRequest(Option<JSONObject> maybeBody, String gid, Option<String> maybeIfMatch) {
        Validation<Seq<ValidationError>, CreateGroupRequest> createGroupRequests = this.validateCreateGroupRequest(maybeBody);
        JSONObject json = maybeBody.get();
        Validation<Seq, String> idValidation = this.fv.validateResourceId(gid, json).mapError(List::of);
        return Validation.combine(createGroupRequests, idValidation).ap((create, id) -> new ReplaceGroupRequest((CreateGroupRequest)create, (String)id, maybeIfMatch)).mapError(seq -> seq.foldLeft(List.empty(), List::appendAll));
    }
}

