/*
 * Decompiled with CFR 0.152.
 */
package com.ksso.scim.schema.marshaller;

import com.ksso.scim.ScimRequest;
import com.ksso.scim.ScimRequestContext;
import com.ksso.scim.ScimVersion;
import com.ksso.scim.schema.marshaller.FragmentMarshaller;
import com.ksso.scim.schema.marshaller.ScimErrorMarshaller;
import com.ksso.scim.schema.marshaller.ScimErrorMarshallerV1;
import com.ksso.scim.schema.marshaller.ScimErrorMarshallerV2;
import com.ksso.scim.schema.marshaller.ScimResponseMarshaller;
import com.ksso.scim.schema.marshaller.ScimResponseMarshallerV1;
import com.ksso.scim.schema.marshaller.ScimResponseMarshallerV2;

public class ScimResponseMarshallerFactory {
    public static ScimResponseMarshaller responseMarshaller(ScimRequestContext ctx) {
        ScimRequest req = ctx.getScimRequest();
        ScimVersion v = req.getScimVersion();
        return v.fold(() -> new ScimResponseMarshallerV1(ctx), () -> new ScimResponseMarshallerV2(ctx));
    }

    public static ScimErrorMarshaller errorMarshaller(ScimVersion v) {
        return v.fold(ScimErrorMarshallerV1::new, ScimErrorMarshallerV2::new);
    }

    public static FragmentMarshaller nonFilteringFragmentMarshaller(ScimRequestContext ctx) {
        ScimRequest req = ctx.getScimRequest();
        return new FragmentMarshaller(req.getScimVersion(), attributeName -> true, ctx.getMetaUrlBuilder());
    }
}

