/*
 * Decompiled with CFR 0.152.
 */
package com.ksso.scim.schema.marshaller;

import com.atlassian.json.jsonorg.JSONObject;
import com.ksso.scim.MetaUrlBuilder;
import com.ksso.scim.ScimRequestContext;
import com.ksso.scim.ScimResponse;
import com.ksso.scim.ScimResponseCode;
import com.ksso.scim.ScimVersion;
import com.ksso.scim.SearchResult;
import com.ksso.scim.schema.marshaller.FragmentMarshaller;
import com.ksso.scim.schema.marshaller.ResponseAttributeFilterImpl;
import com.ksso.scim.schema.marshaller.ScimResponseMarshaller;
import com.ksso.scim.schema.requests.SearchRequest;
import com.ksso.scim.schema.vo.ScimGroup;
import com.ksso.scim.schema.vo.ScimObject;
import com.ksso.scim.schema.vo.ScimUser;
import io.vavr.Function1;
import io.vavr.collection.HashMap;
import io.vavr.collection.List;

public abstract class AbstractScimResponseMarshaller
implements ScimResponseMarshaller {
    static final String HTTP_CONTENT_TYPE = "Content-Type";
    final FragmentMarshaller fragmentMarshaller;

    public AbstractScimResponseMarshaller(ScimRequestContext ctx) {
        MetaUrlBuilder metaUrlBuilder = ctx.getMetaUrlBuilder();
        ResponseAttributeFilterImpl responseAttributeFilter = new ResponseAttributeFilterImpl(ctx.getScimRequest().getQueryParams());
        ScimVersion version = ctx.getScimRequest().getScimVersion();
        this.fragmentMarshaller = new FragmentMarshaller(version, responseAttributeFilter, metaUrlBuilder);
    }

    abstract HashMap<String, List<String>> responseHeaders();

    @Override
    public ScimResponse groupModifiedResponse(ScimGroup group) {
        return new ScimResponse(ScimResponseCode.OK, this.fragmentMarshaller.groupJson(group), this.responseHeaders());
    }

    @Override
    public ScimResponse groupCreatedResponse(ScimGroup group) {
        return new ScimResponse(ScimResponseCode.CREATED, this.fragmentMarshaller.groupJson(group), this.responseHeaders());
    }

    @Override
    public ScimResponse userCreatedResponse(ScimUser user) {
        return new ScimResponse(ScimResponseCode.CREATED, this.fragmentMarshaller.userJson(user), this.responseHeaders(user));
    }

    @Override
    public ScimResponse userModifiedResponse(ScimUser user) {
        return new ScimResponse(ScimResponseCode.OK, this.fragmentMarshaller.userJson(user), this.responseHeaders());
    }

    @Override
    public ScimResponse userResponse(ScimUser user) {
        return new ScimResponse(ScimResponseCode.OK, this.fragmentMarshaller.userJson(user), this.responseHeaders());
    }

    @Override
    public ScimResponse groupListResponse(SearchRequest req, SearchResult<ScimGroup> res) {
        return this.toListResponse(res, this.fragmentMarshaller::groupJson);
    }

    @Override
    public ScimResponse groupResponse(ScimGroup group) {
        return new ScimResponse(ScimResponseCode.OK, this.fragmentMarshaller.groupJson(group), this.responseHeaders());
    }

    @Override
    public ScimResponse emptyOk() {
        return new ScimResponse(ScimResponseCode.OK, this.responseHeaders());
    }

    @Override
    public ScimResponse noContent() {
        return new ScimResponse(ScimResponseCode.NO_CONTENT, this.responseHeaders());
    }

    @Override
    public ScimResponse jsonResponse(JSONObject json) {
        return new ScimResponse(ScimResponseCode.OK, json, this.responseHeaders());
    }

    @Override
    public ScimResponse userListResponse(SearchRequest req, SearchResult<ScimUser> res) {
        return this.toListResponse(res, this.fragmentMarshaller::userJson);
    }

    @Override
    public <T> ScimResponse simpleListResponse(List<T> items, Function1<T, JSONObject> itemMapper) {
        int count = items.size();
        return new ScimResponse(ScimResponseCode.OK, this.fragmentMarshaller.jsonListResponse(items, 1, count, count, itemMapper), this.responseHeaders());
    }

    HashMap<String, List<String>> responseHeaders(ScimObject scimObject) {
        return this.responseHeaders().put((Object)"ETag", List.of(scimObject.weakEtag()));
    }

    private <T extends ScimObject> ScimResponse toListResponse(SearchResult<T> res, Function1<T, JSONObject> itemMapper) {
        JSONObject json = this.fragmentMarshaller.jsonListResponse(res.getResults(), res.getStartIndex(), res.getItemsPerPage(), res.getTotalResults(), itemMapper);
        return new ScimResponse(ScimResponseCode.OK, json, this.responseHeaders());
    }
}

