/*
 * Decompiled with CFR 0.152.
 */
package com.ksso.scim.schema.evaluation.json;

import com.atlassian.json.jsonorg.JSONArray;
import com.atlassian.json.jsonorg.JSONObject;
import com.ksso.scim.ScimErrorType;
import com.ksso.scim.patch.AttributeFilterEvaluationVisitor;
import com.ksso.scim.schema.evaluation.json.JsonElementContext;
import com.ksso.scim.schema.evaluation.json.MutationContainerContext;
import com.ksso.scim.schema.evaluation.json.MutationContext;
import com.ksso.scim.schema.validation.ValidationError;
import io.vavr.collection.List;
import io.vavr.collection.Seq;
import io.vavr.collection.Traversable;
import io.vavr.control.Option;
import io.vavr.control.Validation;
import java.util.Iterator;
import java.util.Objects;
import org.antlr.v4.runtime.tree.ParseTree;

public class JsonContainerContext
extends JsonElementContext {
    private final Option<String> maybeKey;
    private final Option<JsonElementContext> parent;
    protected final JSONObject jsonObject;

    public JsonContainerContext(JSONObject jsonObject) {
        this(Option.none(), Option.none(), jsonObject);
    }

    public JsonContainerContext(Option<String> maybeKey, Option<JsonElementContext> parent, JSONObject jsonObject) {
        this.maybeKey = Objects.requireNonNull(maybeKey);
        this.parent = Objects.requireNonNull(parent);
        this.jsonObject = Objects.requireNonNull(jsonObject);
    }

    @Override
    public Object getValue() {
        return this.jsonObject;
    }

    @Override
    public List<MutationContext> getElementByKey(String key) {
        return Option.of(this.jsonObject.opt(key)).map(value -> this.toMutationContext(Option.of(key), value)).toList();
    }

    @Override
    public List<MutationContext> getByValueSelectionFilter(ParseTree filter) {
        return List.ofAll(io.vavr.collection.Iterator.ofAll(this.jsonObject.iterator())).map(key -> this.toMutationContext(Option.of(key), this.jsonObject.get((String)key))).filter(mc -> mc instanceof MutationContainerContext).filter(mc -> (Boolean)new AttributeFilterEvaluationVisitor((MutationContext)mc).visit(filter));
    }

    @Override
    public boolean evaluate(String operator, String criteria) {
        throw new RuntimeException("evaluate called on container context");
    }

    @Override
    public Validation<ValidationError, Void> insertValue(Seq<String> path, Object value) {
        String thisKey = (String)path.head();
        Traversable tail = path.tail();
        if (tail.isEmpty()) {
            this.jsonObject.put(thisKey, value);
            return Validation.valid(null);
        }
        Object opt = this.jsonObject.opt(thisKey);
        if (opt == null) {
            JSONObject container = new JSONObject();
            this.jsonObject.put(thisKey, container);
            JsonContainerContext next = (JsonContainerContext)this.toMutationContext(Option.of(thisKey), container);
            return next.insertValue((Seq<String>)tail, value);
        }
        MutationContext mc = this.toMutationContext(Option.of(thisKey), opt);
        if (mc instanceof MutationContainerContext) {
            return ((MutationContainerContext)mc).insertValue((Seq<String>)tail, value);
        }
        return Validation.invalid(new ValidationError(ScimErrorType.INVALID_PATH, String.format("%s along path %s is a primitive value, further insertion not possible", thisKey, path.mkString("."))));
    }

    @Override
    public Validation<ValidationError, Void> addValue(Object value) {
        if (!(value instanceof JSONObject)) {
            return Validation.invalid(new ValidationError(ScimErrorType.INVALID_VALUE, String.format("'%s': value must be JSONObject. Found: %s", this.maybeKey, value.getClass().getSimpleName())));
        }
        JSONObject newJsonObject = (JSONObject)value;
        Iterator<String> keys2 = newJsonObject.keys();
        keys2.forEachRemaining(key -> {
            Object existingValue = this.jsonObject.opt((String)key);
            Object newValue = newJsonObject.get((String)key);
            if (existingValue instanceof JSONArray) {
                JsonContainerContext.addValueToJsonArray((JSONArray)existingValue, newValue);
            } else {
                this.jsonObject.put((String)key, newValue);
            }
        });
        return Validation.valid(null);
    }

    @Override
    public Validation<ValidationError, Void> replace(Object newValue) {
        if (!(newValue instanceof JSONObject)) {
            return Validation.invalid(new ValidationError(ScimErrorType.INVALID_VALUE, "'" + this.maybeKey + "': value must be JSONObject. Found: " + newValue.getClass().getSimpleName()));
        }
        return this.parent.map(p -> p.replaceDescendant(this.maybeKey, this.jsonObject, newValue)).getOrElse(Validation.invalid(new ValidationError(ScimErrorType.INVALID_PATH, "Can't replace value for root container context (user or group).")));
    }

    @Override
    Validation<ValidationError, Void> replaceDescendant(Option<String> maybeKey, Object oldValue, Object value) {
        this.jsonObject.put(maybeKey.get(), value);
        return Validation.valid(null);
    }

    @Override
    Validation<ValidationError, Void> removeDescendant(Option<String> maybeKey, Object value) {
        this.jsonObject.remove(maybeKey.get());
        return Validation.valid(null);
    }

    @Override
    public Validation<ValidationError, Void> remove() {
        this.parent.peek(p -> p.removeDescendant(this.maybeKey, this.jsonObject));
        return Validation.valid(null);
    }

    public String toString() {
        return "JsonContainerContext{maybeKey=" + this.maybeKey + '}';
    }
}

