/*
 * Decompiled with CFR 0.152.
 */
package com.ksso.scim.schema.evaluation;

import com.ksso.scim.schema.evaluation.AbstractSimpleTypeEvaluator;
import org.apache.commons.lang3.StringUtils;

public class StringEvaluator
extends AbstractSimpleTypeEvaluator<String> {
    private final boolean caseSensitive;

    public StringEvaluator(String attributeValue, boolean caseSensitive) {
        super(attributeValue);
        this.caseSensitive = caseSensitive;
    }

    @Override
    String convert(String criteria) {
        return criteria;
    }

    @Override
    boolean eq(String other) {
        return this.compare(other) == 0;
    }

    @Override
    boolean co(String other) {
        return this.caseSensitive ? StringUtils.contains((CharSequence)this.attributeValue, other) : StringUtils.containsIgnoreCase((CharSequence)this.attributeValue, other);
    }

    @Override
    boolean sw(String other) {
        return this.caseSensitive ? StringUtils.startsWith((CharSequence)this.attributeValue, other) : StringUtils.startsWithIgnoreCase((CharSequence)this.attributeValue, other);
    }

    @Override
    boolean ew(String other) {
        return this.caseSensitive ? StringUtils.endsWith((CharSequence)this.attributeValue, other) : StringUtils.endsWithIgnoreCase((CharSequence)this.attributeValue, other);
    }

    @Override
    boolean gt(String other) {
        return this.compare(other) < 0;
    }

    @Override
    boolean lt(String other) {
        return this.compare(other) > 0;
    }

    @Override
    boolean ge(String other) {
        int v = this.compare(other);
        return v < 0 || v == 0;
    }

    @Override
    boolean le(String other) {
        int v = this.compare(other);
        return v > 0 || v == 0;
    }

    private int compare(String criteria) {
        return this.caseSensitive ? StringUtils.compare((String)this.attributeValue, criteria) : StringUtils.compareIgnoreCase((String)this.attributeValue, criteria);
    }
}

