/*
 * Decompiled with CFR 0.152.
 */
package com.ksso.scim.schema.evaluation;

import com.ksso.scim.schema.evaluation.AbstractSimpleTypeEvaluator;
import com.ksso.scim.util.JsonUtils;
import java.time.Instant;

public class DateTimeEvaluator
extends AbstractSimpleTypeEvaluator<Instant> {
    public DateTimeEvaluator(Instant instant) {
        super(instant);
    }

    @Override
    Instant convert(String criteria) {
        return JsonUtils.dateTimeToInstant(criteria);
    }

    @Override
    boolean eq(Instant other) {
        return ((Instant)this.attributeValue).equals(other);
    }

    @Override
    boolean co(Instant other) {
        throw new IllegalArgumentException("'co' not supported for dateTime");
    }

    @Override
    boolean sw(Instant other) {
        throw new IllegalArgumentException("'co' not supported for dateTime");
    }

    @Override
    boolean ew(Instant other) {
        throw new IllegalArgumentException("'co' not supported for dateTime");
    }

    @Override
    boolean gt(Instant other) {
        return ((Instant)this.attributeValue).isAfter(other);
    }

    @Override
    boolean lt(Instant other) {
        return ((Instant)this.attributeValue).isBefore(other);
    }

    @Override
    boolean ge(Instant other) {
        return ((Instant)this.attributeValue).isAfter(other) || other.equals(this.attributeValue);
    }

    @Override
    boolean le(Instant other) {
        return ((Instant)this.attributeValue).isBefore(other) || other.equals(this.attributeValue);
    }
}

