/*
 * Decompiled with CFR 0.152.
 */
package com.ksso.scim.schema.evaluation;

import com.ksso.scim.schema.evaluation.OperatorEvaluator;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractSimpleTypeEvaluator<T>
implements OperatorEvaluator {
    protected final T attributeValue;

    public AbstractSimpleTypeEvaluator(T attributeValue) {
        this.attributeValue = attributeValue;
    }

    @Override
    public final boolean evaluate(String operator, String criteria) {
        String op = StringUtils.lowerCase(operator);
        T converted = this.convert(criteria);
        switch (op) {
            case "eq": {
                return this.eq(converted);
            }
            case "co": {
                return this.co(converted);
            }
            case "sw": {
                return this.sw(converted);
            }
            case "ew": {
                return this.ew(converted);
            }
            case "gt": {
                return this.gt(converted);
            }
            case "lt": {
                return this.lt(converted);
            }
            case "ge": {
                return this.ge(converted);
            }
            case "le": {
                return this.le(converted);
            }
            case "ne": {
                return this.ne(converted);
            }
            case "pr": {
                return this.pr();
            }
        }
        throw new IllegalArgumentException("Invalid operator " + operator);
    }

    abstract T convert(String var1);

    abstract boolean eq(T var1);

    abstract boolean co(T var1);

    abstract boolean sw(T var1);

    abstract boolean ew(T var1);

    abstract boolean gt(T var1);

    abstract boolean lt(T var1);

    abstract boolean ge(T var1);

    abstract boolean le(T var1);

    final boolean ne(T other) {
        return !this.eq(other);
    }

    @Override
    public boolean pr() {
        return this.attributeValue != null;
    }
}

