/*
 * Decompiled with CFR 0.152.
 */
package com.ksso.scim.filter;

import com.ksso.scim.filter.ListErrorListener;
import com.ksso.scim.filter.NoRecoveryErrorHandler;
import com.ksso.scim.filter.ScimFilterLexer;
import com.ksso.scim.filter.ScimFilterParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;

public class FilterContextFactory {
    public static ScimFilterParser.PatchPathContext parsePatchPath(String filter) {
        ListErrorListener errorListener = new ListErrorListener();
        try {
            ScimFilterParser parser = FilterContextFactory.parser(filter, errorListener);
            return parser.patchPath();
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected SCIM filter parse exception", e);
        }
        catch (RecognitionException e) {
            throw new IllegalArgumentException(errorListener.getMessage(), e);
        }
    }

    public static ScimFilterParser.FilterContext parseFilter(String filter) {
        ListErrorListener errorListener = new ListErrorListener();
        try {
            ScimFilterParser parser = FilterContextFactory.parser(filter, errorListener);
            return parser.filter();
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected SCIM filter parse exception", e);
        }
        catch (RecognitionException e) {
            throw new IllegalArgumentException(errorListener.getMessage(), e);
        }
    }

    private static ScimFilterParser parser(String filter, ListErrorListener errorListener) throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(filter.getBytes(StandardCharsets.UTF_8));
        ScimFilterLexer lexer = new ScimFilterLexer(CharStreams.fromStream(is));
        lexer.removeErrorListeners();
        lexer.addErrorListener(errorListener);
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        ScimFilterParser parser = new ScimFilterParser(tokens);
        parser.setErrorHandler(new NoRecoveryErrorHandler());
        parser.removeErrorListeners();
        parser.addErrorListener(errorListener);
        return parser;
    }
}

