/*
 * Decompiled with CFR 0.152.
 */
package com.ksso.scim.atlassian.repository;

import com.atlassian.crowd.model.user.TimestampedUser;
import com.atlassian.crowd.model.user.UserWithAttributes;
import io.vavr.collection.List;
import io.vavr.collection.Map;
import io.vavr.control.Option;
import java.util.Date;

public class UserDTO {
    private final String userName;
    private final String displayName;
    private final String email;
    private boolean active;
    private final String id;
    private final Option<String> extId;
    private final Date createdDate;
    private final Date updatedDate;
    private final Option<String> managerId;

    private UserDTO(String userName, String displayName, String email, boolean active, Map<String, String> attributeMap) {
        this.userName = userName;
        this.displayName = displayName;
        this.email = email;
        this.active = active;
        this.id = attributeMap.get("ksso.scim.id").getOrElseThrow(() -> new RuntimeException("User " + userName + " has no " + "ksso.scim.id"));
        this.extId = attributeMap.get("ksso.scim.extId");
        this.managerId = attributeMap.get("ksso.scim.ue.managerId");
        this.createdDate = (Date)attributeMap.get("ksso.scim.created").map(Long::valueOf).map(Date::new).getOrElseThrow(() -> new RuntimeException("User " + userName + " has no created timestamp"));
        this.updatedDate = (Date)attributeMap.get("ksso.scim.lastModified").map(Long::valueOf).map(Date::new).getOrElseThrow(() -> new RuntimeException("User " + userName + " has no updated timestamp"));
    }

    public static UserDTO create(TimestampedUser user, Map<String, String> attributeMap) {
        return new UserDTO(user.getName(), user.getDisplayName(), user.getEmailAddress(), user.isActive(), attributeMap);
    }

    public static UserDTO create(UserWithAttributes userWithAttributes) {
        Map<String, String> attributeMap = List.ofAll(userWithAttributes.getKeys()).toMap(key -> key, key -> userWithAttributes.getValue(key));
        return new UserDTO(userWithAttributes.getName(), userWithAttributes.getDisplayName(), userWithAttributes.getEmailAddress(), userWithAttributes.isActive(), attributeMap);
    }

    public String getId() {
        return this.id;
    }

    public Option<String> getExtId() {
        return this.extId;
    }

    public Option<String> getManagerId() {
        return this.managerId;
    }

    public String getName() {
        return this.userName;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public Date getUpdatedDate() {
        return this.updatedDate;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getEmailAddress() {
        return this.email;
    }

    public boolean isActive() {
        return this.active;
    }

    public String toString() {
        return "UserDTO{userName='" + this.userName + '\'' + ", displayName='" + this.displayName + '\'' + ", email='" + this.email + '\'' + ", active=" + this.active + ", id='" + this.id + '\'' + ", extId=" + this.extId + ", createdDate=" + this.createdDate + ", updatedDate=" + this.updatedDate + '}';
    }
}

