/*
 * Decompiled with CFR 0.152.
 */
package com.ksso.scim.atlassian.repository;

import com.atlassian.crowd.model.group.Group;
import io.vavr.collection.Map;
import io.vavr.control.Option;
import java.util.Date;

public class GroupDTO {
    private String groupName;
    private final String id;
    private final Option<String> extId;
    private Date createdDate;
    private Date updatedDate;

    public static GroupDTO create(Group group, Map<String, String> attributeMap) {
        return new GroupDTO(group.getName(), attributeMap);
    }

    private GroupDTO(String groupName, Map<String, String> attributeMap) {
        this.groupName = groupName;
        this.id = attributeMap.get("ksso.scim.id").getOrElseThrow(() -> new RuntimeException("Group " + groupName + " has no " + "ksso.scim.id"));
        this.extId = attributeMap.get("ksso.scim.extId");
        this.createdDate = (Date)attributeMap.get("ksso.scim.created").map(Long::valueOf).map(Date::new).getOrElseThrow(() -> new RuntimeException("Group has no created ts: " + this.getName()));
        this.updatedDate = (Date)attributeMap.get("ksso.scim.lastModified").map(Long::valueOf).map(Date::new).getOrElseThrow(() -> new RuntimeException("Group has no updated ts: " + this.getName()));
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.groupName;
    }

    public Option<String> getExtId() {
        return this.extId;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public Date getUpdatedDate() {
        return this.updatedDate;
    }

    public String toString() {
        return "GroupDTO{groupName='" + this.groupName + '\'' + ", id='" + this.id + '\'' + ", extId=" + this.extId + ", createdDate=" + this.createdDate + ", updatedDate=" + this.updatedDate + '}';
    }
}

