/*
 * Decompiled with CFR 0.152.
 */
package com.ksso.scim.atlassian.repository;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.InvalidGroupException;
import com.atlassian.crowd.exception.InvalidMembershipException;
import com.atlassian.crowd.exception.InvalidUserException;
import com.atlassian.crowd.exception.MembershipAlreadyExistsException;
import com.atlassian.crowd.exception.MembershipNotFoundException;
import com.atlassian.crowd.exception.NestedGroupsNotSupportedException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.ReadOnlyGroupException;
import com.atlassian.crowd.exception.UserAlreadyExistsException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.manager.directory.DirectoryPermissionException;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.model.group.GroupWithAttributes;
import com.atlassian.crowd.model.group.InternalDirectoryGroup;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.model.user.UserTemplateWithAttributes;
import com.atlassian.crowd.model.user.UserWithAttributes;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.PropertyUtils;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.ksso.scim.ScimResource;
import com.ksso.scim.SearchResult;
import com.ksso.scim.atlassian.ScimMembershipDiff;
import com.ksso.scim.atlassian.hostapp.ScimHostApp;
import com.ksso.scim.atlassian.repository.AtlassianUserRepositoryException;
import com.ksso.scim.atlassian.repository.GroupDTO;
import com.ksso.scim.atlassian.repository.QueryTransformer;
import com.ksso.scim.atlassian.repository.ScimDirectorySearch;
import com.ksso.scim.atlassian.repository.UserDTO;
import com.ksso.scim.schema.requests.CreateGroupRequest;
import com.ksso.scim.schema.requests.CreateUserRequest;
import com.ksso.scim.schema.requests.MembershipRequest;
import com.ksso.scim.schema.requests.ReplaceGroupRequest;
import com.ksso.scim.schema.requests.ReplaceUserRequest;
import com.ksso.scim.schema.requests.SearchRequest;
import com.ksso.scim.schema.vo.ScimCommonAttr;
import com.ksso.scim.schema.vo.ScimGroup;
import com.ksso.scim.schema.vo.ScimGroupMember;
import com.ksso.scim.schema.vo.ScimName;
import com.ksso.scim.schema.vo.ScimUser;
import com.ksso.scim.schema.vo.ScimUserEnterpriseAttrs;
import com.ksso.scim.schema.vo.ScimUserGroup;
import com.ksso.scim.spi.SpiError;
import io.vavr.Tuple;
import io.vavr.Tuple0;
import io.vavr.collection.LinearSeq;
import io.vavr.collection.Map;
import io.vavr.collection.Seq;
import io.vavr.control.Either;
import io.vavr.control.Option;
import java.time.Instant;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;

public class AtlassianUserRepository {
    private static final io.vavr.collection.List<String> OPTIONAL_USER_KEYS = io.vavr.collection.List.of("ksso.scim.ue.managerId");
    private final TransactionTemplate txTemplate;
    private final ScimHostApp scimHostApp;
    private final DirectoryManager directoryManager;
    private final Directory directory;

    public AtlassianUserRepository(TransactionTemplate txTemplate, Directory directory, ScimHostApp scimHostApp) {
        this.txTemplate = txTemplate;
        this.directoryManager = scimHostApp.getDirectoryManager();
        this.directory = directory;
        this.scimHostApp = scimHostApp;
    }

    public SearchResult<ScimUser> searchUsers(SearchRequest req) {
        return (SearchResult)this.txTemplate.execute(() -> {
            try {
                ScimDirectorySearch search = new ScimDirectorySearch(this.directoryManager, this.directory);
                SearchResult<String> userNames = search.searchUsers(req);
                io.vavr.collection.List scimUsers = userNames.getResults().map(userName -> this.toUserDTO((String)userName)).map(user -> Tuple.of(user, this.findScimUserGroups(user.getName()))).map(t -> this.toScimUser((UserDTO)t._1, (io.vavr.collection.List)t._2)).toList();
                return new SearchResult(scimUsers, userNames.getStartIndex(), userNames.getTotalResults());
            }
            catch (DirectoryNotFoundException | OperationFailedException e) {
                throw new RuntimeException("Exception searching users", e);
            }
        });
    }

    public SearchResult<ScimGroup> searchGroups(SearchRequest req) {
        return (SearchResult)this.txTemplate.execute(() -> {
            try {
                ScimDirectorySearch search = new ScimDirectorySearch(this.directoryManager, this.directory);
                SearchResult<String> groups2 = search.searchGroups(req);
                LinearSeq scimGroups = groups2.getResults().map(groupName -> this.toGroupDTO((String)groupName)).flatMap(Function.identity()).map(g -> Tuple.of(g, this.findAllGroupMembers(g.getName()))).map(t -> this.toScimGroup((GroupDTO)t._1, (io.vavr.collection.List)t._2));
                return new SearchResult(scimGroups, groups2.getStartIndex(), groups2.getTotalResults());
            }
            catch (DirectoryNotFoundException | OperationFailedException e) {
                throw new RuntimeException("Exception searching groups", e);
            }
        });
    }

    public Option<ScimGroup> getGroupById(String gid) {
        return (Option)this.txTemplate.execute(() -> this.findGroupNameById(gid).map(groupName -> this.toGroupDTO((String)groupName)).flatMap(Function.identity()).map(groupWithAttributes -> Tuple.of(groupWithAttributes, this.findAllGroupMembers(groupWithAttributes.getName()))).map(tuple -> this.toScimGroup((GroupDTO)tuple._1, (io.vavr.collection.List)tuple._2)));
    }

    public ScimUser createUser(CreateUserRequest req) throws AtlassianUserRepositoryException {
        long directoryId = this.directory.getId();
        String uid = UUID.randomUUID().toString();
        UserTemplateWithAttributes template = this.toUserTemplate(req, directoryId, uid);
        return (ScimUser)this.txTemplate.execute(() -> {
            try {
                Either<String, Map<String, String>> groups2 = this.verifyGids((io.vavr.collection.List<String>)req.getGroups().map(m -> m.getValue()));
                if (groups2.isLeft()) {
                    throw new AtlassianUserRepositoryException(SpiError.MEMBERSHIP_UNKNOWN_GID, "Cannot create user, no group with id: " + groups2.getLeft());
                }
                UserWithAttributes userWithAttributes = this.directoryManager.addUser(directoryId, template, PasswordCredential.NONE);
                for (String groupName2 : groups2.get().values()) {
                    this.directoryManager.addUserToGroup(directoryId, userWithAttributes.getName(), groupName2);
                }
                io.vavr.collection.List<ScimUserGroup> memberships = groups2.get().values().map(groupName -> this.toGroupDTO((String)groupName)).flatMap(Function.identity()).map(group -> new ScimUserGroup(group.getId(), group.getName())).toList();
                UserDTO userDTO = UserDTO.create(userWithAttributes);
                return this.toScimUser(userDTO, memberships);
            }
            catch (UserAlreadyExistsException e) {
                throw new AtlassianUserRepositoryException(SpiError.USER_ALREADY_EXISTS, "User already exists: " + e.getUserName(), (Exception)((Object)e));
            }
            catch (DirectoryNotFoundException | GroupNotFoundException | InvalidCredentialException | InvalidUserException | MembershipAlreadyExistsException | OperationFailedException | ReadOnlyGroupException | UserNotFoundException | DirectoryPermissionException e) {
                throw new RuntimeException("Exception creating user", e);
            }
        });
    }

    private UserTemplateWithAttributes toUserTemplate(CreateUserRequest req, long directoryId, String uid) {
        UserTemplateWithAttributes template = new UserTemplateWithAttributes(req.getUserName(), directoryId);
        ScimName name = req.getName();
        name.getGivenName().peek(arg_0 -> ((UserTemplateWithAttributes)template).setFirstName(arg_0));
        name.getFamilyName().peek(arg_0 -> ((UserTemplateWithAttributes)template).setLastName(arg_0));
        req.getEmail().peek(arg_0 -> ((UserTemplateWithAttributes)template).setEmailAddress(arg_0));
        template.setDisplayName(name.getFormatted());
        template.setActive(req.isActive());
        long now = System.currentTimeMillis();
        template.setAttribute("ksso.scim.id", uid);
        template.setAttribute("ksso.scim.created", String.valueOf(now));
        template.setAttribute("ksso.scim.lastModified", String.valueOf(now));
        req.getExternalId().peek(id -> template.setAttribute("ksso.scim.extId", id));
        ScimUserEnterpriseAttrs enterpriseAttrs = req.getEnterpriseAttrs();
        if (enterpriseAttrs.isDefined()) {
            enterpriseAttrs.getManagerId().peek(managerId -> template.setAttribute("ksso.scim.ue.managerId", managerId));
        }
        return template;
    }

    public Option<ScimUser> getUserById(String uid) {
        return (Option)this.txTemplate.execute(() -> this.findUserNameById(uid).map(userName -> this.toUserDTO((String)userName)).map(userWithAttributes -> Tuple.of(userWithAttributes, this.findScimUserGroups(userWithAttributes.getName()))).map(tuple -> this.toScimUser((UserDTO)tuple._1, (io.vavr.collection.List)tuple._2)));
    }

    public ScimGroup createGroup(CreateGroupRequest req) throws AtlassianUserRepositoryException {
        return (ScimGroup)this.txTemplate.execute(() -> {
            String groupName = req.getDisplayName();
            GroupTemplate template = new GroupTemplate(groupName, this.directory.getId().longValue(), GroupType.GROUP);
            String gid = "G-" + UUID.randomUUID().toString();
            try {
                InternalDirectoryGroup group = (InternalDirectoryGroup)this.directoryManager.addGroup(this.directory.getId().longValue(), template);
                HashMap<String, Set> attrs = new HashMap<String, Set>();
                attrs.computeIfAbsent("ksso.scim.id", key -> new HashSet()).add(gid);
                req.getExternalId().peek(extId -> attrs.computeIfAbsent("ksso.scim.extId", key -> new HashSet()).add(extId));
                String now = String.valueOf(System.currentTimeMillis());
                attrs.computeIfAbsent("ksso.scim.created", key -> new HashSet()).add(now);
                attrs.computeIfAbsent("ksso.scim.lastModified", key -> new HashSet()).add(now);
                this.directoryManager.storeGroupAttributes(this.directory.getId().longValue(), group.getName(), attrs);
                Map<ScimResource, io.vavr.collection.List<ScimGroupMember>> grouped = req.getMembers().groupBy(ScimGroupMember::getResource);
                LinearSeq gids = grouped.get(ScimResource.GROUPS).getOrElse(io.vavr.collection.List.empty()).map(ScimGroupMember::getValue);
                LinearSeq uids = grouped.get(ScimResource.USERS).getOrElse(io.vavr.collection.List.empty()).map(ScimGroupMember::getValue);
                Either<String, Map<String, String>> maybeGroupMembers = this.verifyGids((io.vavr.collection.List<String>)gids);
                if (maybeGroupMembers.isLeft()) {
                    throw new AtlassianUserRepositoryException(SpiError.MEMBERSHIP_UNKNOWN_GID, "Can't assign nested group, no group with gid: " + maybeGroupMembers.getLeft());
                }
                Either<String, Map<String, String>> maybeUserMembers = this.verifyUids((io.vavr.collection.List<String>)uids);
                if (maybeUserMembers.isLeft()) {
                    throw new AtlassianUserRepositoryException(SpiError.MEMBERSHIP_UNKNOWN_UID, "Can't assign user member, no user with uid: " + maybeUserMembers.getLeft());
                }
                io.vavr.collection.List groupMembers = maybeGroupMembers.get().map(tuple -> new ScimGroupMember((String)tuple._1, (String)tuple._2, ScimResource.GROUPS)).toList();
                io.vavr.collection.List userMembers = maybeUserMembers.get().map(tuple -> new ScimGroupMember((String)tuple._1, (String)tuple._2, ScimResource.USERS)).toList();
                for (Object member : groupMembers) {
                    this.directoryManager.addGroupToGroup(this.directory.getId().longValue(), ((ScimGroupMember)member).getDisplay(), group.getName());
                }
                List userNames = userMembers.map(m -> m.getDisplay()).toJavaList();
                for (String userName : userNames) {
                    this.directoryManager.addUserToGroup(this.directory.getId().longValue(), userName, group.getName());
                }
                Map<String, String> attributeMap = io.vavr.collection.List.ofAll(attrs.entrySet()).filter(entry -> !((Set)entry.getValue()).isEmpty()).toMap(entry -> (String)entry.getKey(), entry -> (String)((Set)entry.getValue()).iterator().next());
                GroupDTO groupDTO = GroupDTO.create((Group)group, attributeMap);
                return this.toScimGroup(groupDTO, (io.vavr.collection.List<ScimGroupMember>)groupMembers.appendAll((Iterable)userMembers));
            }
            catch (InvalidGroupException e) {
                throw new AtlassianUserRepositoryException(SpiError.GROUP_ALREADY_EXISTS, "Group already exists: " + e.getGroup().getName(), (Exception)((Object)e));
            }
            catch (GroupNotFoundException e) {
                throw new AtlassianUserRepositoryException(SpiError.MEMBERSHIP_UNKNOWN_GID, "Could not add group member/nested group for " + e.getGroupName(), (Exception)((Object)e));
            }
            catch (DirectoryNotFoundException | InvalidMembershipException | MembershipAlreadyExistsException | NestedGroupsNotSupportedException | OperationFailedException | ReadOnlyGroupException | DirectoryPermissionException e) {
                throw new RuntimeException("Group creation failed", e);
            }
            catch (UserNotFoundException e) {
                throw new RuntimeException("Unexpectedly failed to add user to group: " + e.getUserName());
            }
        });
    }

    public ScimGroup replaceGroup(ReplaceGroupRequest req) throws AtlassianUserRepositoryException {
        return (ScimGroup)this.txTemplate.execute(() -> {
            boolean isRenameRequired;
            String gid = req.getId();
            Option<String> maybeGroupName = this.findGroupNameById(gid);
            if (maybeGroupName.isEmpty()) {
                throw new AtlassianUserRepositoryException(SpiError.GROUP_NOT_FOUND, "Cannot replace group, no group with gid: " + gid);
            }
            String targetName = req.getDisplayName();
            boolean bl = isRenameRequired = !maybeGroupName.get().equals(targetName);
            if (isRenameRequired) {
                this.renameGroup(gid, maybeGroupName.get(), targetName);
            }
            io.vavr.collection.List<ScimGroupMember> existingMembers = this.findAllGroupMembers(targetName);
            ScimMembershipDiff<ScimGroupMember> diff = new ScimMembershipDiff<ScimGroupMember>(existingMembers, req.getMembers());
            io.vavr.collection.List<ScimGroupMember> removals = diff.getRemovals();
            io.vavr.collection.List<ScimGroupMember> adds = diff.getAdds();
            try {
                for (ScimGroupMember removal : removals) {
                    if (removal.isGroup()) {
                        this.directoryManager.removeGroupFromGroup(this.directory.getId().longValue(), removal.getDisplay(), targetName);
                        continue;
                    }
                    this.directoryManager.removeUserFromGroup(this.directory.getId().longValue(), removal.getDisplay(), targetName);
                }
                for (ScimGroupMember add : adds) {
                    if (add.isGroup()) {
                        Option<String> maybeMemberGroup = this.findGroupNameById(add.getValue());
                        if (maybeMemberGroup.isEmpty()) {
                            throw new AtlassianUserRepositoryException(SpiError.MEMBERSHIP_UNKNOWN_GID, "Could not assign nested group, gid not found: " + add.getValue());
                        }
                        this.directoryManager.addGroupToGroup(this.directory.getId().longValue(), maybeMemberGroup.get(), targetName);
                        continue;
                    }
                    Option<String> addedUserName = this.findUserNameById(add.getValue());
                    if (addedUserName.isEmpty()) {
                        throw new AtlassianUserRepositoryException(SpiError.MEMBERSHIP_UNKNOWN_UID, "Could not assign group member, uid not found: " + add.getValue());
                    }
                    this.directoryManager.addUserToGroup(this.directory.getId().longValue(), addedUserName.get(), targetName);
                }
                HashMap<String, Set> attrs = new HashMap<String, Set>();
                req.getExternalId().peek(extId -> attrs.computeIfAbsent("ksso.scim.extId", key -> new HashSet()).add(extId));
                String now = String.valueOf(System.currentTimeMillis());
                attrs.computeIfAbsent("ksso.scim.lastModified", key -> new HashSet()).add(now);
                try {
                    this.directoryManager.storeGroupAttributes(this.directory.getId().longValue(), targetName, attrs);
                }
                catch (DirectoryNotFoundException | GroupNotFoundException | OperationFailedException | DirectoryPermissionException e) {
                    throw new RuntimeException("Could not update data for gid " + req.getId(), e);
                }
                GroupDTO dto = this.toGroupDTO(targetName).getOrElseThrow(() -> new RuntimeException("ksso.scim.id not present on group after rename ???"));
                return this.toScimGroup(dto, req.getMembers());
            }
            catch (DirectoryNotFoundException | GroupNotFoundException | InvalidMembershipException | MembershipAlreadyExistsException | MembershipNotFoundException | NestedGroupsNotSupportedException | OperationFailedException | ReadOnlyGroupException | UserNotFoundException | DirectoryPermissionException e) {
                throw new RuntimeException("Failed to update memberships for gid " + req.getId(), e);
            }
        });
    }

    public Boolean deleteUserById(String uid) {
        return (Boolean)this.txTemplate.execute(() -> this.getUserById(uid).map(user -> {
            try {
                this.directoryManager.removeUser(this.directory.getId().longValue(), user.getUserName());
                return Boolean.TRUE;
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to remove user " + user.getUserName() + " with id " + uid, e);
            }
        }).getOrElse(Boolean.FALSE));
    }

    public Boolean deleteGroupById(String gid) {
        return ((Option)this.txTemplate.execute(() -> this.getGroupById(gid).map(group -> {
            try {
                this.directoryManager.removeGroup(this.directory.getId().longValue(), group.getDisplayName());
                return Boolean.TRUE;
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to remove group " + group.getDisplayName() + " with id " + gid, e);
            }
        }))).getOrElse(Boolean.FALSE);
    }

    public ScimUser replaceUser(ReplaceUserRequest req) throws AtlassianUserRepositoryException {
        return (ScimUser)this.txTemplate.execute(() -> {
            boolean isRenameRequired;
            String uid = req.getId();
            Option<String> maybeUsername = this.findUserNameById(uid);
            if (maybeUsername.isEmpty()) {
                throw new AtlassianUserRepositoryException(SpiError.USER_NOT_FOUND, "Cannot replace user, no user with uid: " + uid);
            }
            String username = maybeUsername.get();
            boolean bl = isRenameRequired = !username.equals(req.getUserName());
            if (isRenameRequired) {
                try {
                    User renamed = this.directoryManager.renameUser(this.directory.getId().longValue(), username, req.getUserName());
                    username = renamed.getName();
                }
                catch (UserAlreadyExistsException e) {
                    throw new AtlassianUserRepositoryException(SpiError.USER_ALREADY_EXISTS, "Failed to rename user " + uid + ": Already exists", (Exception)((Object)e));
                }
                catch (DirectoryNotFoundException | InvalidUserException | OperationFailedException | UserNotFoundException | DirectoryPermissionException e) {
                    throw new RuntimeException(String.format("Exception renaming group %s with name '%s'", uid, username), e);
                }
            }
            io.vavr.collection.List<ScimUserGroup> existingGroups = this.findScimUserGroups(username);
            ScimMembershipDiff<ScimUserGroup> diff = new ScimMembershipDiff<ScimUserGroup>(existingGroups, req.getGroups());
            io.vavr.collection.List<ScimUserGroup> removals = diff.getRemovals();
            io.vavr.collection.List<ScimUserGroup> adds = diff.getAdds();
            try {
                for (ScimUserGroup scimUserGroup : removals) {
                    this.directoryManager.removeUserFromGroup(this.directory.getId().longValue(), username, scimUserGroup.getDisplay());
                }
                for (ScimUserGroup scimUserGroup : adds) {
                    Option<String> maybeGroupName = this.findGroupNameById(scimUserGroup.getValue());
                    if (maybeGroupName.isEmpty()) {
                        throw new AtlassianUserRepositoryException(SpiError.MEMBERSHIP_UNKNOWN_GID, "Cannot add group to user, gid not found: " + scimUserGroup.getValue());
                    }
                    this.directoryManager.addUserToGroup(this.directory.getId().longValue(), username, maybeGroupName.get());
                }
                UserTemplateWithAttributes template = this.toUserTemplate(req, this.directory.getId(), uid);
                for (String key : OPTIONAL_USER_KEYS) {
                    this.directoryManager.removeUserAttributes(this.directory.getId().longValue(), template.getName(), key);
                }
                this.directoryManager.storeUserAttributes(this.directory.getId().longValue(), username, template.getAttributes());
                User user = this.directoryManager.updateUser(this.directory.getId().longValue(), (UserTemplate)template);
                return this.toScimUser(this.toUserDTO(user.getName()), req.getGroups());
            }
            catch (DirectoryNotFoundException | GroupNotFoundException | InvalidUserException | MembershipAlreadyExistsException | MembershipNotFoundException | OperationFailedException | ReadOnlyGroupException | UserNotFoundException | DirectoryPermissionException e) {
                throw new RuntimeException("Failed to update memberships for gid " + req.getId(), e);
            }
        });
    }

    public void updateMemberships(Seq<MembershipRequest> reqs) {
        this.txTemplate.execute(() -> {
            reqs.forEach(req -> req.fold(addMembershipRequest -> {
                addMembershipRequest.uids.forEach(uid -> this.addUserOrGroupToGroup(addMembershipRequest.gid, (String)uid));
                return Tuple0.instance();
            }, removeMembershipRequest -> {
                this.removeUsersOrGroupsFromGroup(removeMembershipRequest.gid, removeMembershipRequest.uids);
                return Tuple0.instance();
            }, replaceMembersRequest -> {
                this.replaceMembers(replaceMembersRequest.gid, replaceMembersRequest.userIds);
                return Tuple0.instance();
            }));
            return Tuple0.instance();
        });
    }

    private void replaceMembers(String gid, io.vavr.collection.List<String> uids) {
        String groupName = this.findGroupNameById(gid).getOrElseThrow(() -> new AtlassianUserRepositoryException(SpiError.GROUP_NOT_FOUND, "Cannot add membership, group not found: " + gid));
        this.removeUsersOrGroupsFromGroup(gid, (io.vavr.collection.List<String>)this.findGroupToUserRelationships(groupName).appendAll(this.findGroupToGroupRelationships(groupName)));
        uids.forEach(uid -> this.addUserOrGroupToGroup(gid, (String)uid));
    }

    private void addUserOrGroupToGroup(String gid, String uid) {
        Either<GroupName, Username> groupOrUsername = this.findGroupNameOrUsernameById(uid).getOrElseThrow(() -> new AtlassianUserRepositoryException(SpiError.USER_OR_GROUP_NOT_FOUND, "Cannot add membership, user not found: " + uid));
        String groupName = this.findGroupNameById(gid).getOrElseThrow(() -> new AtlassianUserRepositoryException(SpiError.GROUP_NOT_FOUND, "Cannot add membership, group not found: " + gid));
        groupOrUsername.peekLeft(addedGroupName -> {
            try {
                this.directoryManager.addGroupToGroup(this.directory.getId().longValue(), addedGroupName.name, groupName);
            }
            catch (MembershipAlreadyExistsException membershipAlreadyExistsException) {
            }
            catch (DirectoryNotFoundException | GroupNotFoundException | InvalidMembershipException | NestedGroupsNotSupportedException | OperationFailedException | ReadOnlyGroupException | DirectoryPermissionException e) {
                throw new RuntimeException("Exception creating membership", e);
            }
        }).peek(username -> {
            try {
                this.directoryManager.addUserToGroup(this.directory.getId().longValue(), username.name, groupName);
            }
            catch (MembershipAlreadyExistsException membershipAlreadyExistsException) {
            }
            catch (DirectoryNotFoundException | GroupNotFoundException | OperationFailedException | ReadOnlyGroupException | UserNotFoundException | DirectoryPermissionException e) {
                throw new RuntimeException("Exception creating membership", e);
            }
        });
    }

    private void removeUsersOrGroupsFromGroup(String gid, io.vavr.collection.List<String> uids) {
        uids.flatMap(uid -> this.findGroupNameOrUsernameById((String)uid)).forEach(groupOrUsername -> this.findGroupNameById(gid).forEach(groupName -> groupOrUsername.peekLeft(addedGroupName -> {
            try {
                this.directoryManager.removeGroupFromGroup(this.directory.getId().longValue(), addedGroupName.name, groupName);
            }
            catch (MembershipNotFoundException membershipNotFoundException) {
            }
            catch (DirectoryNotFoundException | GroupNotFoundException | InvalidMembershipException | OperationFailedException | ReadOnlyGroupException | DirectoryPermissionException e) {
                throw new RuntimeException("Exception creating membership", e);
            }
        }).peek(username -> {
            try {
                this.directoryManager.removeUserFromGroup(this.directory.getId().longValue(), username.name, groupName);
            }
            catch (MembershipNotFoundException membershipNotFoundException) {
            }
            catch (DirectoryNotFoundException | GroupNotFoundException | OperationFailedException | ReadOnlyGroupException | UserNotFoundException | DirectoryPermissionException e) {
                throw new RuntimeException("Exception creating membership", e);
            }
        })));
    }

    private ScimGroup toScimGroup(GroupDTO group, io.vavr.collection.List<ScimGroupMember> members) {
        String id = group.getId();
        Option<String> extId = group.getExtId();
        Instant created = group.getCreatedDate().toInstant();
        Instant updated = group.getUpdatedDate().toInstant();
        ScimCommonAttr common = new ScimCommonAttr(id, extId, created, updated);
        return new ScimGroup(common, group.getName(), members);
    }

    private Option<GroupDTO> toGroupDTO(String groupName) {
        try {
            GroupWithAttributes groupWithAttributes = this.directoryManager.findGroupWithAttributesByName(this.directory.getId().longValue(), groupName);
            Map<String, String> attributeMap = io.vavr.collection.List.ofAll(groupWithAttributes.getKeys()).toMap(key -> key, key -> groupWithAttributes.getValue(key));
            if (!attributeMap.containsKey("ksso.scim.id")) {
                return Option.none();
            }
            GroupDTO dto = GroupDTO.create((Group)groupWithAttributes, attributeMap);
            return Option.of(dto);
        }
        catch (DirectoryNotFoundException | GroupNotFoundException | OperationFailedException e) {
            throw new RuntimeException("Failed to retrieve attributes for group " + groupName, e);
        }
    }

    private UserDTO toUserDTO(String userName) {
        try {
            UserWithAttributes userWithAttributes = this.directoryManager.findUserWithAttributesByName(this.directory.getId().longValue(), userName);
            return UserDTO.create(userWithAttributes);
        }
        catch (DirectoryNotFoundException | OperationFailedException | UserNotFoundException e) {
            throw new RuntimeException("Could not retrieve UserWithAttributes for: " + userName, e);
        }
    }

    private ScimUser toScimUser(UserDTO user, io.vavr.collection.List<ScimUserGroup> memberships) {
        String id = user.getId();
        Option<String> extId = user.getExtId();
        ScimCommonAttr common = new ScimCommonAttr(id, extId, user.getCreatedDate().toInstant(), user.getUpdatedDate().toInstant());
        ScimName name = new ScimName(user.getDisplayName());
        ScimUserEnterpriseAttrs enterpriseAttrs = new ScimUserEnterpriseAttrs(user.getManagerId());
        return new ScimUser(common, name, user.getName(), user.getEmailAddress(), user.isActive(), enterpriseAttrs, memberships);
    }

    private io.vavr.collection.List<String> findGroupToUserRelationships(String groupName) {
        try {
            MembershipQuery membershipQuery = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(groupName).startingAt(0).returningAtMost(-1);
            return io.vavr.collection.List.ofAll(this.directoryManager.searchDirectGroupRelationships(this.directory.getId().longValue(), membershipQuery));
        }
        catch (DirectoryNotFoundException | OperationFailedException e) {
            throw new RuntimeException("Could not retrieve nested group relationships for group: " + groupName, e);
        }
    }

    private io.vavr.collection.List<String> findGroupToGroupRelationships(String groupName) {
        try {
            MembershipQuery gmq = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).with(QueryTransformer.SCIM_ID_NOT_NULL_RESTRICTION).childrenOf(EntityDescriptor.group()).withName(groupName).startingAt(0).returningAtMost(-1);
            return io.vavr.collection.List.ofAll(this.directoryManager.searchDirectGroupRelationships(this.directory.getId().longValue(), gmq));
        }
        catch (DirectoryNotFoundException | OperationFailedException e) {
            throw new RuntimeException("Could not retrieve nested groups for group: " + groupName, e);
        }
    }

    private io.vavr.collection.List<String> findAllUserGroupRelationships(String username) {
        try {
            MembershipQuery membershipQuery = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(username).returningAtMost(-1);
            List relationships = this.directoryManager.searchDirectGroupRelationships(this.directory.getId().longValue(), membershipQuery);
            return io.vavr.collection.List.ofAll(relationships);
        }
        catch (DirectoryNotFoundException | OperationFailedException e) {
            throw new RuntimeException("Could not retrieve nested group relationships for user: " + username, e);
        }
    }

    private io.vavr.collection.List<ScimGroupMember> findAllGroupMembers(String groupName) {
        LinearSeq groupRelationships = this.findGroupToGroupRelationships(groupName).map(memberName -> this.toGroupDTO((String)memberName)).flatMap(Function.identity()).map(member -> this.toScimGroupMember((GroupDTO)member));
        LinearSeq userRelationships = this.findGroupToUserRelationships(groupName).map(userName -> this.toUserDTO((String)userName)).map(user -> this.toScimGroupMember((UserDTO)user));
        return groupRelationships.appendAll((Iterable)userRelationships);
    }

    private io.vavr.collection.List<ScimUserGroup> findScimUserGroups(String userName) {
        return this.findAllUserGroupRelationships(userName).map(groupName -> this.toGroupDTO((String)groupName)).flatMap(Function.identity()).map(group -> new ScimUserGroup(group.getId(), group.getName()));
    }

    private Option<String> findUserNameById(String uid) {
        try {
            EntityQuery query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)PropertyUtils.ofTypeString((String)"ksso.scim.id")).exactlyMatching((Object)uid)).returningAtMost(1);
            return io.vavr.collection.List.ofAll(this.directoryManager.searchUsers(this.directory.getId().longValue(), query)).toOption();
        }
        catch (DirectoryNotFoundException | OperationFailedException e) {
            throw new RuntimeException("Unexpected error looking up user by id: " + uid, e);
        }
    }

    private Option<String> findGroupNameById(String gid) {
        try {
            EntityQuery query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)Restriction.on((Property)PropertyUtils.ofTypeString((String)"ksso.scim.id")).exactlyMatching((Object)gid)).returningAtMost(1);
            return io.vavr.collection.List.ofAll(this.directoryManager.searchGroups(this.directory.getId().longValue(), query)).toOption();
        }
        catch (DirectoryNotFoundException | OperationFailedException e) {
            throw new RuntimeException("Unexpected error looking up group by id: " + gid, e);
        }
    }

    private Option<Either<GroupName, Username>> findGroupNameOrUsernameById(String id) {
        return this.findUserNameById(id).map(username -> Either.right(new Username((String)username))).orElse(() -> this.findGroupNameById(id).map(groupname -> Either.left(new GroupName((String)groupname))));
    }

    private Either<String, Map<String, String>> verifyGids(io.vavr.collection.List<String> gids) {
        return this.verifyIds(gids, this::findGroupNameById);
    }

    private Either<String, Map<String, String>> verifyUids(io.vavr.collection.List<String> uids) {
        return this.verifyIds(uids, this::findUserNameById);
    }

    private <V> Either<String, Map<String, V>> verifyIds(io.vavr.collection.List<String> ids, Function<String, Option<V>> lookup) {
        Map<String, V> result = io.vavr.collection.HashMap.empty();
        for (String id : ids) {
            Option<V> found = lookup.apply(id);
            if (found.isEmpty()) {
                return Either.left(id);
            }
            result = result.put(id, found.get());
        }
        return Either.right(result);
    }

    private ScimGroupMember toScimGroupMember(GroupDTO group) {
        return new ScimGroupMember(group.getId(), group.getName(), ScimResource.GROUPS);
    }

    private ScimGroupMember toScimGroupMember(UserDTO user) {
        return new ScimGroupMember(user.getId(), user.getName(), ScimResource.USERS);
    }

    private void renameGroup(String gid, String currentName, String targetName) {
        try {
            try {
                this.directoryManager.findGroupByName(this.directory.getId().longValue(), targetName);
                throw new AtlassianUserRepositoryException(SpiError.GROUP_ALREADY_EXISTS, String.format("Can't rename group with id %s from %s to %s: Already exists", gid, currentName, targetName));
            }
            catch (GroupNotFoundException groupNotFoundException) {
                this.directoryManager.renameGroup(this.directory.getId().longValue(), currentName, targetName);
            }
        }
        catch (AtlassianUserRepositoryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Failed to rename group %s with from '%s' to '%s'", gid, currentName, targetName), e);
        }
    }

    static final class Username {
        public final String name;

        Username(String name) {
            this.name = name;
        }
    }

    static final class GroupName {
        public final String name;

        GroupName(String name) {
            this.name = name;
        }
    }
}

