/*
 * Decompiled with CFR 0.152.
 */
package com.ksso.scim.atlassian.hostapp;

import com.atlassian.crowd.manager.application.ApplicationManager;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.ksso.scim.atlassian.hostapp.BambooScimHostApp;
import com.ksso.scim.atlassian.hostapp.BitbucketScimHostApp;
import com.ksso.scim.atlassian.hostapp.ConfluenceScimHostApp;
import com.ksso.scim.atlassian.hostapp.FecruScimHostApp;
import com.ksso.scim.atlassian.hostapp.ScimHostApp;
import com.ksso.scim.atlassian.hostapp.ScimJiraHostApp;
import javax.inject.Inject;

@Scanned
public class ScimHostAppFactory {
    private final ScimHostApp hostApp;

    @Inject
    public ScimHostAppFactory(@ComponentImport ApplicationProperties applicationProperties, DirectoryManager directoryManager, ApplicationManager applicationManager) {
        String dn = applicationProperties.getDisplayName().toLowerCase();
        if (dn.contains("jira")) {
            this.hostApp = new ScimJiraHostApp(directoryManager, applicationManager);
        } else if (dn.contains("confluence")) {
            this.hostApp = new ConfluenceScimHostApp(directoryManager, applicationManager);
        } else if (dn.contains("bitbucket")) {
            this.hostApp = new BitbucketScimHostApp(directoryManager, applicationManager);
        } else if (dn.contains("fisheye")) {
            this.hostApp = new FecruScimHostApp(directoryManager, applicationManager);
        } else if (dn.contains("bamboo")) {
            this.hostApp = new BambooScimHostApp(directoryManager, applicationManager);
        } else {
            throw new IllegalStateException("SCIM does not work on " + applicationProperties.getDisplayName());
        }
    }

    public ScimHostApp getHostApp() {
        return this.hostApp;
    }
}

