/*
 * Decompiled with CFR 0.152.
 */
package com.ksso.scim.atlassian.auth;

import com.ksso.scim.atlassian.auth.ApplicationSecret;
import com.ksso.scim.atlassian.auth.Credentials;
import com.ksso.scim.atlassian.auth.ScimAuthMethod;
import io.vavr.control.Option;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class BearerTokenCredentials
extends Credentials {
    private ApplicationSecret applicationSecret;
    private static final int VALID_CONFIG_LENGTH = 2;

    public BearerTokenCredentials(ApplicationSecret applicationSecret) {
        super(ScimAuthMethod.BEARER);
        this.applicationSecret = applicationSecret;
    }

    public static BearerTokenCredentials create(String salt, String hashedPassword) {
        return new BearerTokenCredentials(ApplicationSecret.create(salt, hashedPassword));
    }

    public static BearerTokenCredentials createHash(String salt, String plainTextPassword) {
        return new BearerTokenCredentials(ApplicationSecret.createHash(salt, plainTextPassword));
    }

    @Override
    public boolean isValid(HttpServletRequest request) {
        return Option.of(request).flatMap(this::extractBearerToken).map(this.applicationSecret::validateSecret).getOrElse(false);
    }

    private Option<String> extractBearerToken(HttpServletRequest request) {
        return Option.of(request).flatMap(this::getAuthHeader).map(auth -> StringUtils.substringAfter(auth, "Bearer ")).filter(StringUtils::isNotBlank);
    }

    public static Credentials fromConfig(String valueFromConfig) {
        return (Credentials)Option.of(valueFromConfig).map(conf -> conf.split(":")).filter(values2 -> ((String[])values2).length == 2).map(values2 -> BearerTokenCredentials.create(values2[0], values2[1])).getOrElseThrow(() -> new IllegalArgumentException("Invalid SCIM credentials format"));
    }

    @Override
    public String toConfig() {
        return this.applicationSecret.getSalt() + ":" + this.applicationSecret.getHashed();
    }
}

