/*
 * Decompiled with CFR 0.152.
 */
package com.ksso.scim.atlassian.auth;

import com.ksso.scim.atlassian.auth.ApplicationSecret;
import com.ksso.scim.atlassian.auth.Credentials;
import com.ksso.scim.atlassian.auth.ScimAuthMethod;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.control.Option;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class BasicAuthCredentials
extends Credentials {
    private final String username;
    private final ApplicationSecret applicationSecret;
    private static final int VALID_CONFIG_LENGTH = 3;

    private BasicAuthCredentials(String username, ApplicationSecret applicationSecret) {
        super(ScimAuthMethod.BASIC);
        this.username = Objects.requireNonNull(username);
        this.applicationSecret = Objects.requireNonNull(applicationSecret);
    }

    public static BasicAuthCredentials create(String username, String salt, String hashedPassword) {
        return new BasicAuthCredentials(username, ApplicationSecret.create(salt, hashedPassword));
    }

    public static BasicAuthCredentials createHash(String username, String salt, String plainTextPassword) {
        return new BasicAuthCredentials(username, ApplicationSecret.createHash(salt, plainTextPassword));
    }

    @Override
    public boolean isValid(HttpServletRequest request) {
        return Option.of(request).flatMap(this::extractUsernameAndPassword).map(this::validateUsernameAndPassword).getOrElse(false);
    }

    private Option<Tuple2<String, String>> extractUsernameAndPassword(HttpServletRequest request) {
        return Option.of(request).flatMap(this::getAuthHeader).map(auth -> StringUtils.substringAfter(auth, "Basic ")).filter(StringUtils::isNotBlank).toTry().mapTry(token -> Base64.getDecoder().decode(token.getBytes(StandardCharsets.UTF_8))).mapTry(bytes -> StringUtils.toEncodedString(bytes, StandardCharsets.UTF_8)).filterTry(credentials -> StringUtils.contains((CharSequence)credentials, ":")).mapTry(credentials -> credentials.split(":")).mapTry(credentials -> Tuple.of(credentials[0], credentials[1])).mapTry(credentials -> credentials.map(String::trim, String::trim)).filterTry(credentials -> StringUtils.isNotBlank((CharSequence)credentials._1) && StringUtils.isNotBlank((CharSequence)credentials._2)).toOption();
    }

    private Boolean validateUsernameAndPassword(Tuple2<String, String> credentials) {
        return this.username.equals(credentials._1) && this.applicationSecret.validateHash((String)credentials._2);
    }

    public static Credentials fromConfig(String valueFromConfig) {
        return (Credentials)Option.of(valueFromConfig).map(conf -> conf.split(":")).filter(values2 -> ((String[])values2).length == 3).map(values2 -> BasicAuthCredentials.create(values2[0], values2[1], values2[2])).getOrElseThrow(() -> new IllegalArgumentException("Invalid SCIM credentials format"));
    }

    @Override
    public String toConfig() {
        return this.username + ":" + this.applicationSecret.getSalt() + ":" + this.applicationSecret.getHashed();
    }

    public String toString() {
        return "BasicAuthCredentials{username='" + this.username + '\'' + ", applicationSecret=" + this.applicationSecret + '}';
    }
}

