/*
 * Decompiled with CFR 0.152.
 */
package com.ksso.scim.atlassian;

import com.ksso.scim.HttpRequestInfo;
import com.ksso.scim.ScimRequest;
import com.ksso.scim.ScimResponse;
import com.ksso.scim.event.ScimEventListener;
import io.vavr.collection.List;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;

public class ScimProvisioningEvents
implements ScimEventListener {
    public static final int MAX_SIZE = 35;
    private ConcurrentHashMap<String, List<Item>> tenantEvents = new ConcurrentHashMap();

    public List<Item> getEvents(String tenantId) {
        return Option.of(this.tenantEvents.get(tenantId)).getOrElse(List.empty());
    }

    public void pruneTenants(List<String> tenantIds) {
        this.tenantEvents.keySet().removeIf(key -> !tenantIds.contains((String)key));
    }

    @Override
    public void onScimResponse(ScimRequest req, ScimResponse res) {
        String tenantId = req.getTenantId();
        this.tenantEvents.compute(tenantId, (key, events) -> {
            if (events == null) {
                events = List.empty();
            } else if (events.length() >= 35) {
                events = events.drop(events.size() - 35);
            }
            return events.append(new Item(req, res));
        });
    }

    public void clear(String tenantId) {
        this.tenantEvents.remove(tenantId);
    }

    public static class Item {
        private final ScimRequest request;
        private final ScimResponse response;
        private final Date timestamp = new Date();

        public Item(ScimRequest request, ScimResponse response) {
            this.request = request;
            this.response = response;
        }

        public Date getTimestamp() {
            return this.timestamp;
        }

        public String getRequestLine() {
            HttpRequestInfo info = this.request.getRequestInfo();
            return info.getMethod() + " " + info.getRequestURI() + info.getQueryString().map(qs -> "?" + qs).getOrElse("");
        }

        public String getRequestBody() {
            return this.request.getJsonBody().map(json -> json.toString(4)).getOrElse("<empty>");
        }

        public String getResponseBody() {
            return this.response.getResponseJson().map(json -> json.toString(4)).getOrElse("<empty>");
        }

        public int getResponseCode() {
            return this.response.getStatus().intValue();
        }

        public String getRequestMethod() {
            return Try.of(() -> this.request).mapTry(ScimRequest::getMethod).mapTry(Enum::name).getOrElse("<unsupported>");
        }

        public String getInternalRequestURI() {
            return Try.of(() -> this.request).mapTry(ScimRequest::getRequestInfo).mapTry(HttpRequestInfo::getInternalRequestURI).getOrElse("<empty>");
        }

        public long getDurationNanos() {
            return this.response.getTs() - this.request.getTs();
        }
    }
}

