/*
 * Decompiled with CFR 0.152.
 */
package com.ksso.scim.atlassian;

import com.ksso.scim.SearchResult;
import com.ksso.scim.atlassian.auth.Credentials;
import com.ksso.scim.atlassian.repository.AtlassianUserRepository;
import com.ksso.scim.atlassian.repository.AtlassianUserRepositoryException;
import com.ksso.scim.schema.requests.CreateGroupRequest;
import com.ksso.scim.schema.requests.CreateUserRequest;
import com.ksso.scim.schema.requests.MembershipRequest;
import com.ksso.scim.schema.requests.ReplaceGroupRequest;
import com.ksso.scim.schema.requests.ReplaceUserRequest;
import com.ksso.scim.schema.requests.SearchRequest;
import com.ksso.scim.schema.vo.ScimGroup;
import com.ksso.scim.schema.vo.ScimUser;
import com.ksso.scim.spi.ScimServerSpi;
import com.ksso.scim.spi.SpiError;
import io.vavr.collection.Seq;
import io.vavr.control.Either;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlScimServerSpi
implements ScimServerSpi {
    public static final int MAX_RESULTS = -1;
    private static final Logger log = LoggerFactory.getLogger(AtlScimServerSpi.class);
    private final AtlassianUserRepository storage;
    private final Credentials credentials;

    public AtlScimServerSpi(AtlassianUserRepository storage, Credentials credentials) {
        this.storage = storage;
        this.credentials = credentials;
    }

    @Override
    public boolean isAuthenticated(HttpServletRequest request) {
        return this.credentials.isValid(request);
    }

    @Override
    public Either<SpiError, SearchResult<ScimUser>> searchUsers(SearchRequest params) {
        return Either.right(this.storage.searchUsers(params));
    }

    @Override
    public Either<SpiError, SearchResult<ScimGroup>> searchGroups(SearchRequest params) {
        return Either.right(this.storage.searchGroups(params));
    }

    @Override
    public Either<SpiError, ScimUser> getUserById(String uid) {
        return this.storage.getUserById(uid).toEither(SpiError.USER_NOT_FOUND);
    }

    @Override
    public Either<SpiError, ScimUser> createUser(CreateUserRequest req) {
        try {
            return Either.right(this.storage.createUser(req));
        }
        catch (AtlassianUserRepositoryException e) {
            this.logException(e);
            return Either.left(e.getSpiError());
        }
    }

    @Override
    public Either<SpiError, ScimGroup> createGroup(CreateGroupRequest req) {
        try {
            return Either.right(this.storage.createGroup(req));
        }
        catch (AtlassianUserRepositoryException e) {
            this.logException(e);
            return Either.left(e.getSpiError());
        }
    }

    @Override
    public Either<SpiError, ScimGroup> getGroupById(String gid) {
        return this.storage.getGroupById(gid).toEither(SpiError.GROUP_NOT_FOUND);
    }

    @Override
    public Either<SpiError, Boolean> deleteUserById(String uid) {
        Boolean deleted = this.storage.deleteUserById(uid);
        return deleted == Boolean.TRUE ? Either.right(Boolean.TRUE) : Either.left(SpiError.USER_NOT_FOUND);
    }

    @Override
    public Either<SpiError, Boolean> deleteGroupById(String gid) {
        Boolean deleted = this.storage.deleteGroupById(gid);
        return deleted == Boolean.TRUE ? Either.right(Boolean.TRUE) : Either.left(SpiError.GROUP_NOT_FOUND);
    }

    @Override
    public Either<SpiError, ScimUser> replaceUser(ReplaceUserRequest req) {
        try {
            return Either.right(this.storage.replaceUser(req));
        }
        catch (AtlassianUserRepositoryException e) {
            this.logException(e);
            return Either.left(e.getSpiError());
        }
    }

    @Override
    public Either<SpiError, ScimGroup> replaceGroup(ReplaceGroupRequest req) {
        try {
            return Either.right(this.storage.replaceGroup(req));
        }
        catch (AtlassianUserRepositoryException e) {
            this.logException(e);
            return Either.left(e.getSpiError());
        }
    }

    @Override
    public Either<SpiError, Seq<MembershipRequest>> updateMemberships(Seq<MembershipRequest> req) {
        try {
            this.storage.updateMemberships(req);
            return Either.right(req);
        }
        catch (AtlassianUserRepositoryException e) {
            this.logException(e);
            return Either.left(e.getSpiError());
        }
    }

    private void logException(AtlassianUserRepositoryException e) {
        log.debug("{}: {}/{}", new Object[]{e.getSpiError(), e.getClass().getSimpleName(), e.getMessage()});
    }
}

