/*
 * Decompiled with CFR 0.152.
 */
package com.ksso.scim;

import com.ksso.scim.HttpMethod;
import com.ksso.scim.ScimErrorType;
import com.ksso.scim.ScimLib;
import com.ksso.scim.ScimRequest;
import com.ksso.scim.ScimRequestContext;
import com.ksso.scim.ScimRequestReader;
import com.ksso.scim.ScimResource;
import com.ksso.scim.ScimResponse;
import com.ksso.scim.ScimResponseCode;
import com.ksso.scim.ScimResponseWriter;
import com.ksso.scim.ScimVersion;
import com.ksso.scim.schema.marshaller.ScimErrorMarshaller;
import com.ksso.scim.schema.marshaller.ScimResponseMarshallerFactory;
import com.ksso.scim.schema.validation.ValidationError;
import com.ksso.scim.service.ScimRequestHandler;
import com.ksso.scim.service.ScimServiceV1;
import com.ksso.scim.service.ScimServiceV2;
import com.ksso.scim.spi.ScimServerSpi;
import com.ksso.scim.web.ScimRoute;
import com.ksso.scim.web.ScimRouteBuilder;
import io.prometheus.client.Histogram;
import io.vavr.collection.List;
import io.vavr.control.Either;
import io.vavr.control.Try;
import java.io.IOException;
import java.util.function.Predicate;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ScimServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(ScimServlet.class);
    public static final Predicate<ScimRequestContext> SCIM_V2_SEARCH_PREDICATE;
    public static final Predicate<ScimRequestContext> SCIM_KNOWN_RESOURCE_ID_PREDICATE;
    public final ScimRequestHandler notImplementedHandler = ctx -> ScimResponseMarshallerFactory.errorMarshaller(ctx.getScimRequest().getScimVersion()).errorResponse(ScimResponseCode.NOT_IMPLEMENTED, "Endpoint not implemented");
    public final ScimRequestHandler notAllowedHandler = ctx -> ScimResponseMarshallerFactory.errorMarshaller(ctx.getScimRequest().getScimVersion()).errorResponse(ScimResponseCode.METHOD_NOT_ALLOWED, "Operation not allowed for this resource");
    private final ScimRoute router;

    public ScimServlet() {
        ScimServiceV1 scimServiceV1 = new ScimServiceV1();
        ScimServiceV2 scimServiceV2 = new ScimServiceV2();
        this.router = ScimRouteBuilder.defineRoute("/").subRoute(ScimRouteBuilder.defineRoute("/v1").scimVersion(ScimVersion.V1_1).subRoute(ScimRouteBuilder.defineRoute("/v1/Users").resource(ScimResource.USERS).subRoute(ScimRouteBuilder.defineRoute("GET /v1/Users/<id>").method(HttpMethod.GET).predicate(SCIM_KNOWN_RESOURCE_ID_PREDICATE).requestHandler(scimServiceV1::getUserById)).subRoute(ScimRouteBuilder.defineRoute("GET /v1/Users").method(HttpMethod.GET).requestHandler(scimServiceV1::getUsers)).subRoute(ScimRouteBuilder.defineRoute("POST /v1/Users").method(HttpMethod.POST).requestHandler(scimServiceV1::createUser)).subRoute(ScimRouteBuilder.defineRoute("PUT /v1/Users").method(HttpMethod.PUT).predicate(SCIM_KNOWN_RESOURCE_ID_PREDICATE).requestHandler(scimServiceV1::replaceUser)).subRoute(ScimRouteBuilder.defineRoute("PATCH /v1/Users").method(HttpMethod.PATCH).predicate(SCIM_KNOWN_RESOURCE_ID_PREDICATE).requestHandler(scimServiceV1::patchUser)).subRoute(ScimRouteBuilder.defineRoute("DELETE /v1/Users").method(HttpMethod.DELETE).predicate(SCIM_KNOWN_RESOURCE_ID_PREDICATE).requestHandler(scimServiceV1::deleteUser))).subRoute(ScimRouteBuilder.defineRoute("/v1/Groups").resource(ScimResource.GROUPS).subRoute(ScimRouteBuilder.defineRoute("GET /v1/Groups/<id>").method(HttpMethod.GET).predicate(SCIM_KNOWN_RESOURCE_ID_PREDICATE).requestHandler(scimServiceV1::getGroupById)).subRoute(ScimRouteBuilder.defineRoute("GET /v1/Groups").method(HttpMethod.GET).requestHandler(scimServiceV1::getGroups)).subRoute(ScimRouteBuilder.defineRoute("POST /v1/Groups").method(HttpMethod.POST).requestHandler(scimServiceV1::createGroup)).subRoute(ScimRouteBuilder.defineRoute("PUT /v1/Groups").method(HttpMethod.PUT).predicate(SCIM_KNOWN_RESOURCE_ID_PREDICATE).requestHandler(scimServiceV1::replaceGroup)).subRoute(ScimRouteBuilder.defineRoute("PATCH /v1/Groups").method(HttpMethod.PATCH).predicate(SCIM_KNOWN_RESOURCE_ID_PREDICATE).requestHandler(this.notImplementedHandler)).subRoute(ScimRouteBuilder.defineRoute("DELETE /v1/Groups").method(HttpMethod.DELETE).requestHandler(scimServiceV1::deleteGroup))).subRoute(ScimRouteBuilder.defineRoute("/v1/Schemas").resource(ScimResource.SCHEMAS).subRoute(ScimRouteBuilder.defineRoute("GET /v1/Schemas").method(HttpMethod.GET).requestHandler(scimServiceV1::getSchemas)).subRoute(ScimRouteBuilder.defineRoute("POST /v1/Schemas").method(HttpMethod.POST).requestHandler(this.notAllowedHandler))).subRoute(ScimRouteBuilder.defineRoute("/v1/ResourceTypes").resource(ScimResource.RESOURCE_TYPES).subRoute(ScimRouteBuilder.defineRoute("GET /v1/ResourceTypes").method(HttpMethod.GET).requestHandler(scimServiceV1::getResourceTypes)).subRoute(ScimRouteBuilder.defineRoute("POST /v1/ResourceTypes").method(HttpMethod.POST).requestHandler(this.notAllowedHandler))).subRoute(ScimRouteBuilder.defineRoute("/v1/Bulk").resource(ScimResource.BULK).method(HttpMethod.GET).requestHandler(this.notImplementedHandler)).subRoute(ScimRouteBuilder.defineRoute("/v1/ServiceProviderConfig").resource(ScimResource.SERVICE_PROVIDER_CONFIG).subRoute(ScimRouteBuilder.defineRoute("GET /v1/ServiceProviderConfig").method(HttpMethod.GET).requestHandler(scimServiceV1::getServiceProviderConfigs)).subRoute(ScimRouteBuilder.defineRoute("POST /v1/ServiceProviderConfig").method(HttpMethod.POST).requestHandler(this.notAllowedHandler)))).subRoute(ScimRouteBuilder.defineRoute("/v2").scimVersion(ScimVersion.V2_0).subRoute(ScimRouteBuilder.defineRoute("/v2/Users").resource(ScimResource.USERS).subRoute(ScimRouteBuilder.defineRoute("GET /v2/Users/<id>").method(HttpMethod.GET).predicate(SCIM_KNOWN_RESOURCE_ID_PREDICATE).requestHandler(scimServiceV2::getUserById)).subRoute(ScimRouteBuilder.defineRoute("POST /v2/Users/.search").method(HttpMethod.POST).predicate(SCIM_V2_SEARCH_PREDICATE).requestHandler(this.notImplementedHandler)).subRoute(ScimRouteBuilder.defineRoute("GET /v2/Users").method(HttpMethod.GET).requestHandler(scimServiceV2::getUsers)).subRoute(ScimRouteBuilder.defineRoute("POST /v2/Users").method(HttpMethod.POST).requestHandler(scimServiceV2::createUser)).subRoute(ScimRouteBuilder.defineRoute("PUT /v2/Users").method(HttpMethod.PUT).requestHandler(scimServiceV2::replaceUser)).subRoute(ScimRouteBuilder.defineRoute("PATCH /v2/Users").method(HttpMethod.PATCH).requestHandler(scimServiceV2::patchUser)).subRoute(ScimRouteBuilder.defineRoute("DELETE /v2/Users").method(HttpMethod.DELETE).requestHandler(scimServiceV2::deleteUser))).subRoute(ScimRouteBuilder.defineRoute("/v2/Groups").resource(ScimResource.GROUPS).subRoute(ScimRouteBuilder.defineRoute("GET /v2/Groups/<id>").method(HttpMethod.GET).predicate(SCIM_KNOWN_RESOURCE_ID_PREDICATE).requestHandler(scimServiceV2::getGroupById)).subRoute(ScimRouteBuilder.defineRoute("GET /v2/Groups").method(HttpMethod.GET).requestHandler(scimServiceV2::getGroups)).subRoute(ScimRouteBuilder.defineRoute("POST /v2/Groups/.search").method(HttpMethod.POST).predicate(SCIM_V2_SEARCH_PREDICATE).requestHandler(this.notImplementedHandler)).subRoute(ScimRouteBuilder.defineRoute("POST /v2/Groups").method(HttpMethod.POST).requestHandler(scimServiceV2::createGroup)).subRoute(ScimRouteBuilder.defineRoute("PUT /v2/Groups").method(HttpMethod.PUT).requestHandler(scimServiceV2::replaceGroup)).subRoute(ScimRouteBuilder.defineRoute("PATCH /v2/Groups").method(HttpMethod.PATCH).requestHandler(scimServiceV2::patchGroup)).subRoute(ScimRouteBuilder.defineRoute("DELETE /v2/Groups").method(HttpMethod.DELETE).requestHandler(scimServiceV2::deleteGroup))).subRoute(ScimRouteBuilder.defineRoute("/v2/Me").resource(ScimResource.ME).requestHandler(this.notImplementedHandler)).subRoute(ScimRouteBuilder.defineRoute("/v2/Schemas").resource(ScimResource.SCHEMAS).subRoute(ScimRouteBuilder.defineRoute("GET /v2/Schemas").method(HttpMethod.GET).requestHandler(scimServiceV2::getSchemas)).subRoute(ScimRouteBuilder.defineRoute("POST /v2/Schemas").method(HttpMethod.POST).requestHandler(this.notAllowedHandler))).subRoute(ScimRouteBuilder.defineRoute("/v2/ResourceTypes").resource(ScimResource.RESOURCE_TYPES).subRoute(ScimRouteBuilder.defineRoute("GET /v2/ResourceTypes").method(HttpMethod.GET).requestHandler(scimServiceV2::getResourceTypes)).subRoute(ScimRouteBuilder.defineRoute("POST /v2/ResourceTypes").method(HttpMethod.POST).requestHandler(this.notAllowedHandler))).subRoute(ScimRouteBuilder.defineRoute("/v2/Bulk").resource(ScimResource.BULK).requestHandler(this.notImplementedHandler)).subRoute(ScimRouteBuilder.defineRoute("/v2/ServiceProviderConfig").resource(ScimResource.SERVICE_PROVIDER_CONFIG).subRoute(ScimRouteBuilder.defineRoute("GET /v2/ServiceProviderConfig").method(HttpMethod.GET).requestHandler(scimServiceV2::getServiceProviderConfig)).subRoute(ScimRouteBuilder.defineRoute("POST /v2/ServiceProviderConfig").method(HttpMethod.POST).requestHandler(this.notAllowedHandler)))).build();
    }

    protected abstract Either<String, ScimServerSpi> getScimServerSpi(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        Histogram.Timer timer = ScimLib.Metrics.serviceLatency.startTimer();
        try {
            this.doService(servletRequest, servletResponse);
        }
        finally {
            timer.observeDuration();
        }
    }

    private void doService(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        try {
            ScimRequestReader reader = new ScimRequestReader(servletRequest);
            ScimResponseWriter writer = new ScimResponseWriter(servletResponse);
            Either<String, ScimRequest> maybeRequest = reader.parseRequest();
            if (maybeRequest.isLeft()) {
                ScimResponse errorResponse = ScimResponseMarshallerFactory.errorMarshaller(ScimVersion.V2_0).errorResponse(ScimResponseCode.BAD_REQUEST, List.of(new ValidationError(ScimErrorType.INVALID_PATH, "Invalid SCIM request")));
                writer.write(errorResponse);
                return;
            }
            ScimRequest req = maybeRequest.get();
            ScimVersion version = req.getScimVersion();
            ScimErrorMarshaller errorMarshaller = ScimResponseMarshallerFactory.errorMarshaller(version);
            ScimResponse scimResponse = this.getScimServerSpi(req.getTenantId()).map(spi -> new ScimRequestContext(req, (ScimServerSpi)spi)).fold(notFoundReason -> Try.of(() -> errorMarshaller.errorResponse(ScimResponseCode.NOT_FOUND, (String)notFoundReason)), ctx -> Try.of(() -> {
                if (!ctx.getSpi().isAuthenticated(servletRequest)) {
                    return errorMarshaller.errorResponse(ScimResponseCode.UNAUTHORIZED, "Not authorized for this operation");
                }
                return this.router.handle((ScimRequestContext)ctx);
            })).fold(throwable -> {
                log.error("Uncaught exception from handler function/service: {}", (Object)throwable.getMessage(), throwable);
                return errorMarshaller.errorResponse(ScimResponseCode.INTERNAL_SERVER_ERROR, "Internal server error");
            }, resp -> resp);
            ScimLib.dispatcher().notifyResponse(req, scimResponse);
            writer.write(scimResponse);
        }
        catch (IOException e) {
            log.debug("IOException handling SCIM request", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            log.error("Unexpected error", (Throwable)e);
            servletResponse.setStatus(500);
            servletResponse.getWriter().println("Unexpected error");
        }
    }

    static {
        Class<ScimLib.Metrics> clazz = ScimLib.Metrics.class;
        SCIM_V2_SEARCH_PREDICATE = ctx -> ctx.getScimRequest().getResourceId().map(id -> StringUtils.equals(".search", id)).getOrElse(false);
        SCIM_KNOWN_RESOURCE_ID_PREDICATE = ctx -> ctx.getScimRequest().getResourceId().map(StringUtils::isNotBlank).getOrElse(false);
    }
}

