/*
 * Decompiled with CFR 0.152.
 */
package com.ksso.scim;

import com.atlassian.json.jsonorg.JSONObject;
import com.ksso.scim.ScimResponseCode;
import io.vavr.collection.List;
import io.vavr.collection.Map;
import io.vavr.control.Option;
import java.util.Objects;

public class ScimResponse {
    private final ScimResponseCode status;
    private final JSONObject responseJson;
    private final Map<String, List<String>> responseHeaders;
    private final long ts;

    public ScimResponse(ScimResponseCode status, JSONObject responseJson, Map<String, List<String>> responseHeaders) {
        this.status = Objects.requireNonNull(status);
        this.responseJson = Objects.requireNonNull(responseJson);
        this.responseHeaders = Objects.requireNonNull(responseHeaders);
        this.ts = System.nanoTime();
    }

    public ScimResponse(ScimResponseCode status, Map<String, List<String>> responseHeaders) {
        this.responseHeaders = responseHeaders;
        this.status = status;
        this.responseJson = null;
        this.ts = System.nanoTime();
    }

    public ScimResponseCode getStatus() {
        return this.status;
    }

    public Option<JSONObject> getResponseJson() {
        return Option.of(this.responseJson);
    }

    public Map<String, List<String>> getResponseHeaders() {
        return this.responseHeaders;
    }

    public long getTs() {
        return this.ts;
    }
}

