/*
 * Decompiled with CFR 0.152.
 */
package com.ksso.scim;

import io.vavr.collection.List;
import io.vavr.collection.Map;
import io.vavr.control.Option;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;

public class ScimHeaders {
    private final Map<String, List<String>> headerMap;

    public ScimHeaders(Map<String, List<String>> headerMap) {
        this.headerMap = headerMap;
    }

    public Option<String> getXForwardedPort() {
        return this.peekHead("x-forwarded-port");
    }

    public Option<String> getXHttpMethodOverride() {
        return this.peekHead("x-http-method-override");
    }

    public Option<String> getXForwardedProto() {
        return this.peekHead("x-forwarded-proto");
    }

    public Option<String> getXForwardedHost() {
        return this.peekHead("x-forwarded-host");
    }

    public Option<String> getIfMatch() {
        return this.peekHead("if-match");
    }

    public Option<String> getIfNoneMatch() {
        return this.peekHead("if-none-match");
    }

    private Option<String> peekHead(String headerName) {
        return this.headerMap.get(StringUtils.lowerCase(headerName)).map(List::peekOption).flatMap(Function.identity());
    }

    public String toString() {
        return "ScimHeaders{" + this.headerMap + "}";
    }
}

