/*
 * Decompiled with CFR 0.152.
 */
package com.kantegasso.oidc;

import com.kantegasso.oidc.Actions;
import com.kantegasso.oidc.Util;
import io.jsonwebtoken.Claims;
import io.vavr.API;
import io.vavr.CheckedFunction1;
import io.vavr.Predicates;
import io.vavr.collection.HashMap;
import io.vavr.collection.List;
import io.vavr.control.Either;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.security.SecureRandom;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;
import org.json.JSONArray;
import org.json.JSONObject;

public class OidcProcedureData {
    private final HashMap<String, Object> data;
    private final SecureRandom secureRandom;
    private final OkHttpClient okHttpClient;
    final Predicate<String> isSensitive = Predicates.isIn("client_secret", "access_token", "nonce", "authorization_url", "authorization_code");
    final Predicate<String> isNotInternal = Predicates.not(Predicates.isIn("http_client", "secure_random"));
    final String NOT_DEFINED = "<NOT_DEFINED>";
    final String REDACTED = "<REDACTED>";

    OidcProcedureData(HashMap<String, Object> data, SecureRandom secureRandom, OkHttpClient okHttpClient) {
        this.data = Util.filterNulls(data).merge(HashMap.of("secure_random", secureRandom, "http_client", okHttpClient, "state", Util.generateUUID(), "nonce", Actions.Util.cryptoString(secureRandom)));
        this.secureRandom = secureRandom;
        this.okHttpClient = okHttpClient;
    }

    public Either<String, OidcProcedureData> discover() {
        return Actions.Discovery.run(this);
    }

    public Either<String, OidcProcedureData> authentication(List<String> scopes) {
        return Actions.Authentication.run(this, Util.filterNulls(scopes));
    }

    public Either<String, OidcProcedureData> resume(String maybeState, String maybeCode) {
        String state = Option.of(maybeState).getOrElse("");
        String code = Option.of(maybeCode).getOrElse("");
        return Actions.Resume.run(this, state, code);
    }

    public Either<String, OidcProcedureData> initiateSingleLogout() {
        return Actions.SessionManagement.run(this);
    }

    Either<String, OidcProcedureData> require(List<String> requirements) {
        return Actions.Util.require(this, requirements);
    }

    Either<String, OidcProcedureData> require(String requirement) {
        return Actions.Util.require(this, List.of(requirement));
    }

    SecureRandom getSecureRandom() {
        return this.secureRandom;
    }

    OkHttpClient getOkHttpClient() {
        return this.okHttpClient;
    }

    public OidcProcedureData update(HashMap<String, Object> otherConfig) {
        return new OidcProcedureData((HashMap<String, Object>)this.data.merge(Util.filterNulls(otherConfig)), this.secureRandom, this.okHttpClient);
    }

    public OidcProcedureData update(String key, Object value) {
        return this.update(HashMap.of(key, value));
    }

    private JSONObject sanitizeData(List<String> keys2) {
        return Try.of(() -> new JSONObject(keys2.toMap(k -> k, k -> this.get((String)k, (Class)Object.class).getOrElse("<NOT_DEFINED>")).filterKeys(this.isNotInternal).map((k, v) -> this.isSensitive.test((String)k) ? API.Tuple(k, "<REDACTED>") : API.Tuple(k, v)).toJavaMap())).getOrElse(new JSONObject().append("empty", "<NOT_DEFINED>"));
    }

    public Either<String, String> sanitizedStringRepresentation() {
        return Try.of(() -> new JSONObject(((HashMap)HashMap.of("configuration", List.of("client_id", "client_secret", "discovery_url", "workaround", "redirect_uri", "logout_uri", "authorization_url", "auth_method_used"), "discovery", List.ofAll(this.getDiscovery().map(JSONObject::keySet).getOrElse(HashSet::new)), "callback_data", List.of("state", "authorization_code"), "token_response", List.ofAll(this.getTokenResponse().map(JSONObject::keySet).getOrElse(HashSet::new)), "claims", List.ofAll(this.getClaims().map(Map::keySet).getOrElse(HashSet::new)), "userinfo", List.ofAll(this.getUserinfo().map(JSONObject::keySet).getOrElse(HashSet::new))).mapValues(this::sanitizeData)).toJavaMap()).toString()).fold(throwable -> Either.left(Actions.Util.createErrorMessage("OIDC-7PXMHRGIUI", "Failed to parse String representation.")), Either::right);
    }

    public <T> Option<T> get(String key, Class<T> type) {
        return this.data.get(key).orElse(Try.of(() -> (JSONObject)this.data.get("discovery").get()).mapTry(d -> d.get(key)).filter(Objects::nonNull).toOption()).orElse(Try.of(() -> (JSONObject)this.data.get("userinfo").get()).mapTry(d -> d.get(key)).filter(Objects::nonNull).toOption()).orElse(Try.of(() -> (Claims)this.data.get("claims").get()).mapTry(d -> d.get(key)).filter(Objects::nonNull).toOption()).orElse(Try.of(() -> (JSONObject)this.data.get("token_response").get()).mapTry(d -> d.get(key)).filter(Objects::nonNull).toOption()).flatMap(CheckedFunction1.lift(type::cast));
    }

    public Option<String> get(String key) {
        return this.get(key, String.class);
    }

    Option<JSONObject> getUserinfo() {
        return this.get("userinfo", JSONObject.class);
    }

    Option<JSONObject> getDiscovery() {
        return this.get("discovery", JSONObject.class);
    }

    public List<String> getScopesSupported() {
        return (List)API.Match(this.get("workaround").getOrElse("")).of(API.Case(API.$("github"), s -> List.of("read:user", "user:email")), API.Case(API.$(), () -> this.getDiscovery().toTry().mapTry(jsonObject -> jsonObject.getJSONArray("scopes_supported")).mapTry(JSONArray::toList).mapTry(List::ofAll).mapTry(listOfObjects -> listOfObjects.map(Object::toString)).getOrElse(List.empty())));
    }

    Option<Claims> getClaims() {
        return this.get("claims", Claims.class);
    }

    Option<JSONObject> getTokenResponse() {
        return this.get("token_response", JSONObject.class);
    }

    public Option<JSONObject> getProfile() {
        return this.get("profile", JSONObject.class);
    }

    public Option<String> getLogoutUri() {
        return this.get("logout_uri");
    }

    public boolean containsKey(String key) {
        return this.data.containsKey(key) || this.getDiscovery().map(json -> json.has(key)).getOrElse(false) != false || this.getUserinfo().map(json -> json.has(key)).getOrElse(false) != false || this.getClaims().map(claims -> claims.containsKey(key)).getOrElse(false) != false || this.getTokenResponse().map(json -> json.has(key)).getOrElse(false) != false;
    }

    public Either<String, String> dataAsJSONString() {
        return Try.of(() -> new JSONObject(this.data.toJavaMap()).toString()).fold(throwable -> Either.left(Actions.Util.createErrorMessage("OIDC-CISI9BYQJB", "Failed to parse json string")), Either::right);
    }

    public String toString() {
        return "OidcProcedureData{data=" + this.data.toJavaMap() + ", secureRandom=" + this.secureRandom + ", okHttpClient=" + this.okHttpClient + '}';
    }
}

