/*
 * Decompiled with CFR 0.152.
 */
package com.kantegasso.oidc;

import com.kantegasso.oidc.OidcProcedureData;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwsHeader;
import io.jsonwebtoken.Jwt;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SigningKeyResolverAdapter;
import io.vavr.API;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.Function1;
import io.vavr.Function2;
import io.vavr.Predicates;
import io.vavr.Tuple;
import io.vavr.collection.HashMap;
import io.vavr.collection.List;
import io.vavr.collection.Map;
import io.vavr.control.Either;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.math.BigInteger;
import java.net.URLEncoder;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.util.Base64;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import okhttp3.Credentials;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.json.JSONArray;
import org.json.JSONObject;

class Actions {
    Actions() {
    }

    static class SessionManagement {
        SessionManagement() {
        }

        static Either<String, OidcProcedureData> run(OidcProcedureData oidcProcedureData) {
            return oidcProcedureData.require(List.of("end_session_endpoint", "post_logout_redirect_uri")).map(SessionManagement::buildLogoutURI).map(logoutUri -> oidcProcedureData.update("logout_uri", logoutUri));
        }

        private static String buildLogoutURI(OidcProcedureData data) {
            String[] stringArray = new String[2];
            stringArray[0] = data.get("end_session_endpoint").getOrElse("");
            stringArray[1] = List.of("post_logout_redirect_uri").filter(data::containsKey).map(parameter -> Try.of(() -> URLEncoder.encode(data.get((String)parameter).getOrElse(""), "UTF-8")).filter(url -> !url.isEmpty()).map(url -> String.format("%s=%s", parameter, url)).getOrElse("")).intersperse("&").foldLeft("?", String::concat);
            return List.of(stringArray).map(logoutUri -> logoutUri.equals("?") ? "" : logoutUri).foldLeft("", String::concat);
        }
    }

    static class Resume {
        static final Function2<Either<String, JSONObject>, OidcProcedureData, Either<String, JSONObject>> validateUserInfo = Function2.of((eitherUserinfo, data) -> eitherUserinfo.filterOrElse(json -> json.getString("sub").equals(data.get("claims", Claims.class).get().getSubject()), invalidJson -> Util.createErrorMessage("OIDC-HQP1VZ666O", "Invalid \"sub\"-claim: Value differs between ID Token and Userinfo.")));

        Resume() {
        }

        static Either<String, OidcProcedureData> run(OidcProcedureData oidcProcedureData, String maybeState, String maybeCode) {
            String state = Option.of(maybeState).getOrElse("");
            String code = Option.of(maybeCode).getOrElse("");
            return (Either)API.Match(oidcProcedureData.get("workaround").getOrElse("")).of(API.Case(API.$(Predicate.isEqual("github")), s -> Resume.githubResume(oidcProcedureData, code)), API.Case(API.$(), s -> Resume.generic(oidcProcedureData, state, code)));
        }

        static Either<String, OidcProcedureData> githubResume(OidcProcedureData oidcProcedureData, String code) {
            return oidcProcedureData.require(List.empty()).map(data -> data.update("token_endpoint", "https://github.com/login/oauth/access_token")).flatMap(data -> Resume.fetchAccessTokenFromGitHub(code, data)).flatMap(data -> Http.getJson(data.getOkHttpClient(), "https://api.github.com/user", HashMap.of("Authorization", String.format("token %s", data.get("access_token").getOrElse(""))), JSONObject.class).map(json -> data.update("userinfo", json))).flatMap(data -> Http.getJson(data.getOkHttpClient(), "https://api.github.com/user/emails", HashMap.of("Authorization", String.format("token %s", data.get("access_token").getOrElse(""))), JSONArray.class).map(jsonArray -> data.update("email", Resume.extractGitHubEmailFromJsonArray(jsonArray).getOrElse("")))).filterOrElse(data -> data.get("email").getOrElse("").contains("@"), invalidData -> Util.createErrorMessage("OIDC-3EVSVDCK31", String.format("Unable to retrieve valid e-mail from GitHub. Found: %s", invalidData.get("email").getOrNull()))).flatMap(data -> Try.of(() -> data.get("userinfo", JSONObject.class).get()).mapTry(userInfoJson -> userInfoJson.put("email", data.get("email").get())).toEither(Util.createErrorMessage("OIDC-EPGC7W35CM", "Unable to consolidate Github Claims into user profile.")).map(profileJson -> data.update("profile", profileJson)));
        }

        private static Option<String> extractGitHubEmailFromJsonArray(JSONArray jsonArray) {
            jsonArray = Option.of(jsonArray).getOrElse(new JSONArray());
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject emailObject = jsonArray.optJSONObject(i);
                if (!emailObject.optBoolean("primary")) continue;
                return Option.of(emailObject.optString("email"));
            }
            return Option.none();
        }

        static Either<String, OidcProcedureData> generic(OidcProcedureData oidcProcedureData, String state, String code) {
            Option<String> maybeState = Option.of(state);
            Option<String> maybeCode = Option.of(code);
            return oidcProcedureData.require(List.of("client_id", "client_secret", "token_endpoint", "issuer", "redirect_uri", "state", "nonce")).filterOrElse(data -> data.get("state").equals(maybeState), invalidData -> Util.createErrorMessage("OIDC-IQ1QPNB9NK", String.format("OIDC state mismatch. Expected %s, but got %s.", invalidData.get("state").get(), maybeState))).flatMap(data -> Resume.fetchIdTokenFromIdp(maybeCode, data)).filterOrElse(Resume::assertBearerToken, invalidData -> Util.createErrorMessage("OIDC-RV67SUJAG2", "OIDC token type required to be 'Bearer' unless otherwise negotiated.")).flatMap(Resume::parseAndValidateIdToken).flatMap(Resume::getUserInfoJson).flatMap(data -> Resume.consolidateProfileData(data.get("claims", Claims.class).get(), data.get("userinfo", JSONObject.class).getOrElse(new JSONObject())).map(profileDataJson -> data.update("profile", profileDataJson)));
        }

        static Either<String, OidcProcedureData> parseAndValidateIdToken(OidcProcedureData data) {
            Predicate<Object> isAllowListedIssuer = Predicates.isIn((Object[])data.get("issuer_allowlist", String[].class).getOrElse(new String[0]));
            JwtParser jwtParser = Jwts.parserBuilder().require("nonce", data.get("nonce").getOrElse("")).setAllowedClockSkewSeconds(300L).setSigningKeyResolver(new SigningKeyResolverImpl(data.getOkHttpClient(), data.get("jwks_uri").getOrElse(""))).build();
            return data.get("token_response", JSONObject.class).toEither(Util.createErrorMessage("OIDC-TEL61YMCM0", "token_response missing.")).map(tokenResponse -> Try.of(() -> tokenResponse.getString("id_token"))).flatMap(maybeToken -> maybeToken.fold(throwable -> Either.left(Util.createErrorMessage("OIDC-ZJLKDA3Y6O", throwable.getMessage())), Either::right)).map(idTokenString -> List.of(API.Function(signedIdToken -> Try.of(() -> signedIdToken).filterTry(jwtParser::isSigned).mapTry(jwtParser::parseClaimsJws).mapTry(Jwt::getBody).toEither().mapLeft(t -> Util.createErrorMessage("OIDC-ELBJ4LUBCQ", "Unable to parse id_token as RSA-signed JWT: " + t.getMessage()))), API.Function(unsignedIdToken -> Try.of(() -> unsignedIdToken).filterTry(_idTokenString -> Util.isUsingHttps(data.get("token_endpoint"))).mapTry(jwtParser::parseClaimsJwt).mapTry(Jwt::getBody).toEither().mapLeft(t -> Util.createErrorMessage("OIDC-F288ZJRZ6R", "Unable to parse id_token as TLS-transported, unsigned JWT: " + t.getMessage())))).map(f -> (Either)f.apply(idTokenString))).filterOrElse(idTokenParsingAttempts -> idTokenParsingAttempts.map(Either::isRight).fold(false, Boolean::logicalOr), idTokenParsingAttempts -> Util.createErrorMessage("OIDC-UXBRKQ93GH", List.of(String.format("Failed to parse id_token: %s", data.get("token_response", JSONObject.class).map(tokenResponse -> tokenResponse.getString("id_token")).getOrElse("< MISSING >"))).appendAll((Iterable)idTokenParsingAttempts.filter(Either::isLeft).map(Either::getLeft)).intersperse(" | ").fold("", String::concat))).flatMap(idTokenParsingAttempts -> (Either)idTokenParsingAttempts.filter(Either::isRight).get()).filterOrElse(claims -> Option.of(claims.getIssuer()).filter(Predicates.anyOf(Predicates.is(data.get("issuer").getOrElse("")), isAllowListedIssuer)).orElse(Try.of(() -> claims.get("tid", String.class)).toOption().filter(isAllowListedIssuer)).isDefined(), invalidClaims -> Util.createErrorMessage("OIDC-4MKEL6LIBS", "Issuer of ID Token not trusted.")).filterOrElse(claims -> Try.of(() -> new JSONArray(Option.of(claims.getAudience()).getOrElse(""))).recover(throwable -> new JSONArray().put(Option.of(claims.getAudience()).getOrElse(""))).mapTry(jsonArray -> List.ofAll(jsonArray.toList()).map(Object::toString).filter(s -> s.length() > 0).contains(data.get("client_id").getOrElse(""))).getOrElse(false), invalidClaims -> Util.createErrorMessage("OIDC-QE4SODB4P1", "Expected aud claim to be: " + (String)data.get("client_id").getOrNull() + ", but was: " + invalidClaims.get("aud"))).filterOrElse(claims -> !claims.getSubject().isEmpty(), invalidClaims -> Util.createErrorMessage("OIDC-STFHQ38H2J", "ID Token is REQUIRED to contain a subject identifier (sub parameter). Keys that exist in claims: " + invalidClaims.keySet().toString())).map(claims -> data.update("claims", claims));
        }

        private static Boolean assertBearerToken(OidcProcedureData data) {
            return data.get("token_response", JSONObject.class).map(json -> json.optString("token_type", "")).map(maybeBearerString -> maybeBearerString.equalsIgnoreCase("Bearer")).getOrElse(false);
        }

        private static Either<String, OidcProcedureData> fetchIdTokenFromIdp(Option<String> code, OidcProcedureData data) {
            List authMethodsSupported = data.get("token_endpoint_auth_methods_supported", JSONArray.class).map(JSONArray::toList).map(List::ofAll).map(list -> list.map(Object::toString)).getOrElse(List.empty());
            return API.Match(authMethodsSupported).option(API.Case(API.$(supported -> supported.contains("client_secret_basic")), API.Function(Resume::fetchIdTokenFromIdpWithBasicAuth)), API.Case(API.$(supported -> supported.contains("client_secret_post")), API.Function(Resume::fetchIdTokenFromIdpWithPostAuth)), API.Case(API.$(supported -> supported.contains("none")), API.Function(Resume::fetchIdTokenFromIdpWithNoAuth))).map(func -> (Either)func.apply(code, data)).getOrElse(Either.left("token_endpoint_auth_methods_supported at IDP not compatible."));
        }

        private static Either<String, OidcProcedureData> fetchIdTokenFromIdpWithBasicAuth(Option<String> code, OidcProcedureData data) {
            return Http.postForJson(data.getOkHttpClient(), data.get("token_endpoint").get(), HashMap.ofEntries(Tuple.of("Content-Type", "application/x-www-form-urlencoded"), Tuple.of("Authorization", Credentials.basic(data.get("client_id").getOrElse(""), data.get("client_secret").getOrElse("")))), HashMap.of("grant_type", "authorization_code", "code", code.getOrElse(""), "redirect_uri", data.get("redirect_uri").getOrElse(""))).map(tokenJson -> data.update("token_response", tokenJson).update("auth_method_used", "client_secret_basic"));
        }

        private static Either<String, OidcProcedureData> fetchIdTokenFromIdpWithPostAuth(Option<String> code, OidcProcedureData data) {
            return Http.postForJson(data.getOkHttpClient(), data.get("token_endpoint").get(), HashMap.of("Content-Type", "application/x-www-form-urlencoded"), HashMap.of("grant_type", "authorization_code", "code", code.getOrElse(""), "client_id", data.get("client_id").getOrElse(""), "client_secret", data.get("client_secret").getOrElse(""), "redirect_uri", data.get("redirect_uri").getOrElse(""))).map(tokenJson -> data.update("token_response", tokenJson).update("auth_method_used", "client_secret_post"));
        }

        private static Either<String, OidcProcedureData> fetchIdTokenFromIdpWithNoAuth(Option<String> code, OidcProcedureData data) {
            return Http.postForJson(data.getOkHttpClient(), data.get("token_endpoint").get(), HashMap.of("Content-Type", "application/x-www-form-urlencoded"), HashMap.of("grant_type", "authorization_code", "code", code.getOrElse(""), "redirect_uri", data.get("redirect_uri").getOrElse(""))).map(tokenJson -> data.update("token_response", tokenJson).update("auth_method_used", "none"));
        }

        private static Either<String, OidcProcedureData> fetchAccessTokenFromGitHub(String code, OidcProcedureData data) {
            Function1<String, String> extractToken = Function1.of(s -> {
                Matcher matcher = Pattern.compile("access_token=([^&]+)").matcher((CharSequence)s);
                return matcher.find() ? matcher.group(1).trim() : "";
            });
            return Http.post(data.getOkHttpClient(), data.get("token_endpoint").get(), HashMap.of("Content-Type", "application/x-www-form-urlencoded", "Authorization", Credentials.basic(data.get("client_id").getOrElse(""), data.get("client_secret").getOrElse(""))), HashMap.of("grant_type", "authorization_code", "code", code, "redirect_uri", data.get("redirect_uri").getOrElse(""))).map(extractToken).map(accessToken -> data.update("access_token", accessToken));
        }

        static Either<String, OidcProcedureData> getUserInfoJson(OidcProcedureData data) {
            return data.get("access_token").isEmpty() || data.get("userinfo_endpoint").isEmpty() ? Either.right(data) : validateUserInfo.apply(Http.getJson(data.getOkHttpClient(), data.get("userinfo_endpoint").getOrElse(""), HashMap.of("Authorization", "Bearer " + data.get("access_token").getOrElse("")), JSONObject.class), data).map(userinfoJson -> data.update("userinfo", userinfoJson));
        }

        private static Either<String, JSONObject> consolidateProfileData(Claims claims, JSONObject json) {
            return Try.of(() -> new JSONObject(((HashMap)HashMap.ofAll(claims).merge(HashMap.ofAll(json.toMap()))).toJavaMap())).toEither(Util.createErrorMessage("OIDC-K9UTXCQQTQ", "Unable to consolidate data from ID Token and UserInfo-endpoint."));
        }
    }

    static class Authentication {
        Authentication() {
        }

        static Either<String, OidcProcedureData> run(OidcProcedureData oidcProcedureData, List<String> scopes) {
            return (Either)API.Match(oidcProcedureData.get("workaround").getOrElse("")).of(API.Case(API.$(Predicate.isEqual("github")), s -> Authentication.githubAuthentication(oidcProcedureData, scopes)), API.Case(API.$(), s -> Authentication.generic(oidcProcedureData, scopes)));
        }

        static Either<String, OidcProcedureData> generic(OidcProcedureData oidcProcedureData, List<String> scopes) {
            return oidcProcedureData.require(List.of("authorization_endpoint", "client_id", "redirect_uri", "secure_random", "http_client", "state", "nonce")).map(data -> data.update("authorization_url", Util.buildUrl(data.get("authorization_endpoint").getOrElse(""), Authentication.getEntries(scopes, data))));
        }

        private static HashMap<String, String> getEntries(List<String> scopes, OidcProcedureData data) {
            return ((HashMap)HashMap.ofEntries(List.of("client_id", "redirect_uri", "state", "nonce", "login_hint").map(s -> Tuple.of(s, data.get((String)s).getOrElse("")))).merge(HashMap.of("scope", Authentication.compileScope(scopes), "response_type", "code"))).merge((Map)API.Match(data.get("workaround").getOrElse("")).of(API.Case(API.$(Predicate.isEqual("azure_ad")), s -> HashMap.of("domain_hint", data.get("domain_hint").getOrElse(""))), API.Case(API.$(Predicate.isEqual("google")), s -> HashMap.of("hd", data.get("domain_hint").getOrElse(""))), API.Case(API.$(), s -> HashMap.empty())));
        }

        static Either<String, OidcProcedureData> githubAuthentication(OidcProcedureData oidcProcedureData, List<String> scopes) {
            String authorizationEndpoint = "https://github.com/login/oauth/authorize";
            return oidcProcedureData.require(List.of("client_id", "redirect_uri", "secure_random", "http_client")).map(data -> data.update("authorization_endpoint", "https://github.com/login/oauth/authorize")).flatMap(data -> Authentication.generic(data, scopes));
        }

        static String compileScope(List<String> scopes) {
            return Option.of(scopes).getOrElse(List.empty()).filter(Objects::nonNull).map(String::trim).filter(s -> !s.isEmpty()).distinct().intersperse(" ").foldLeft("", String::concat);
        }
    }

    static class Discovery {
        Discovery() {
        }

        static Either<String, OidcProcedureData> run(OidcProcedureData oidcProcedureData) {
            return oidcProcedureData.require("discovery_url").flatMap(data -> data.get("discovery_url", String.class).toEither(Util.createErrorMessage("OIDC-ANOESIZ585", "Failed to retrieve Discovery URL.")).flatMap(discoveryUrl -> Http.getJson(oidcProcedureData.getOkHttpClient(), discoveryUrl, HashMap.empty(), JSONObject.class)).map(json -> oidcProcedureData.update(HashMap.of("discovery", json))));
        }
    }

    static class Util {
        Util() {
        }

        static Either<String, OidcProcedureData> require(OidcProcedureData oidcProcedureData, List<String> requirements) {
            if (requirements.forAll(oidcProcedureData::containsKey)) {
                return Either.right(oidcProcedureData);
            }
            return Either.left(Util.createErrorMessage("OIDC-Z64WA8U6RK", requirements.filter(x -> !oidcProcedureData.containsKey((String)x)).intersperse(" ").foldLeft("Missing the following data: ", String::concat)));
        }

        static String generateId(SecureRandom secureRandom) {
            return Util.cryptoString(secureRandom);
        }

        static String cryptoString(SecureRandom secureRandom) {
            byte[] characters = new byte[48];
            secureRandom.nextBytes(characters);
            return Base64.getUrlEncoder().encodeToString(characters);
        }

        static Boolean isUsingHttps(Option<String> maybeUrl) {
            return maybeUrl.map(url -> url.startsWith("https://")).getOrElse(false);
        }

        static String urlEncode(String arg) {
            return Try.of(() -> URLEncoder.encode(arg, "UTF-8")).getOrElse("");
        }

        static String buildUrl(String url, HashMap<String, String> parameters) {
            return List.of(url, parameters.filterValues(param -> param.trim().length() > 0).toList().map(keyValuePair -> (String)keyValuePair._1 + "=" + Util.urlEncode((String)keyValuePair._2)).intersperse("&").foldLeft("", String::concat)).filter(s -> s.trim().length() > 0).intersperse("?").foldLeft("", String::concat);
        }

        static String createErrorMessage(String code, String message) {
            return String.format("[%s] %s", code, message);
        }
    }

    static class SigningKeyResolverImpl
    extends SigningKeyResolverAdapter {
        private final String jwksUri;
        private final OkHttpClient httpClient;

        SigningKeyResolverImpl(OkHttpClient httpClient, String jwksUri) {
            this.jwksUri = jwksUri;
            this.httpClient = httpClient;
        }

        @Override
        public Key resolveSigningKey(JwsHeader header, Claims claims) {
            return List.ofAll(Http.getJson(this.httpClient, this.jwksUri, HashMap.empty(), JSONObject.class).get().getJSONArray("keys")).map(JSONObject.class::cast).filter(k -> k.getString("use").equals("sig") && k.getString("kty").equals("RSA")).sortBy(k -> k.getString("kid").equals(header.getKeyId())).reverse().peekOption().flatMap(CheckedFunction1.lift(this::parseKey)).getOrElseThrow(() -> new SecurityException("Could not resolve JWS signing key."));
        }

        private Key parseKey(JSONObject key) throws NoSuchAlgorithmException, InvalidKeySpecException {
            if (key.getString("kty").contains("RSA")) {
                BigInteger e = new BigInteger(1, Base64.getUrlDecoder().decode(key.getString("e")));
                BigInteger n = new BigInteger(1, Base64.getUrlDecoder().decode(key.getString("n")));
                KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                RSAPublicKeySpec publicKeySpec = new RSAPublicKeySpec(n, e);
                return keyFactory.generatePublic(publicKeySpec);
            }
            throw new SecurityException("Unknown key type used to sign ID Token.");
        }
    }

    static class Http {
        private static final Function1<Throwable, Either<String, String>> errorMessagePost = throwable -> Either.left(Util.createErrorMessage("OIDC-K6JCV4L81E", "Failed performing OIDC POST request: " + throwable.getMessage()));

        Http() {
        }

        static <T> Either<String, T> getJson(OkHttpClient okHttpClient, String url, HashMap<String, String> headers, Class<T> type) {
            return Try.of(() -> okHttpClient.newCall(new Request.Builder().url(url).headers(Headers.of(headers.toJavaMap())).build()).execute()).filterTry(response -> response.code() == 200, Http::http200Error).mapTry(Response::body).mapTry(ResponseBody::string).mapTry(s -> type.getConstructor(s.getClass()).newInstance(s)).fold(throwable -> Either.left(Util.createErrorMessage("OIDC-MW1EJY4X7F", "Failed performing OIDC GET request: " + throwable.getMessage() + ", requested url: " + url)), Either::right);
        }

        static Either<String, JSONObject> postForJson(OkHttpClient okHttpClient, String url, HashMap<String, String> headers, HashMap<String, String> data) {
            return Http.post(okHttpClient, url, headers, data).fold(left -> Try.failure(new Throwable((String)left)), Try::success).mapTry(obj -> (String)obj).map(JSONObject::new).fold(throwable -> Either.left(Util.createErrorMessage("OIDC-95FRPX2LAY", "Failed parsing JSON returned from OIDC POST request: " + throwable.getMessage() + ", requested url: " + url)), Either::right);
        }

        static Either<String, String> post(OkHttpClient okHttpClient, String url, HashMap<String, String> headers, HashMap<String, String> data) {
            FormBody.Builder formBodyBuilder = new FormBody.Builder();
            data.forEach(entry -> formBodyBuilder.add((String)entry._1, (String)entry._2));
            FormBody formBody = formBodyBuilder.build();
            return Try.of(Http.executePostRequest(okHttpClient, url, headers, formBody)).filterTry(response -> response.code() == 200, Http::http200Error).mapTry(Response::body).mapTry(ResponseBody::string).fold(errorMessagePost, Either::right);
        }

        private static Throwable http200Error(Response invalidResponse) {
            return new SecurityException("Expected HTTP 200 OK. Actual response was HTTP " + invalidResponse.code() + " " + invalidResponse.message());
        }

        private static CheckedFunction0<Response> executePostRequest(OkHttpClient okHttpClient, String url, HashMap<String, String> headers, FormBody formBody) {
            return () -> okHttpClient.newCall(new Request.Builder().url(url).post(formBody).headers(Headers.of(headers.toJavaMap())).build()).execute();
        }
    }
}

