// Set namespace
UT = {};

UT.AWSConsoleLogin = (function() {
    function createConnectorSelector(availableConnectors, gadget, useConnectorVersion1) {
        var prefs = gadget.getPrefs();
        var selected = prefs.getArray("selectedConnectors");
        var checkBoxGroup;
        if (0 < availableConnectors.length) {
            checkBoxGroup = {
                id: "connector-select",
                // YUI compressor enforces ECMA 3 compatibility, so reserved keywords can not be used
                // as property names unquoted:
                'class': "connector-selector-checkboxes",
                userpref: "selectedConnectors",
                label: gadget.getMsg("gadget.awsmanagementconsolelogin.config.connectorCheckboxes.label"),
                description: gadget.getMsg("gadget.awsmanagementconsolelogin.config.connectorCheckboxes.description"),
                type: "checkbox",
                options: function() {
                    var options = [];
                    AJS.$(availableConnectors).each(function() {
                        var id = useConnectorVersion1 ? this.id2 : this.id; // Always use version 2 UUIDs on new save
                        var selectedComparisonId = useConnectorVersion1 ? this.id.toString() : this.id;
                        options.push({
                            label: gadgets.util.escapeString(this.name),
                            value: id,
                            selected: (-1 != AJS.$.inArray(selectedComparisonId, selected))
                        })
                    });
                    return options;
                }()
            }
        }
        else {
            checkBoxGroup = {
                label: gadget.getMsg("gadget.awsmanagementconsolelogin.config.connectorCheckboxes.label"),
                description: gadget.getMsg("gadget.awsmanagementconsolelogin.config.connectorCheckboxes.description"),
                type: "custom",
                template: function(){ 
                    var warning = AJS.$("<p/>");
                    warning.append(AJS.$("<span/>")
                            .attr("class", "aui-icon icon-warning")
                            .append("warning"));
                    warning.append(gadget.getMsg("gadget.awsmanagementconsolelogin.config.connectorCheckboxes.noAvailableConnectors.message"));
                    return warning.html();
                }
            }
        }
        return checkBoxGroup;
    };

    function filterNonSSOUsableConnectors(allConnectors) {
        var filteredConnectors = [];
        if (0 < allConnectors.length) {
            AJS.$(allConnectors).each(function() {
                if (this.type != "SESSION_TOKEN") {
                    filteredConnectors.push(this);
                }
            });
        }
        
        return filteredConnectors;
    }

    function extractAvailableSelectedConnectors(availableConnectors, selectedConnectorIds) {
        var availableSelected = AJS.$.map(availableConnectors, function(connector) {
                return AJS.$.inArray(connector.id.toString(), selectedConnectorIds) < 0 ? null : connector;
            }
        );
        return availableSelected;
    };

    function createAUIMessage(type, bodyText, gadget) {
        var messageClasses = "aui-message";
        if (type) {
            messageClasses = messageClasses.concat(" aui-message-", type);
        }
        var message = AJS.$("<div/>").attr("class", messageClasses);
        var body = AJS.$("<p/>");
        body.append(gadgets.util.escapeString(bodyText));
        message.append(body);

        return message;
    };

    return {
        viewTemplateFunction: function(args) {
            var gadget = this;
            gadgets.window.setTitle(gadget.getMsg("gadget.awsmanagementconsolelogin.title"));
            // Determine connector version to use
            var connectorIdVersion = gadget.getPref("connectorIdVersion");
            var useConnectorVersion1 = connectorIdVersion != "2";
            var connectors = useConnectorVersion1 ? args.connectors.values : args.connectors2.values;
            var selectedConnectorIds = gadget.getPrefs().getArray("selectedConnectors");
            // KLUDGE/TODO: For some yet unknown reason, saving with no selected connectors results in an array with one "false" element,
            // hence this 'correction' to empty array. Should find and fix the cause.
            if (1 == selectedConnectorIds.length && "false" == selectedConnectorIds[0]) {
                selectedConnectorIds = [];
            }
            var availableConnectors = filterNonSSOUsableConnectors(connectors);
            var availableSelectedConnectors = extractAvailableSelectedConnectors(availableConnectors, selectedConnectorIds);
            var content = AJS.$("<div/>")
            if (0 < availableSelectedConnectors.length) {
                var list = AJS.$("<ul/>");
                AJS.$(availableSelectedConnectors).each(function() {
                    var id = useConnectorVersion1 ? this.id2 : this.id;
                    list.append(
                        AJS.$("<li/>").append(
                            AJS.$("<a/>").attr({
                                target: "_blank",
                                title: gadget.getMsg("gadget.awsmanagementconsolelogin.connectors.link.title"),
                                href: gadget.getBaseUrl() + "/plugins/servlet/identity-federation-for-aws/aws-console-login/" + id
                            }).text(gadgets.util.escapeString(this.name))
                        )
                    );
                });
                content.append(list);
            }
            else {
                var message = createAUIMessage("hint", gadget.getMsg("gadget.awsmanagementconsolelogin.connectors.none"), gadget);
                content.append(message);
            }
            gadget.getView().html(content);
        },

        configDescriptorFunction: function(args)
        {
            var gadget = this;
            // Should we convert ids?
            var connectorIdVersion = gadget.getPref("connectorIdVersion");
            var useConnectorVersion1 = connectorIdVersion != "2";
            var connectors = useConnectorVersion1 ? args.connectors.values : args.connectors2.values;
            var availableConnectors = filterNonSSOUsableConnectors(connectors);
            return {
                theme: function() {
                    if (gadgets.window.getViewportDimensions().width < 450) {
                        return "gdt top-label";
                    }
                    else {
                        return "gdt";
                    }
                }(),
                fields: [
                    AJS.gadget.fields.nowConfigured(),
                    createConnectorSelector(availableConnectors, gadget, useConnectorVersion1),
                    {
                        // NOTE: We either start with 2, or convert to 1 on the fly,
                        // so in case of a save, we always end up on 2, hence the fixed value.
                        userpref: "connectorIdVersion",
                        type: "hidden",
                        value: "2"
                    }
                ]
            };
            gadget.fields.nowConfigured();
        }
    };
}());