/*
 * Decompiled with CFR 0.152.
 */
package net.utoolity.atlassian.ifaws.ui;

import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.sal.api.websudo.WebSudoSessionException;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.webresource.api.UrlMode;
import java.io.IOException;
import java.io.Writer;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.java.ao.ActiveObjectsException;
import net.utoolity.atlassian.dry.AUIMessage;
import net.utoolity.atlassian.dry.GroupAccessor;
import net.utoolity.atlassian.dry.LicenseHelper;
import net.utoolity.atlassian.dry.PluginInfo;
import net.utoolity.atlassian.ifaws.AWSConnectorValidationResult;
import net.utoolity.atlassian.ifaws.AWSConnectorValidator;
import net.utoolity.atlassian.ifaws.FeatureFlag;
import net.utoolity.atlassian.ifaws.IAMPolicyValidator;
import net.utoolity.atlassian.ifaws.PluginConfiguration;
import net.utoolity.atlassian.ifaws.ao.AWSAccountPersistenceService;
import net.utoolity.atlassian.ifaws.ao.AWSConnectorPersistenceService;
import net.utoolity.atlassian.ifaws.ao.DefaultCloudProvider;
import net.utoolity.atlassian.ifaws.api.AWSConnectorScope;
import net.utoolity.atlassian.ifaws.api.AWSConnectorType;
import net.utoolity.atlassian.ifaws.api.ExternalCredentialsProviderService;
import net.utoolity.atlassian.ifaws.api.LicenseException;
import net.utoolity.atlassian.ifaws.model.AWSAccountEntity;
import net.utoolity.atlassian.ifaws.model.AWSConnectorEntity;
import net.utoolity.atlassian.ifaws.model.ExternalCredentialsProviderType;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.sts.model.PolicyDescriptorType;

public class ConfigAWSConnectorEditServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(ConfigAWSConnectorEditServlet.class);
    private static final long serialVersionUID = 1L;
    private static final String ID_PARAM_ADD = "add";
    private static final AWSConnectorType DEFAULT_TYPE = AWSConnectorType.ASSUME_ROLE;
    private final WebSudoManager webSudoManager;
    private final LicenseHelper licenseHelper;
    private final TemplateRenderer renderer;
    private final I18nResolver i18n;
    private final AWSConnectorPersistenceService awsConnectorPersistenceService;
    private final AWSAccountPersistenceService awsAccountPersistenceService;
    private final PluginConfiguration pluginConfiguration;
    private final GroupAccessor groupAccessor;
    private final AWSConnectorValidator awsConnectorValidator;
    private final ExternalCredentialsProviderService externalCredentialsProviderService;

    public ConfigAWSConnectorEditServlet(WebSudoManager webSudoManager, LicenseHelper licenseHelper, TemplateRenderer renderer, I18nResolver i18n, AWSConnectorPersistenceService awsConnectorPersistenceService, AWSAccountPersistenceService awsAccountPersistenceService, PluginConfiguration pluginConfiguration, GroupAccessor groupAccessor, AWSConnectorValidator awsConnectorValidator, ExternalCredentialsProviderService externalCredentialsProviderService) {
        this.webSudoManager = webSudoManager;
        this.licenseHelper = licenseHelper;
        this.renderer = renderer;
        this.i18n = i18n;
        this.awsConnectorPersistenceService = awsConnectorPersistenceService;
        this.awsAccountPersistenceService = awsAccountPersistenceService;
        this.pluginConfiguration = pluginConfiguration;
        this.groupAccessor = groupAccessor;
        this.awsConnectorValidator = awsConnectorValidator;
        this.externalCredentialsProviderService = externalCredentialsProviderService;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            String idParam = this.extractIdParam(request);
            if (null == idParam) {
                response.sendError(404);
                return;
            }
            AWSConnectorEntity awsConnector = null;
            Map<String, Object> awsConnectorProperties = null;
            ArrayList<AUIMessage> messages = new ArrayList<AUIMessage>();
            HashMap errors = new HashMap();
            Boolean isAddNew = idParam.equalsIgnoreCase(ID_PARAM_ADD);
            Boolean readOnly = false;
            try {
                this.licenseHelper.ensureValidLicense();
            }
            catch (LicenseException le) {
                readOnly = true;
                messages.add(this.licenseHelper.createAUIErrorMessage(le, AUIMessage.Type.WARNING, true));
            }
            if (isAddNew.booleanValue()) {
                awsConnectorProperties = this.awsConnectorPersistenceService.createEmptyPropertyMap();
            } else {
                awsConnector = this.getAWSConnector(idParam);
                if (null == awsConnector) {
                    response.sendError(404);
                    return;
                }
                awsConnectorProperties = this.awsConnectorPersistenceService.toPropertyMap(awsConnector);
            }
            HashMap<String, Object> context = new HashMap<String, Object>();
            if (isAddNew.booleanValue()) {
                this.setDefaultValues(awsConnectorProperties);
            }
            context.put("urlModeAbsolute", UrlMode.ABSOLUTE);
            context.put("urlModeRelative", UrlMode.RELATIVE);
            context.put("awsConnector", awsConnectorProperties);
            context.put("awsConnectorTypeOptions", this.getAWSConnectorTypeOptions());
            String awsConnectorTypeSelected = this.getAWSConnectorTypeSelected(awsConnectorProperties);
            context.put("awsConnectorTypeSelected", awsConnectorTypeSelected);
            context.put("allowEmptyIamPolicyChecked", isAddNew == false && awsConnectorTypeSelected.equals(AWSConnectorType.FEDERATION_TOKEN.name()) && StringUtils.isBlank((CharSequence)((String)awsConnectorProperties.get("IAM_POLICY"))) && StringUtils.isBlank((CharSequence)((String)awsConnectorProperties.get("IAM_POLICY_ARNS"))));
            context.put("systemScopeValue", this.getAWSConnectorSystemScopeValue());
            context.put("systemScopeChecked", this.getAWSConnectorSystemScopeChecked(awsConnectorProperties));
            context.put("awsAccountOptions", this.getAWSAccountOptions(awsConnectorProperties));
            context.put("selectedAccountId", null != awsConnector ? awsConnector.getAWSAccount().getId() : null);
            context.put("selectedGroupsMapKeyedByName", this.getSelectedGroupsMapKeyedByName(awsConnectorProperties));
            context.put("selectedGroupsHashCodeCsv", this.getSelectedGroupsAsHashCodeCsv(awsConnectorProperties));
            Map<String, Boolean> groupOptions = this.getGroupOptions(awsConnectorProperties);
            context.put("groupOptions", groupOptions);
            context.put("groupCount", groupOptions.size());
            Object[] selectedPolicyArns = this.getSelectedPolicyArnsArray(awsConnectorProperties, messages);
            context.put("selectedPolicyArns", Arrays.asList(selectedPolicyArns));
            context.put("selectedPolicyArnsCsv", StringUtils.join((Object[])selectedPolicyArns, (String)","));
            context.put("messages", messages);
            context.put("errors", errors);
            context.put("isAddNew", isAddNew);
            context.put("readOnly", readOnly);
            context.put("enableGovCloud", this.pluginConfiguration.isFeatureEnabled(FeatureFlag.ENABLE_GOV_CLOUD));
            context.put("enableChinaPartition", this.pluginConfiguration.isFeatureEnabled(FeatureFlag.ENABLE_CHINA_PARTITION));
            context.put("cloudProviderOptions", this.getCloudProviderOptions(awsConnectorProperties));
            context.put("pluginKey", PluginInfo.PLUGIN_KEY);
            context.put("iamRoleForEC2PlaceholderAccountId", this.externalCredentialsProviderService.getPlaceholderAccountId(ExternalCredentialsProviderType.IAMRoleForEC2AndECS));
            context.put("webIdentityTokenPlaceholderAccountId", this.externalCredentialsProviderService.getPlaceholderAccountId(ExternalCredentialsProviderType.WebIdentityToken));
            response.setContentType("text/html;charset=utf-8");
            this.renderer.render("net/utoolity/atlassian/ifaws/templates/configAWSConnectorEdit.vm", context, (Writer)response.getWriter());
        }
        catch (WebSudoSessionException wes) {
            this.webSudoManager.enforceWebSudoProtection(request, response);
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            String idParam = this.extractIdParam(request);
            if (null == idParam) {
                response.sendError(404);
                return;
            }
            AWSConnectorEntity awsConnector = null;
            Map<String, Object> awsConnectorProperties = this.createPropertyMapFromRequest(idParam, request);
            ArrayList<AUIMessage> messages = new ArrayList<AUIMessage>();
            Boolean isAddNew = idParam.equalsIgnoreCase(ID_PARAM_ADD);
            Boolean readOnly = false;
            Boolean shouldRedirectToOverview = null == request.getParameter("submitAndAdd");
            try {
                this.licenseHelper.ensureValidLicense();
            }
            catch (LicenseException le) {
                readOnly = true;
                response.sendError(409);
                return;
            }
            boolean allowEmptyIamPolicy = StringUtils.isNotBlank((CharSequence)request.getParameter("allowEmptyIamPolicy"));
            AWSConnectorValidationResult validationResult = this.awsConnectorValidator.validateValueMapRemovingNonApplicableEntries(awsConnectorProperties, isAddNew, allowEmptyIamPolicy);
            if (!validationResult.hasErrors()) {
                if (isAddNew.booleanValue()) {
                    try {
                        awsConnector = this.createNewAWSConnector(awsConnectorProperties);
                        if (shouldRedirectToOverview.booleanValue()) {
                            response.sendRedirect("../aws-connector");
                            return;
                        }
                        awsConnectorProperties = this.awsConnectorPersistenceService.createEmptyPropertyMap();
                        message = new AUIMessage(AUIMessage.Type.SUCCESS, this.i18n.getText("ifaws.configAWSConnectorEdit.successMessage.title") + " " + awsConnector.getName());
                        messages.add(message);
                    }
                    catch (ActiveObjectsException e) {
                        message = new AUIMessage(AUIMessage.Type.ERROR, this.i18n.getText("ifaws.configAWSConnectorEdit.databaseErrorMessage.title"), e.getMessage());
                        messages.add(message);
                    }
                } else {
                    awsConnector = this.getAWSConnector(idParam);
                    if (null == awsConnector) {
                        response.sendError(404);
                        return;
                    }
                    try {
                        awsConnector = this.updateExistingAWSConnector(awsConnectorProperties, awsConnector);
                        if (shouldRedirectToOverview.booleanValue()) {
                            response.sendRedirect("../aws-connector");
                            return;
                        }
                        awsConnectorProperties = this.awsConnectorPersistenceService.toPropertyMap(awsConnector);
                    }
                    catch (ActiveObjectsException e) {
                        message = new AUIMessage(AUIMessage.Type.ERROR, this.i18n.getText("ifaws.configAWSConnectorEdit.databaseErrorMessage.title"), e.getMessage());
                        messages.add(message);
                    }
                }
            } else {
                message = new AUIMessage(AUIMessage.Type.WARNING, this.i18n.getText("ifaws.configAWSConnectorEdit.validationErrorMessage.title"), this.i18n.getText("ifaws.configAWSConnectorEdit.validationErrorMessage.body"));
                messages.add(message);
            }
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("urlModeAbsolute", UrlMode.ABSOLUTE);
            context.put("urlModeRelative", UrlMode.RELATIVE);
            context.put("awsConnector", awsConnectorProperties);
            context.put("awsConnectorTypeOptions", this.getAWSConnectorTypeOptions());
            context.put("awsConnectorTypeSelected", this.getAWSConnectorTypeSelected(awsConnectorProperties));
            context.put("allowEmptyIamPolicyChecked", allowEmptyIamPolicy);
            context.put("systemScopeValue", this.getAWSConnectorSystemScopeValue());
            context.put("systemScopeChecked", this.getAWSConnectorSystemScopeChecked(awsConnectorProperties));
            context.put("awsAccountOptions", this.getAWSAccountOptions(awsConnectorProperties));
            context.put("selectedAccountId", awsConnectorProperties.get("AWS_ACCOUNTID"));
            context.put("selectedGroupsMapKeyedByName", this.getSelectedGroupsMapKeyedByName(awsConnectorProperties));
            context.put("selectedGroupsHashCodeCsv", this.getSelectedGroupsAsHashCodeCsv(awsConnectorProperties));
            Map<String, Boolean> groupOptions = this.getGroupOptions(awsConnectorProperties);
            context.put("groupOptions", groupOptions);
            context.put("groupCount", groupOptions.size());
            Object[] selectedPolicyArns = this.getSelectedPolicyArnsArray(awsConnectorProperties, messages);
            context.put("selectedPolicyArns", Arrays.asList(selectedPolicyArns));
            context.put("selectedPolicyArnsCsv", StringUtils.join((Object[])selectedPolicyArns, (String)","));
            context.put("messages", messages);
            context.put("errors", validationResult.getAllErrors());
            context.put("isAddNew", isAddNew);
            context.put("readOnly", readOnly);
            context.put("enableGovCloud", this.pluginConfiguration.isFeatureEnabled(FeatureFlag.ENABLE_GOV_CLOUD));
            context.put("enableChinaPartition", this.pluginConfiguration.isFeatureEnabled(FeatureFlag.ENABLE_CHINA_PARTITION));
            context.put("cloudProviderOptions", this.getCloudProviderOptions(awsConnectorProperties));
            context.put("pluginKey", PluginInfo.PLUGIN_KEY);
            context.put("iamRoleForEC2PlaceholderAccountId", this.externalCredentialsProviderService.getPlaceholderAccountId(ExternalCredentialsProviderType.IAMRoleForEC2AndECS));
            context.put("webIdentityTokenPlaceholderAccountId", this.externalCredentialsProviderService.getPlaceholderAccountId(ExternalCredentialsProviderType.WebIdentityToken));
            response.setContentType("text/html;charset=utf-8");
            this.renderer.render("net/utoolity/atlassian/ifaws/templates/configAWSConnectorEdit.vm", context, (Writer)response.getWriter());
        }
        catch (WebSudoSessionException wes) {
            this.webSudoManager.enforceWebSudoProtection(request, response);
        }
    }

    private Map<String, Object> createPropertyMapFromRequest(String idParam, HttpServletRequest request) {
        String policyArnsCsv;
        String[] policyArnStrings;
        Map<String, Object> awsConnectorProperties = this.awsConnectorPersistenceService.createEmptyPropertyMap();
        awsConnectorProperties.put("ID", idParam);
        awsConnectorProperties.put("NAME", request.getParameter("name").trim());
        awsConnectorProperties.put("TYPE", request.getParameter("type"));
        awsConnectorProperties.put("SCOPE", this.parseScope(request, "systemScope"));
        awsConnectorProperties.put("AWS_ACCOUNTID", request.getParameter("awsAccountId"));
        awsConnectorProperties.put("ROLE_ARN", request.getParameter("roleArn").trim());
        awsConnectorProperties.put("EXTERNAL_ID", request.getParameter("externalId").trim());
        awsConnectorProperties.put("IAM_POLICY", request.getParameter("iamPolicy").trim());
        awsConnectorProperties.put("DURATION_SECONDS_MAX", request.getParameter("durationSecondsMax").trim());
        String serializedPolicyArns = "";
        if (null != request.getParameter("policyArns") && (policyArnStrings = StringUtils.split((String)(policyArnsCsv = request.getParameter("policyArns").trim()), (String)",")).length > 0) {
            ArrayList<PolicyDescriptorType> policyArns = new ArrayList<PolicyDescriptorType>();
            for (String arn : policyArnStrings) {
                policyArns.add((PolicyDescriptorType)PolicyDescriptorType.builder().arn(arn).build());
            }
            serializedPolicyArns = IAMPolicyValidator.serializePolicyArns(policyArns);
        }
        awsConnectorProperties.put("IAM_POLICY_ARNS", serializedPolicyArns);
        String[] groups = new String[]{};
        if (null != request.getParameter("groups")) {
            String csvGroupHashcodes = request.getParameter("groups").trim();
            groups = this.findGroupsByHashCodeCsv(csvGroupHashcodes);
        }
        awsConnectorProperties.put("GROUPS", groups);
        return awsConnectorProperties;
    }

    private String[] findGroupsByHashCodeCsv(String csvGroupHashcodes) {
        String[] resultGroups = new String[]{};
        String[] groupHashCodes = StringUtils.split((String)csvGroupHashcodes, (String)",");
        if (null != groupHashCodes && groupHashCodes.length > 0) {
            Map<String, String> groupsMapKeyedByHashCode = this.groupAccessor.getGroupsMapKeyedByHashCode();
            ArrayList<String> groupList = new ArrayList<String>(groupHashCodes.length);
            for (String groupHashCode : groupHashCodes) {
                String groupName = groupsMapKeyedByHashCode.get(groupHashCode);
                if (null != groupName) {
                    groupList.add(groupName);
                    continue;
                }
                log.error("Could not find expected group name for hashCode: " + ((Object)((Object)this)).hashCode());
            }
            resultGroups = groupList.toArray(resultGroups);
        }
        return resultGroups;
    }

    private AWSConnectorScope parseScope(HttpServletRequest request, String parameterName) {
        AWSConnectorScope scope = null;
        String scopeParam = request.getParameter(parameterName);
        if (null != scopeParam) {
            try {
                scope = AWSConnectorScope.valueOf(scopeParam);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return scope;
    }

    private void setDefaultValues(Map<String, Object> awsConnectorProperties) {
        String typeName = (String)awsConnectorProperties.get("TYPE");
        AWSConnectorType type = null;
        try {
            type = AWSConnectorType.valueOf(typeName);
        }
        catch (IllegalArgumentException iae) {
            type = DEFAULT_TYPE;
        }
        catch (NullPointerException npe) {
            type = DEFAULT_TYPE;
        }
        awsConnectorProperties.put("TYPE", type.name());
    }

    private AWSConnectorEntity updateExistingAWSConnector(Map<String, Object> awsConnectorProperties, AWSConnectorEntity awsConnector) {
        awsConnector.setName((String)awsConnectorProperties.get("NAME"));
        awsConnector.setType((String)awsConnectorProperties.get("TYPE"));
        awsConnector.setScope((AWSConnectorScope)awsConnectorProperties.get("SCOPE"));
        awsConnector.setAWSAccount((AWSAccountEntity)awsConnectorProperties.get("AWS_ACCOUNT"));
        awsConnector.setRoleArn((String)awsConnectorProperties.get("ROLE_ARN"));
        awsConnector.setExternalId((String)awsConnectorProperties.get("EXTERNAL_ID"));
        awsConnector.setIAMPolicy((String)awsConnectorProperties.get("IAM_POLICY"));
        awsConnector.setIAMPolicyArns((String)awsConnectorProperties.get("IAM_POLICY_ARNS"));
        awsConnector.setDurationSecondsMax((Integer)awsConnectorProperties.get("DURATION_SECONDS_MAX"));
        awsConnector = this.awsConnectorPersistenceService.save(awsConnector);
        awsConnector = this.saveGroups(awsConnector, (String[])awsConnectorProperties.get("GROUPS"));
        return awsConnector;
    }

    private AWSConnectorEntity createNewAWSConnector(Map<String, Object> awsConnectorProperties) {
        HashMap<String, Object> clonedConnectorProperties = new HashMap<String, Object>(awsConnectorProperties);
        clonedConnectorProperties.remove("ID");
        clonedConnectorProperties.remove("V1_ID");
        clonedConnectorProperties.remove("AWS_ACCOUNT");
        Object groups = clonedConnectorProperties.remove("GROUPS");
        AWSConnectorEntity awsConnector = this.awsConnectorPersistenceService.create(clonedConnectorProperties);
        awsConnector = this.saveGroups(awsConnector, (String[])groups);
        return awsConnector;
    }

    private AWSConnectorEntity saveGroups(AWSConnectorEntity awsConnector, String[] groups) {
        return this.awsConnectorPersistenceService.updateGroups(awsConnector, groups);
    }

    private AWSConnectorEntity getAWSConnector(String idParam) {
        try {
            return this.awsConnectorPersistenceService.getById(idParam);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private String extractIdParam(HttpServletRequest request) {
        String pathInfo = request.getPathInfo();
        if (null == pathInfo) {
            return null;
        }
        String[] pathInfoParts = pathInfo.split("/");
        if (pathInfoParts.length != 2) {
            return null;
        }
        return pathInfoParts[1];
    }

    private Map<String, Boolean> getGroupOptions(Map<String, Object> awsConnectorProperties) {
        TreeMap<Object, Boolean> groupOptions = new TreeMap<Object, Boolean>(Collator.getInstance());
        SortedSet<String> selectedGroups = this.getSelectedGroups(awsConnectorProperties);
        try {
            Iterable<String> availableGroups = this.getAvailableGroups();
            for (String availableGroup : availableGroups) {
                groupOptions.put(availableGroup, selectedGroups.contains(availableGroup));
            }
        }
        catch (UnsupportedOperationException e) {
            return new HashMap<String, Boolean>();
        }
        return groupOptions;
    }

    private SortedSet<String> getSelectedGroups(Map<String, Object> awsConnectorProperties) {
        TreeSet<Object> selectedGroups = new TreeSet<Object>(Collator.getInstance());
        if (null != awsConnectorProperties) {
            String[] groupNames = (String[])awsConnectorProperties.get("GROUPS");
            Collections.addAll(selectedGroups, groupNames);
        }
        return selectedGroups;
    }

    private SortedMap<String, String> getSelectedGroupsMapKeyedByName(Map<String, Object> awsConnectorProperties) {
        TreeMap<Object, String> selectedGroups = new TreeMap<Object, String>(Collator.getInstance());
        Map<String, String> allGroupsMap = this.getAvailableGroupsMapKeyedByName();
        if (null != awsConnectorProperties) {
            String[] groupNames;
            for (String groupName : groupNames = (String[])awsConnectorProperties.get("GROUPS")) {
                String groupHashCode = allGroupsMap.get(groupName);
                if (null == groupHashCode) continue;
                selectedGroups.put(groupName, groupHashCode);
            }
        }
        return selectedGroups;
    }

    private String getSelectedGroupsAsHashCodeCsv(Map<String, Object> awsConnectorProperties) {
        SortedMap<String, String> selectedGroups = this.getSelectedGroupsMapKeyedByName(awsConnectorProperties);
        return StringUtils.join(selectedGroups.values(), (String)",");
    }

    private String[] getSelectedPolicyArnsArray(Map<String, Object> awsConnectorProperties, List<AUIMessage> messages) {
        String[] selectedPolicyArns = new String[]{};
        String policyArnsJson = (String)awsConnectorProperties.get("IAM_POLICY_ARNS");
        if (StringUtils.isNotBlank((CharSequence)policyArnsJson)) {
            try {
                Collection<PolicyDescriptorType> parsedPolicyArns = IAMPolicyValidator.parsePolicyArns(policyArnsJson);
                if (parsedPolicyArns.size() > 0) {
                    selectedPolicyArns = (String[])parsedPolicyArns.stream().map(ppa -> ppa.arn()).sorted().toArray(String[]::new);
                }
            }
            catch (RuntimeException e) {
                AUIMessage message = new AUIMessage(AUIMessage.Type.ERROR, this.i18n.getText("ifaws.configAWSConnectorEdit.validationError.invalidPolicyArnsJSON"), e.getMessage());
                messages.add(message);
            }
        }
        return selectedPolicyArns;
    }

    private Iterable<String> getAvailableGroups() {
        return this.groupAccessor.getGroups();
    }

    private Map<String, String> getAvailableGroupsMapKeyedByName() {
        return this.groupAccessor.getGroupsMapKeyedByName();
    }

    private Map<String, String> getAWSAccountOptions(Map<String, Object> awsConnectorProperties) {
        HashMap<String, String> awsAccountOptions = new HashMap<String, String>();
        AWSAccountEntity[] avaliableAccounts = this.awsAccountPersistenceService.findAll();
        HashMap<String, String> placeholderAccountOptions = new HashMap<String, String>();
        for (AWSAccountEntity awsAccount : avaliableAccounts) {
            if (ExternalCredentialsProviderService.isPlaceholderAccount(awsAccount)) {
                placeholderAccountOptions.put(awsAccount.getName(), awsAccount.getId());
                continue;
            }
            awsAccountOptions.put(awsAccount.getName(), awsAccount.getId());
        }
        Map awsAccountOptionsSorted = awsAccountOptions.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.naturalOrder())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue, LinkedHashMap::new));
        if (0 < placeholderAccountOptions.size()) {
            awsAccountOptionsSorted.putAll(placeholderAccountOptions);
        }
        return awsAccountOptionsSorted;
    }

    private Map<String, String> getAWSConnectorTypeOptions() {
        LinkedHashMap<String, String> awsConnectorTypeOptions = new LinkedHashMap<String, String>();
        for (AWSConnectorType type : AWSConnectorType.valuesOrdered()) {
            awsConnectorTypeOptions.put(type.name(), this.i18n.getText("ifaws.AWSConnectorType.displayName." + type.name()));
        }
        if (!this.externalCredentialsProviderService.isExternalCredentialsProviderSourceEnabled(ExternalCredentialsProviderType.IAMRoleForEC2AndECS) && !this.externalCredentialsProviderService.isExternalCredentialsProviderSourceEnabled(ExternalCredentialsProviderType.WebIdentityToken)) {
            awsConnectorTypeOptions.remove(AWSConnectorType.PROVIDED.name());
        }
        return awsConnectorTypeOptions;
    }

    private String getAWSConnectorTypeSelected(Map<String, Object> awsConnectorProperties) {
        String selectedType = (String)awsConnectorProperties.get("TYPE");
        if (null == selectedType || selectedType.isEmpty()) {
            selectedType = AWSConnectorType.FEDERATION_TOKEN.name();
        }
        return selectedType;
    }

    private String getAWSConnectorSystemScopeValue() {
        return AWSConnectorScope.SYSTEM.name();
    }

    private boolean getAWSConnectorSystemScopeChecked(Map<String, Object> awsConnectorProperties) {
        return awsConnectorProperties.get("SCOPE") == AWSConnectorScope.SYSTEM;
    }

    private Object getCloudProviderOptions(Map<String, Object> awsConnectorProperties) {
        LinkedHashMap<String, String> cloudProviderOptions = new LinkedHashMap<String, String>();
        cloudProviderOptions.put(DefaultCloudProvider.AWS.getDisplayName(), DefaultCloudProvider.AWS.getKey());
        if (this.pluginConfiguration.isFeatureEnabled(FeatureFlag.ENABLE_GOV_CLOUD)) {
            cloudProviderOptions.put(DefaultCloudProvider.AWS_US_GOV.getDisplayName(), DefaultCloudProvider.AWS_US_GOV.getKey());
        }
        if (this.pluginConfiguration.isFeatureEnabled(FeatureFlag.ENABLE_CHINA_PARTITION)) {
            cloudProviderOptions.put(DefaultCloudProvider.AWS_CN.getDisplayName(), DefaultCloudProvider.AWS_CN.getKey());
        }
        return cloudProviderOptions;
    }
}

