/*
 * Decompiled with CFR 0.152.
 */
package net.utoolity.atlassian.ifaws.rest.v20;

import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.Encoded;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import net.utoolity.atlassian.dry.ParameterValidationException;
import net.utoolity.atlassian.ifaws.api.AWSConnectorDTO2;
import net.utoolity.atlassian.ifaws.api.AWSConnectorScope;
import net.utoolity.atlassian.ifaws.api.AWSConnectorService2;
import net.utoolity.atlassian.ifaws.api.STSCallerIdentityDTO;
import net.utoolity.atlassian.ifaws.api.STSCredentialsDTO;
import net.utoolity.atlassian.ifaws.rest.common.DTOCollectionImpl;
import net.utoolity.atlassian.ifaws.rest.common.GenericRestException;
import net.utoolity.atlassian.ifaws.rest.v2.ConsoleUrlDTO;
import net.utoolity.atlassian.ifaws.sso.AWSConsoleLoginUrlCreator;
import org.apache.commons.lang3.StringUtils;

@Path(value="/connectors")
public class AWSConnectorResource {
    private final AWSConnectorService2 awsConnectorService2;
    private final AWSConsoleLoginUrlCreator awsConsoleLoginUrlCreator;

    @Inject
    public AWSConnectorResource(AWSConnectorService2 awsConnectorService2, AWSConsoleLoginUrlCreator awsConsoleLoginUrlCreator) {
        this.awsConnectorService2 = awsConnectorService2;
        this.awsConsoleLoginUrlCreator = awsConsoleLoginUrlCreator;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getConnectors(@QueryParam(value="scope") String scopeParam) {
        AWSConnectorScope scope = this.parseScopeParam(scopeParam);
        List<AWSConnectorDTO2> connectors = this.awsConnectorService2.getConnectors(scope);
        DTOCollectionImpl<AWSConnectorDTO2> connectorCollection = new DTOCollectionImpl<AWSConnectorDTO2>(connectors);
        return Response.ok(connectorCollection).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{id}")
    public Response getConnector(@PathParam(value="id") String connectorId) {
        AWSConnectorDTO2 connector = null;
        connector = this.awsConnectorService2.getConnector(connectorId);
        if (null == connector) {
            throw new GenericRestException().withResponseStatus(Response.Status.NOT_FOUND);
        }
        return Response.ok((Object)connector).build();
    }

    private AWSConnectorScope parseScopeParam(String scopeParam) throws ParameterValidationException {
        AWSConnectorScope scope = null;
        if (StringUtils.isNotBlank((CharSequence)scopeParam)) {
            try {
                scope = AWSConnectorScope.valueOf(scopeParam);
            }
            catch (IllegalArgumentException iae) {
                throw new ParameterValidationException("Unknown scope value: " + scopeParam);
            }
        }
        return scope;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{id}/credentials")
    public Response getCredentials(@PathParam(value="id") String connectorId, @QueryParam(value="durationSeconds") Integer durationSeconds) {
        STSCredentialsDTO credentials = this.awsConnectorService2.getCredentials(connectorId, durationSeconds);
        if (null == credentials) {
            throw new GenericRestException().withResponseStatus(Response.Status.NOT_FOUND);
        }
        return Response.ok((Object)credentials).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{id}/caller-identity")
    public Response getCallerIdentity(@PathParam(value="id") String connectorId) {
        STSCallerIdentityDTO stsCallerIdentityDTO = this.awsConnectorService2.getCallerIdentity(connectorId);
        if (null == stsCallerIdentityDTO) {
            throw new GenericRestException().withResponseStatus(Response.Status.NOT_FOUND);
        }
        return Response.ok((Object)stsCallerIdentityDTO).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{id}/console/url")
    public Response getConsoleUrl(@PathParam(value="id") String connectorId, @Encoded @QueryParam(value="destination") List<String> destination) {
        AWSConnectorDTO2 connector = null;
        connector = this.awsConnectorService2.getConnector(connectorId);
        if (null == connector) {
            throw new GenericRestException().withResponseStatus(Response.Status.NOT_FOUND);
        }
        if (destination.size() > 1) {
            throw new GenericRestException("Only one destination parameter allowed").withResponseStatus(Response.Status.BAD_REQUEST);
        }
        String destinationUrl = null;
        if (destination.size() == 1 && StringUtils.isNotBlank((CharSequence)destination.get(0))) {
            destinationUrl = destination.get(0);
        }
        String consoleURL = this.awsConsoleLoginUrlCreator.createConsoleLoginUrl(connectorId, destinationUrl);
        ConsoleUrlDTO consoleUrlDTO = ConsoleUrlDTO.fromUrl(consoleURL);
        return Response.ok((Object)consoleUrlDTO).build();
    }
}

