/*
 * Decompiled with CFR 0.152.
 */
package net.utoolity.atlassian.ifaws.rest.v2;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import net.utoolity.atlassian.dry.ParameterValidationException;
import net.utoolity.atlassian.ifaws.api.ECRCredentialsDTO;
import net.utoolity.atlassian.ifaws.api.ECRCredentialsService;
import net.utoolity.atlassian.ifaws.aws.AWS;
import net.utoolity.atlassian.ifaws.rest.common.DTOCollectionImpl;
import net.utoolity.atlassian.ifaws.rest.common.GenericRestException;

@Path(value="/connectors/{id}/ecr/credentials")
public class ECRCredentialsResource {
    private final ECRCredentialsService ecrCredentialsService;

    @Inject
    public ECRCredentialsResource(ECRCredentialsService ecrCredentialsService) {
        this.ecrCredentialsService = ecrCredentialsService;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getCredentials(@PathParam(value="id") String connectorId, @QueryParam(value="registry-id") List<String> registryIds, @QueryParam(value="region") String regionName) {
        List<Object> credentialsCollection = new ArrayList();
        if (null != regionName && !AWS.isValidRegionName(regionName)) {
            throw new ParameterValidationException("Parameter 'region' does not represent a valid region");
        }
        if (registryIds.size() > 0) {
            credentialsCollection = this.ecrCredentialsService.getCredentials(connectorId, registryIds, regionName);
        } else {
            ECRCredentialsDTO credentials = this.ecrCredentialsService.getCredentials(connectorId, regionName);
            credentialsCollection.add(credentials);
        }
        if (credentialsCollection.size() < 1) {
            throw new GenericRestException().withResponseStatus(Response.Status.NOT_FOUND);
        }
        DTOCollectionImpl<Object> responseCollection = new DTOCollectionImpl<Object>(credentialsCollection);
        return Response.ok(responseCollection).build();
    }
}

