/*
 * Decompiled with CFR 0.152.
 */
package net.utoolity.atlassian.ifaws.rest.v2;

import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import net.utoolity.atlassian.dry.ParameterValidationException;
import net.utoolity.atlassian.ifaws.api.CodeArtifactCredentialsDTO;
import net.utoolity.atlassian.ifaws.api.CodeArtifactCredentialsService;
import net.utoolity.atlassian.ifaws.aws.AWS;
import net.utoolity.atlassian.ifaws.aws.CodeArtifact;
import net.utoolity.atlassian.ifaws.rest.common.GenericRestException;
import org.apache.commons.lang3.StringUtils;

@Path(value="/connectors/{id}/codeartifact/credentials")
public class CodeArtifactCredentialsResource {
    private final CodeArtifactCredentialsService codeArtifactCredentialsService;

    @Inject
    public CodeArtifactCredentialsResource(CodeArtifactCredentialsService codeArtifactCredentialsService) {
        this.codeArtifactCredentialsService = codeArtifactCredentialsService;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getCredentials(@PathParam(value="id") String connectorId, @QueryParam(value="domain") String domain, @QueryParam(value="domain-owner") String domainOwner, @QueryParam(value="duration-seconds") String durationSecondsString, @QueryParam(value="region") String regionName) {
        if (StringUtils.isBlank((CharSequence)domain)) {
            throw new ParameterValidationException("Parameter 'domain' is required");
        }
        if (!CodeArtifact.isValidDomain(domain)) {
            throw new ParameterValidationException("Invalid 'domain'");
        }
        if (StringUtils.isNotBlank((CharSequence)domainOwner) && !CodeArtifact.isValidDomainOwner(domainOwner)) {
            throw new ParameterValidationException("Invalid 'domain-owner'");
        }
        Integer durationSeconds = null;
        if (StringUtils.isNotBlank((CharSequence)durationSecondsString)) {
            try {
                durationSeconds = Integer.parseInt(durationSecondsString);
            }
            catch (NumberFormatException nfe) {
                throw new ParameterValidationException("Parameter 'duration-seconds' is not parseable as an integer");
            }
        }
        if (null != durationSeconds && !CodeArtifact.isValidDurationSeconds(durationSeconds)) {
            throw new ParameterValidationException("Parameter 'duration-seconds' must be within in range of 900 - 43200, or 0");
        }
        if (null != regionName && !AWS.isValidRegionName(regionName)) {
            throw new ParameterValidationException("Parameter 'region' does not represent a valid region");
        }
        CodeArtifactCredentialsDTO codeArtifactCredentialsDTO = this.codeArtifactCredentialsService.getCredentials(connectorId, domain, domainOwner, durationSeconds, regionName);
        if (null == codeArtifactCredentialsDTO) {
            throw new GenericRestException().withResponseStatus(Response.Status.NOT_FOUND);
        }
        return Response.ok((Object)codeArtifactCredentialsDTO).build();
    }
}

