/*
 * Decompiled with CFR 0.152.
 */
package net.utoolity.atlassian.ifaws.api.impl;

import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import java.util.ArrayList;
import java.util.List;
import net.utoolity.atlassian.dry.LicenseHelper;
import net.utoolity.atlassian.ifaws.AWSSecurityTokenClientProxy;
import net.utoolity.atlassian.ifaws.ao.AWSConnectorGroup;
import net.utoolity.atlassian.ifaws.ao.AWSConnectorPersistenceService;
import net.utoolity.atlassian.ifaws.api.AWSConnectorDTO;
import net.utoolity.atlassian.ifaws.api.AWSConnectorScope;
import net.utoolity.atlassian.ifaws.api.AWSConnectorService;
import net.utoolity.atlassian.ifaws.api.LicenseException;
import net.utoolity.atlassian.ifaws.api.NotAuthorizedException;
import net.utoolity.atlassian.ifaws.api.STSCredentialsDTO;
import net.utoolity.atlassian.ifaws.model.AWSConnectorEntity;
import org.apache.commons.lang3.StringUtils;
import software.amazon.awssdk.services.sts.model.Credentials;

public class AWSConnectorServiceImpl
implements AWSConnectorService {
    private static final String STS_SYSTEM_USER_NAME = "SYSTEM";
    private final LicenseHelper licenseHelper;
    private final AWSConnectorPersistenceService awsConnectorPersistenceService;
    private final AWSSecurityTokenClientProxy tokenClientProxy;
    private final UserManager userManager;

    public AWSConnectorServiceImpl(LicenseHelper licenseHelper, AWSConnectorPersistenceService awsConnectorPersistenceService, AWSSecurityTokenClientProxy tokenClientProxy, UserManager userManager) {
        this.licenseHelper = licenseHelper;
        this.awsConnectorPersistenceService = awsConnectorPersistenceService;
        this.tokenClientProxy = tokenClientProxy;
        this.userManager = userManager;
    }

    @Override
    public List<AWSConnectorDTO> getConnectors() throws LicenseException {
        return this.getConnectors(null);
    }

    @Override
    public List<AWSConnectorDTO> getConnectors(AWSConnectorScope awsConnectorScope) throws LicenseException {
        this.licenseHelper.ensureValidLicense();
        UserKey userKey = this.findCurrentUserKey();
        AWSConnectorEntity[] matches = null != awsConnectorScope ? this.awsConnectorPersistenceService.findByScope(awsConnectorScope) : this.awsConnectorPersistenceService.findAll();
        ArrayList<AWSConnectorDTO> result = new ArrayList<AWSConnectorDTO>();
        for (AWSConnectorEntity awsConnector : matches) {
            if (!this.hasAccess(userKey, awsConnector, null)) continue;
            result.add(AWSConnectorServiceImpl.createAWSConnectorDTO(awsConnector));
        }
        return result;
    }

    @Override
    public AWSConnectorDTO getConnector(int connectorId) throws NotAuthorizedException, LicenseException {
        return this.getConnector(connectorId, null);
    }

    @Override
    public AWSConnectorDTO getConnector(int connectorId, AWSConnectorScope awsConnectorScope) throws NotAuthorizedException, LicenseException {
        this.licenseHelper.ensureValidLicense();
        AWSConnectorEntity awsConnector = this.awsConnectorPersistenceService.getByV1Id(connectorId);
        UserKey userKey = this.findCurrentUserKey();
        if (null == awsConnector) {
            return null;
        }
        if (!this.hasAccess(userKey, awsConnector, awsConnectorScope)) {
            throw new NotAuthorizedException("Requesting user is not authorized to access this Connector");
        }
        return AWSConnectorServiceImpl.createAWSConnectorDTO(awsConnector);
    }

    @Override
    public STSCredentialsDTO getCredentials(int connectorId) throws NotAuthorizedException, LicenseException {
        return this.getCredentials(connectorId, null, null);
    }

    @Override
    public STSCredentialsDTO getCredentials(int connectorId, AWSConnectorScope awsConnectorScope) throws NotAuthorizedException, LicenseException {
        return this.getCredentials(connectorId, null, awsConnectorScope);
    }

    @Override
    public STSCredentialsDTO getCredentials(int connectorId, Integer durationSeconds) throws NotAuthorizedException, LicenseException {
        return this.getCredentials(connectorId, durationSeconds, null);
    }

    @Override
    public STSCredentialsDTO getCredentials(int connectorId, Integer durationSeconds, AWSConnectorScope awsConnectorScope) throws NotAuthorizedException, LicenseException {
        this.licenseHelper.ensureValidLicense();
        UserKey userKey = this.findCurrentUserKey();
        AWSConnectorEntity awsConnector = this.awsConnectorPersistenceService.getByV1Id(connectorId);
        if (null == awsConnector) {
            return null;
        }
        if (!this.hasAccess(userKey, awsConnector, awsConnectorScope)) {
            throw new NotAuthorizedException("Requesting user is not authorized to access this Connector");
        }
        String userName = this.findCurrentUserName();
        if (StringUtils.isBlank((CharSequence)userName)) {
            userName = awsConnector.getName();
        }
        Credentials credentials = this.tokenClientProxy.getSecurityToken(awsConnector, durationSeconds, userName);
        return new STSCredentialsDTO(credentials.accessKeyId(), credentials.secretAccessKey(), credentials.sessionToken(), credentials.expiration(), awsConnector.getCloudProvider().getPartitionKey());
    }

    private UserKey findCurrentUserKey() {
        return this.userManager.getRemoteUserKey();
    }

    private String findCurrentUserName() {
        UserProfile userProfile = this.userManager.getRemoteUser();
        if (null != userProfile) {
            return userProfile.getUsername();
        }
        return STS_SYSTEM_USER_NAME;
    }

    private boolean hasAccess(UserKey userKey, AWSConnectorEntity awsConnector, AWSConnectorScope awsConnectorScope) {
        AWSConnectorGroup[] groups;
        if (null != awsConnectorScope && awsConnector.hasScope(awsConnectorScope)) {
            return true;
        }
        if (null == userKey) {
            return false;
        }
        for (AWSConnectorGroup group : groups = awsConnector.getGroups()) {
            if (!this.userManager.isUserInGroup(userKey, group.getName())) continue;
            return true;
        }
        return this.userManager.isSystemAdmin(userKey);
    }

    public static AWSConnectorDTO createAWSConnectorDTO(AWSConnectorEntity awsConnector) {
        AWSConnectorDTO awsConnectorDTO = new AWSConnectorDTO();
        awsConnectorDTO.setId(awsConnector.getV1Id());
        awsConnectorDTO.setId2(awsConnector.getId());
        awsConnectorDTO.setName(awsConnector.getName());
        awsConnectorDTO.setType(awsConnector.getType());
        awsConnectorDTO.setScope(null != awsConnector.getScope() ? awsConnector.getScope().name() : null);
        awsConnectorDTO.setDurationSecondsMax(awsConnector.getDurationSecondsMax());
        return awsConnectorDTO;
    }
}

