/*
 * Decompiled with CFR 0.152.
 */
package net.utoolity.atlassian.ifaws;

import net.utoolity.atlassian.dry.ParameterValidationException;
import net.utoolity.atlassian.ifaws.ao.DefaultCloudProvider;
import net.utoolity.atlassian.ifaws.api.AWSConnectorType;
import net.utoolity.atlassian.ifaws.api.ExternalCredentialsProviderService;
import net.utoolity.atlassian.ifaws.api.STSCallerIdentityDTO;
import net.utoolity.atlassian.ifaws.api.STSCredentialsDTO;
import net.utoolity.atlassian.ifaws.model.AWSConnectorEntity;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.StsClientBuilder;
import software.amazon.awssdk.services.sts.model.AssumeRoleRequest;
import software.amazon.awssdk.services.sts.model.AssumeRoleResponse;
import software.amazon.awssdk.services.sts.model.Credentials;
import software.amazon.awssdk.services.sts.model.GetCallerIdentityRequest;
import software.amazon.awssdk.services.sts.model.GetCallerIdentityResponse;
import software.amazon.awssdk.services.sts.model.GetFederationTokenRequest;
import software.amazon.awssdk.services.sts.model.GetFederationTokenResponse;
import software.amazon.awssdk.services.sts.model.GetSessionTokenRequest;
import software.amazon.awssdk.services.sts.model.GetSessionTokenResponse;
import software.amazon.awssdk.services.sts.model.MalformedPolicyDocumentException;
import software.amazon.awssdk.services.sts.model.PackedPolicyTooLargeException;

public class AWSSecurityTokenClientProxy {
    private static final int STS_USER_NAME_MAX_LENGTH_FEDERATION_TOKEN = 32;
    private static final int STS_USER_NAME_MAX_LENGTH_ASSUME_ROLE = 64;
    private static final String STS_USER_NAME_INVALID_CHAR_REGEX = "[^\\w+=,.@-]";
    private static final String STS_USER_NAME_INVALID_CHAR_REPLACEMENT = "_";
    private static final Logger log = LoggerFactory.getLogger(AWSSecurityTokenClientProxy.class);

    public Credentials getSecurityToken(AWSConnectorEntity awsConnector, Integer durationSeconds, String username) {
        if (AWSConnectorType.PROVIDED == awsConnector.getTypeAsEnum() && !ExternalCredentialsProviderService.isPlaceholderAccount(awsConnector.getAWSAccount())) {
            throw new RuntimeException("Can't use provided credentials connector with non EC2/ECS backing credentials");
        }
        AwsCredentialsProvider awsCredentialsProvider = awsConnector.getLongLivedCredentialsProvider();
        DefaultCloudProvider cloudProvider = awsConnector.getCloudProvider();
        StsClient stsClient = this.createSTSClient(awsCredentialsProvider, cloudProvider);
        switch (awsConnector.getTypeAsEnum()) {
            case SESSION_TOKEN: {
                return this.getSecurityTokenByGetSessionToken(stsClient, awsConnector, durationSeconds);
            }
            case FEDERATION_TOKEN: {
                return this.getSecurityTokenByGetFederationToken(stsClient, awsConnector, durationSeconds, username);
            }
            case ASSUME_ROLE: {
                return this.getSecurityTokenByAssumeRole(stsClient, awsConnector, durationSeconds, username);
            }
            case PROVIDED: {
                AwsCredentials awsCredentials = awsCredentialsProvider.resolveCredentials();
                Credentials.Builder credentialsBuilder = Credentials.builder().accessKeyId(awsCredentials.accessKeyId()).secretAccessKey(awsCredentials.secretAccessKey());
                if (awsCredentials instanceof AwsSessionCredentials) {
                    credentialsBuilder.sessionToken(((AwsSessionCredentials)awsCredentials).sessionToken());
                }
                return (Credentials)credentialsBuilder.build();
            }
        }
        throw new RuntimeException("Unknown connector type");
    }

    public STSCallerIdentityDTO getCallerIdentity(AwsCredentials awsCredentials, DefaultCloudProvider cloudProvider) {
        StsClient stsClient = this.createSTSClient(awsCredentials, cloudProvider);
        GetCallerIdentityRequest getCallerIdentityRequest = (GetCallerIdentityRequest)GetCallerIdentityRequest.builder().build();
        GetCallerIdentityResponse getCallerIdentityResult = stsClient.getCallerIdentity(getCallerIdentityRequest);
        return new STSCallerIdentityDTO(getCallerIdentityResult.account(), getCallerIdentityResult.arn(), getCallerIdentityResult.userId());
    }

    public STSCallerIdentityDTO getCallerIdentity(STSCredentialsDTO stsCredentialsDTO) {
        AwsSessionCredentials awsCredentials = AwsSessionCredentials.create((String)stsCredentialsDTO.getAccessKeyId(), (String)stsCredentialsDTO.getSecretAccessKey(), (String)stsCredentialsDTO.getSessionToken());
        DefaultCloudProvider cloudProvider = DefaultCloudProvider.getByPartitionKey(stsCredentialsDTO.getPartition());
        return this.getCallerIdentity((AwsCredentials)awsCredentials, cloudProvider);
    }

    private StsClient createSTSClient(AwsCredentials awsCredentials, DefaultCloudProvider cloudProvider) {
        StaticCredentialsProvider credentialsProvider = StaticCredentialsProvider.create((AwsCredentials)awsCredentials);
        return this.createSTSClient((AwsCredentialsProvider)credentialsProvider, cloudProvider);
    }

    private StsClient createSTSClient(AwsCredentialsProvider awsCredentialsProvider, DefaultCloudProvider cloudProvider) {
        return (StsClient)((StsClientBuilder)((StsClientBuilder)StsClient.builder().credentialsProvider(awsCredentialsProvider)).region(cloudProvider.getGlobalRegion())).build();
    }

    private Credentials getSecurityTokenByGetFederationToken(StsClient awsClient, AWSConnectorEntity awsConnector, Integer durationSeconds, String username) throws RuntimeException {
        String sanitizedUsername = AWSSecurityTokenClientProxy.sanitizeNameForSTSUsage(username, 32);
        GetFederationTokenRequest.Builder getFederationTokenRequestBuilder = GetFederationTokenRequest.builder().name(sanitizedUsername);
        if (null == durationSeconds) {
            durationSeconds = this.adjustDurationSecondsDefault(durationSeconds, awsConnector);
        }
        if (null != durationSeconds) {
            this.validateDurationSeconds(durationSeconds, awsConnector);
            getFederationTokenRequestBuilder.durationSeconds(durationSeconds);
        }
        if (StringUtils.isNotBlank((CharSequence)awsConnector.getIAMPolicy())) {
            getFederationTokenRequestBuilder.policy(awsConnector.getIAMPolicy());
        }
        if (null != awsConnector.getIAMPolicyArnsCollection() && 0 < awsConnector.getIAMPolicyArnsCollection().size()) {
            getFederationTokenRequestBuilder.policyArns(awsConnector.getIAMPolicyArnsCollection());
        }
        try {
            GetFederationTokenResponse getFederationTokenResult = awsClient.getFederationToken((GetFederationTokenRequest)getFederationTokenRequestBuilder.build());
            return getFederationTokenResult.credentials();
        }
        catch (PackedPolicyTooLargeException e) {
            throw new RuntimeException(e);
        }
        catch (MalformedPolicyDocumentException e) {
            throw new RuntimeException(e);
        }
        catch (AwsServiceException e) {
            throw new RuntimeException(e);
        }
        catch (SdkException e) {
            throw new RuntimeException(e);
        }
    }

    private Credentials getSecurityTokenByGetSessionToken(StsClient awsClient, AWSConnectorEntity awsConnector, Integer durationSeconds) throws RuntimeException {
        GetSessionTokenRequest.Builder getSessionTokenRequestBuilder = GetSessionTokenRequest.builder();
        if (null == durationSeconds) {
            durationSeconds = this.adjustDurationSecondsDefault(durationSeconds, awsConnector);
        }
        if (null != durationSeconds) {
            this.validateDurationSeconds(durationSeconds, awsConnector);
            getSessionTokenRequestBuilder.durationSeconds(durationSeconds);
        }
        try {
            GetSessionTokenResponse getSessionTokenResult = awsClient.getSessionToken((GetSessionTokenRequest)getSessionTokenRequestBuilder.build());
            return getSessionTokenResult.credentials();
        }
        catch (AwsServiceException e) {
            throw new RuntimeException(e);
        }
        catch (SdkException e) {
            throw new RuntimeException(e);
        }
    }

    private Credentials getSecurityTokenByAssumeRole(StsClient awsClient, AWSConnectorEntity awsConnector, Integer durationSeconds, String roleSessionName) {
        String sanitizedRoleSessionName = AWSSecurityTokenClientProxy.sanitizeNameForSTSUsage(roleSessionName, 64);
        AssumeRoleRequest.Builder assumeRoleRequestBuilder = AssumeRoleRequest.builder().roleArn(awsConnector.getRoleArn()).roleSessionName(sanitizedRoleSessionName);
        if (null == durationSeconds) {
            durationSeconds = this.adjustDurationSecondsDefault(durationSeconds, awsConnector);
        }
        if (null != durationSeconds) {
            this.validateDurationSeconds(durationSeconds, awsConnector);
            assumeRoleRequestBuilder.durationSeconds(durationSeconds);
        }
        if (StringUtils.isNotBlank((CharSequence)awsConnector.getIAMPolicy())) {
            assumeRoleRequestBuilder.policy(awsConnector.getIAMPolicy());
        }
        if (null != awsConnector.getIAMPolicyArnsCollection() && 0 < awsConnector.getIAMPolicyArnsCollection().size()) {
            assumeRoleRequestBuilder.policyArns(awsConnector.getIAMPolicyArnsCollection());
        }
        if (StringUtils.isNotBlank((CharSequence)awsConnector.getExternalId())) {
            assumeRoleRequestBuilder.externalId(awsConnector.getExternalId());
        }
        try {
            AssumeRoleResponse assumeRoleResult = awsClient.assumeRole((AssumeRoleRequest)assumeRoleRequestBuilder.build());
            return assumeRoleResult.credentials();
        }
        catch (PackedPolicyTooLargeException e) {
            throw new RuntimeException(e);
        }
        catch (MalformedPolicyDocumentException e) {
            throw new RuntimeException(e);
        }
        catch (AwsServiceException e) {
            throw new RuntimeException(e);
        }
        catch (SdkException e) {
            throw new RuntimeException(e);
        }
    }

    private Integer adjustDurationSecondsDefault(Integer durationSeconds, AWSConnectorEntity awsConnector) {
        if (null != durationSeconds) {
            return durationSeconds;
        }
        return awsConnector.getDurationSecondsMax();
    }

    private void validateDurationSeconds(Integer durationSeconds, AWSConnectorEntity awsConnector) {
        if (null == durationSeconds) {
            return;
        }
        Integer durationSecondsMin = awsConnector.getTypeAsEnum().getDurationSecondsMin();
        if (durationSeconds < durationSecondsMin) {
            throw new ParameterValidationException("Requested duration is to short - minimum is " + durationSecondsMin.toString());
        }
        Integer durationSecondsMax = awsConnector.getDurationSecondsMax();
        if (null == durationSecondsMax) {
            durationSecondsMax = awsConnector.getTypeAsEnum().getDurationSecondsMax();
        }
        if (durationSeconds > durationSecondsMax) {
            throw new ParameterValidationException("Requested duration is to long - maximum is " + durationSecondsMax.toString());
        }
    }

    public static String sanitizeNameForSTSUsage(String username, int maxLength) {
        String sanitized = username.replaceAll(STS_USER_NAME_INVALID_CHAR_REGEX, STS_USER_NAME_INVALID_CHAR_REPLACEMENT);
        if (sanitized.length() > maxLength) {
            sanitized = sanitized.substring(0, maxLength);
        }
        return sanitized;
    }
}

