/*
 * Decompiled with CFR 0.152.
 */
package net.utoolity.atlassian.bamboo.ifaws;

import com.atlassian.bamboo.serialization.WhitelistedSerializable;
import com.atlassian.bamboo.task.RuntimeTaskDataProvider;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.runtime.RuntimeTaskDefinition;
import com.atlassian.bamboo.v2.build.CommonContext;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.variable.substitutor.VariableSubstitutor;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import java.util.HashMap;
import java.util.Map;
import net.utoolity.atlassian.bamboo.ifaws.CredentialsVariablesTaskConfigurator;
import net.utoolity.atlassian.dry.EncryptionFailureException;
import net.utoolity.atlassian.dry.LicenseHelper;
import net.utoolity.atlassian.ifaws.api.AWSConnectorDTO2;
import net.utoolity.atlassian.ifaws.api.AWSConnectorScope;
import net.utoolity.atlassian.ifaws.api.AWSConnectorService2;
import net.utoolity.atlassian.ifaws.api.LicenseException;
import net.utoolity.atlassian.ifaws.api.STSCredentialsDTO;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AWSRuntimeTaskDataProvider
implements RuntimeTaskDataProvider {
    private static final Logger log = LoggerFactory.getLogger(AWSRuntimeTaskDataProvider.class);
    public static final String CREDENTIALS_ERROR_KEY = "credentialsError";
    public static final String SESSION_TOKEN_KEY = "sessionToken";
    public static final String SECRET_KEY_KEY = "secretKey";
    public static final String ACCESS_KEY_ID_KEY = "accessKeyId";
    public static final String PARTITION_KEY = "partitionKey";
    public static final String CONNECTOR_ID_KEY = "connectorId";
    public static final String CONNECTOR_NAME_KEY = "connectorName";
    public static final String IS_CONNECTOR_SERVICE_AVAILABLE_KEY = "isConnectorServiceAvailable";
    public static final String IS_VALID_LICENSE_KEY = "isValidLicense";
    public static final String IS_VALID_LICENSE_TRUE = "true";
    public static final String IS_VALID_LICENSE_FALSE = "false";
    public static final String LICENSE_ERROR_MESSAGE_KEY = "licenseErrorMessage";
    public static final String PLUGIN_VERSION_ON_SERVER_KEY = "pluginVersion";
    private final LicenseHelper licenseHelper;
    private final AWSConnectorService2 awsConnectorService2;
    private final TransactionTemplate transactionTemplate;
    protected final CustomVariableContext customVariableContext;
    private final I18nResolver i18n;

    public AWSRuntimeTaskDataProvider(LicenseHelper licenseHelper, AWSConnectorService2 awsConnectorService2, TransactionTemplate transactionTemplate, CustomVariableContext customVariableContext, I18nResolver i18n) {
        this.licenseHelper = licenseHelper;
        this.awsConnectorService2 = awsConnectorService2;
        this.transactionTemplate = transactionTemplate;
        this.customVariableContext = customVariableContext;
        this.i18n = i18n;
    }

    @NotNull
    public Map<String, String> populateRuntimeTaskData(final @NotNull TaskDefinition taskDefinition, final @NotNull CommonContext commonContext) {
        log.trace("Begin populateRuntimeTaskData() (outside TX)");
        HashMap<String, String> resultMap = new HashMap<String, String>();
        try {
            Map licenseInformationResultMap = (Map)this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Map<String, String>>(){

                public Map<String, String> doInTransaction() {
                    log.trace("Begin doInTransaction() (inside TX for populateRuntimeTaskDataLicenseInformation)");
                    HashMap<String, String> data = new HashMap<String, String>();
                    AWSRuntimeTaskDataProvider.this.populateRuntimeTaskDataLicenseInformation(data);
                    log.trace("End doInTransaction() (inside TX for populateRuntimeTaskDataLicenseInformation)");
                    return data;
                }
            });
            resultMap.putAll(licenseInformationResultMap);
        }
        catch (RuntimeException e) {
            resultMap.put(IS_VALID_LICENSE_KEY, IS_VALID_LICENSE_TRUE);
            log.warn("Unexpected exception during license check:", (Throwable)e);
        }
        Map ifawsCredentialsResultMap = (Map)this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Map<String, String>>(){

            public Map<String, String> doInTransaction() {
                log.trace("Begin doInTransaction() (inside TX for populateRuntimeTaskDataIfawsCredentials)");
                HashMap<String, String> data = new HashMap<String, String>();
                AWSRuntimeTaskDataProvider.this.populateRuntimeTaskDataIfawsCredentials(taskDefinition, commonContext, data);
                log.trace("End doInTransaction() (inside TX for populateRuntimeTaskDataIfawsCredentials)");
                return data;
            }
        });
        resultMap.putAll(ifawsCredentialsResultMap);
        log.trace("Before adding ImplementationVersion");
        resultMap.put(PLUGIN_VERSION_ON_SERVER_KEY, AWSRuntimeTaskDataProvider.class.getPackage().getImplementationVersion());
        log.trace("After adding ImplementationVersion");
        log.trace("End populateRuntimeTaskData() (outside TX)");
        return resultMap;
    }

    private void populateRuntimeTaskDataLicenseInformation(Map<String, String> data) {
        try {
            this.licenseHelper.ensureValidLicense();
            data.put(IS_VALID_LICENSE_KEY, IS_VALID_LICENSE_TRUE);
        }
        catch (LicenseException le) {
            data.put(IS_VALID_LICENSE_KEY, IS_VALID_LICENSE_FALSE);
            data.put(LICENSE_ERROR_MESSAGE_KEY, this.licenseHelper.getErrorMessageText(le));
        }
    }

    private void populateRuntimeTaskDataIfawsCredentials(TaskDefinition taskDefinition, CommonContext commonContext, Map<String, String> data) {
        boolean isIfawsCredentialsSource;
        Map configurationMap = taskDefinition.getConfiguration();
        String awsCredentialsSource = (String)configurationMap.get("awsCredentialsSource");
        boolean bl = isIfawsCredentialsSource = null != awsCredentialsSource && awsCredentialsSource.equals("IFAWS_CONNECTOR");
        if (isIfawsCredentialsSource) {
            if (null == this.awsConnectorService2) {
                data.put(IS_CONNECTOR_SERVICE_AVAILABLE_KEY, IS_VALID_LICENSE_FALSE);
                return;
            }
            data.put(IS_CONNECTOR_SERVICE_AVAILABLE_KEY, IS_VALID_LICENSE_TRUE);
            String awsConnectorId = (String)configurationMap.get("awsConnectorId");
            if ("AWS_CONNECTOR_VARIABLE_KEY".equals(awsConnectorId)) {
                String awsConnectorIdVariable = (String)configurationMap.get("awsConnectorIdVariable");
                if (CredentialsVariablesTaskConfigurator.isVariable(awsConnectorIdVariable)) {
                    VariableSubstitutor variableSubstitutor = this.createVariableSubstitutor(commonContext);
                    awsConnectorId = variableSubstitutor.substituteString(awsConnectorIdVariable);
                    if (awsConnectorIdVariable.equals(awsConnectorId)) {
                        String strippedAwsConnectorIdVariable = StringUtils.removeStart((String)awsConnectorIdVariable, (String)"$");
                        String message = "Could not resolve variable '" + strippedAwsConnectorIdVariable + "', please review your Connector variable configuration";
                        data.put(CREDENTIALS_ERROR_KEY, message);
                        return;
                    }
                } else {
                    awsConnectorId = awsConnectorIdVariable;
                }
            }
            if (StringUtils.isNotBlank((CharSequence)awsConnectorId)) {
                try {
                    STSCredentialsDTO stsCredentials = this.awsConnectorService2.getCredentials(awsConnectorId, AWSConnectorScope.SYSTEM);
                    if (null == stsCredentials) {
                        data.put(CREDENTIALS_ERROR_KEY, "Unknown connector id " + awsConnectorId);
                        return;
                    }
                    data.put(ACCESS_KEY_ID_KEY, stsCredentials.getAccessKeyId());
                    data.put(SECRET_KEY_KEY, stsCredentials.getSecretAccessKey());
                    data.put(SESSION_TOKEN_KEY, stsCredentials.getSessionToken());
                    data.put(PARTITION_KEY, stsCredentials.getPartition());
                    AWSConnectorDTO2 connectorDTO2 = this.awsConnectorService2.getConnector(awsConnectorId, AWSConnectorScope.SYSTEM);
                    if (null != connectorDTO2) {
                        data.put(CONNECTOR_ID_KEY, connectorDTO2.getId());
                        data.put(CONNECTOR_NAME_KEY, connectorDTO2.getName());
                    }
                }
                catch (EncryptionFailureException e) {
                    String message = String.format("%s - %s", e.getMessage(), this.i18n.getText("ifaws.awsConsoleLoginProxy.encryptionFailureErrorMessageKBLinkNoMarkup"));
                    data.put(CREDENTIALS_ERROR_KEY, message);
                }
                catch (RuntimeException e) {
                    data.put(CREDENTIALS_ERROR_KEY, e.getMessage());
                }
            } else {
                data.put(CREDENTIALS_ERROR_KEY, "Could not retrieve AWS Connector Id, please review your Connector selection or variable configuration");
            }
        }
    }

    private VariableSubstitutor createVariableSubstitutor(CommonContext commonContext) {
        VariableSubstitutor variableSubstitutor = this.customVariableContext.getVariableSubstitutorFactory().newSubstitutorForCommonContext(commonContext);
        return variableSubstitutor;
    }

    public void processRuntimeTaskData(@NotNull RuntimeTaskDefinition taskDefinition, @NotNull CommonContext commonContext) {
    }

    public Map<String, WhitelistedSerializable> createRuntimeTaskData(@NotNull RuntimeTaskDefinition taskDefinition, @NotNull CommonContext commonContext) {
        return new HashMap<String, WhitelistedSerializable>();
    }
}

