/*
 * Decompiled with CFR 0.152.
 */
package net.utoolity.atlassian.bamboo.ifaws.upgrade;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import net.utoolity.atlassian.dry.ApplicationVersionComparator;
import net.utoolity.atlassian.dry.ExtendedApplicationProperties;
import net.utoolity.atlassian.dry.PluginInfo;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataDirectoryUpgradeTask
implements PluginUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(DataDirectoryUpgradeTask.class);
    private final ApplicationProperties applicationProperties;
    private final ExtendedApplicationProperties extendedApplicationProperties;

    public DataDirectoryUpgradeTask(ApplicationProperties applicationProperties, ExtendedApplicationProperties extendedApplicationProperties) {
        this.applicationProperties = applicationProperties;
        this.extendedApplicationProperties = extendedApplicationProperties;
    }

    public int getBuildNumber() {
        int buildNumber = this.getUpgradabilityStatus().getBuildNumber();
        log.debug("getBuildNumber called, returning: " + String.valueOf(buildNumber));
        return buildNumber;
    }

    public String getPluginKey() {
        return PluginInfo.PLUGIN_KEY;
    }

    public String getShortDescription() {
        return "Ensure shared home directory usage";
    }

    public Collection<Message> doUpgrade() throws Exception {
        log.info("Check if plugin data directory needs to be moved to shared home directory ...");
        ArrayList<Message> messages = new ArrayList<Message>();
        UpgradabilityStatus upgradabilityStatus = this.getUpgradabilityStatus();
        log.debug(String.format("... got UpgradabilityStatus '%s', isUpgradable = '%s", upgradabilityStatus.name(), upgradabilityStatus.isUpgradable()));
        if (upgradabilityStatus.isUpgradable()) {
            log.info("... shared home directory should be available, attempt upgrade");
            return this.tryUpgrade();
        }
        log.info("... no shared home directory available, no upgrade needed");
        return messages;
    }

    private Collection<Message> tryUpgrade() throws Exception {
        boolean hasKeysDirectory;
        boolean hasLegacyPluginHome;
        log.info("Attempting plugin data directory upgrade, ensuring migration to shared home, if needed");
        ArrayList<Message> messages = new ArrayList<Message>();
        File localHome = this.extendedApplicationProperties.getLocalHomeDirectory();
        File legacyPluginHome = this.createAbstractPluginHomeDirectory(localHome);
        log.debug("Determined legacy plugin home at: {}", (Object)legacyPluginHome.getAbsolutePath());
        boolean bl = hasLegacyPluginHome = legacyPluginHome.exists() && legacyPluginHome.isDirectory();
        if (!hasLegacyPluginHome) {
            log.info("No legacy plugin home directory found, nothing to upgrade");
            return messages;
        }
        File sharedHome = this.extendedApplicationProperties.getSharedHomeDirectory();
        File sharedPluginHome = this.createAbstractPluginHomeDirectory(sharedHome);
        log.debug("Determined shared plugin home at: {}", (Object)sharedPluginHome.getAbsolutePath());
        boolean legacyPluginHomeIsSharedHome = sharedPluginHome.equals(legacyPluginHome);
        if (legacyPluginHomeIsSharedHome) {
            log.info("Legacy plugin home directory already in shared home, nothing to upgrade");
            return messages;
        }
        log.info("Found legacy plugin home directory, checking for possible data migration needs");
        File legacyKeysDirectory = new File(legacyPluginHome, "keys");
        boolean bl2 = hasKeysDirectory = legacyKeysDirectory.exists() && legacyKeysDirectory.isDirectory();
        if (hasKeysDirectory) {
            log.info("Found legacy keys directory, migrating to new shared plugin home");
            File sharedKeysDirectory = new File(sharedPluginHome, "keys");
            FileUtils.copyDirectory((File)legacyKeysDirectory, (File)sharedKeysDirectory);
        }
        log.info("Removing legacy plugin home directory");
        FileUtils.deleteQuietly((File)legacyPluginHome);
        return messages;
    }

    private File createAbstractPluginHomeDirectory(File localHome) {
        File legacyDataHome = new File(localHome, "data");
        File legacyPluginHome = new File(legacyDataHome, this.getPluginKey());
        return legacyPluginHome;
    }

    private UpgradabilityStatus getUpgradabilityStatus() {
        log.debug("Determine upgradabilty, based on SAL methods depending on host app version");
        ApplicationVersionComparator versionComparator = new ApplicationVersionComparator(this.applicationProperties);
        if (versionComparator.isHigherOrEqualTo("7.1.0")) {
            log.debug("... Bamboo >= 7.1.0, should be able to use new SAL method");
            try {
                Optional homeDirOptional = this.applicationProperties.getSharedHomeDirectory();
                if (homeDirOptional.isPresent()) {
                    log.debug("... shared home available, can upgrade");
                    return UpgradabilityStatus.SHARED_HOME_AVAILABLE;
                }
                log.debug("... shared home unavailable, cannot upgrade");
                return UpgradabilityStatus.SHARED_HOME_UNAVAILABLE;
            }
            catch (NoSuchMethodError e) {
                log.warn("... unexpected NoSuchMethodError for getSharedHomeDirectory(), assuming SAL to old despite Bamboo version suggesting otherwise");
                return UpgradabilityStatus.SAL_TO_OLD;
            }
        }
        log.debug("... Bamboo < 7.1.0, can't upgrade");
        return UpgradabilityStatus.SAL_TO_OLD;
    }

    private static enum UpgradabilityStatus {
        SAL_TO_OLD(false, 201500000),
        SHARED_HOME_UNAVAILABLE(false, 201500001),
        SHARED_HOME_AVAILABLE(true, 201500002);

        private boolean isUpgradable;
        private int buildNumber;

        private UpgradabilityStatus(boolean canUpgrade, int buildNumber) {
            this.isUpgradable = canUpgrade;
            this.buildNumber = buildNumber;
        }

        public boolean isUpgradable() {
            return this.isUpgradable;
        }

        public int getBuildNumber() {
            return this.buildNumber;
        }
    }
}

