AJS.toInit(function () {
    var contextPath = AJS.contextPath();
    var mainMenuLink = AJS.$("#ifaws-aws-resources-link");
    var populateAWSResourcesDropdown = !AJS.version.match("PDL-OLD$") && AJS.version.substring(0, 1) >= 5 && mainMenuLink.length > 0;
    if (populateAWSResourcesDropdown) {

        // Utility function to create a notification style list entry
        function createMessageListNotification(type, text) {
            return AJS.$("<li/>")
                .attr("class", "ifaws-dropdown-notification")
                .append(
                    AJS.$("<span/>")
                        .attr("class", "aui-icon aui-icon-" + type)
                        .text(type)
                )
                .append(" " + text);
        }

        // Prepare the initial Dropdown2 body (i.e. the wait spinner placeholder
        var dropDownBody = AJS.$("<div/>")
        .attr({
            "class": "aui-dropdown2 aui-style-default",
            "id": "ifaws-aws-resources-links-dropdown"
        })
        .append(
            AJS.$("<div/>")
                .attr({
                    "class": "aui-dropdown2-section",
                    "id": "ifaws-aws-resources-console-link-section",
                })
                .html(
                    AJS.$("<ul/>")
                    .attr({
                        "class": "aui-list-truncate",
                        "id": "ifaws-aws-resources-console-link-list",
                    })
                    .html(
                        AJS.$("<li/>")
                            .html(createMessageListNotification("wait", AJS.I18n.getText("ifaws.awsResourceSection.message.loading")))
                    )
                )
        );

        // Convert our menu link into a Dropdown2 trigger
        mainMenuLink.attr({
            'class': 'aui-dropdown2-trigger',
            'aria-owns': 'ifaws-aws-resources-links-dropdown',
            'aria-haspopup': true
        });
        // Insert the placeholder body
        mainMenuLink.after(dropDownBody);

        // Callback function to fetch the actual menu markup
        var menuContentFetcher = function() {
            // Do we need to populate via REST call?
            var dropdown = AJS.$("#ifaws-aws-resources-links-dropdown");
            if (!dropdown.hasClass("aaws-content-fetched")) {
                AJS.$.ajax({
                    url: contextPath + "/rest/identity-federation-for-aws/2.0/dropdown/aws-resources-menu",
                    type: "GET",
                    dataType: "json",
                    contentType: "application/json; charset=utf-8",
                    success: successHandler,
                    error: errorHandler
                });
                dropdown.addClass("aaws-content-fetched");
            }
            else {
                // NOTE: Intentionally doing nothing, content is already fetched.
            }
        };

        // Successful callback simply replaces whole body content
        var successHandler = function(msg) {
            dropDownBody.html(msg.html);
        };

        // Error replaces initial wait spinner with error icon and message
        var errorHandler = function(jqXHR, textStatus, errorThrown) {
            var displayMessage = AJS.I18n.getText("ifaws.awsResourceSection.message.error");
            // Do we have a custom error message?
            if (jqXHR.hasOwnProperty("responseText")) {
                try {
                    var parsedResponse = AJS.$.parseJSON(jqXHR.responseText);
                    if (parsedResponse.hasOwnProperty("errorMessages") && AJS.$.isArray(parsedResponse.errorMessages)
                            && 0 < parsedResponse.errorMessages.length) {
                        // Yes, take first one
                        displayMessage = parsedResponse.errorMessages[0];
                    }
                }
                catch (e) {
                    // NOTE: Intentionally doing nothing, relying on default error message instead
                }
            }
            AJS.$("#ifaws-aws-resources-console-link-list").html(createMessageListNotification("warning", displayMessage));
        };

        // Register initial content fetching trigger
        AJS.$("#ifaws-aws-resources-links-dropdown").on({
            "aui-dropdown2-show": menuContentFetcher
        });
    }
});
