/*
 * Decompiled with CFR 0.152.
 */
package net.utoolity.atlassian.ifaws.rest.common;

import com.amazonaws.AmazonServiceException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import net.utoolity.atlassian.ifaws.rest.common.ErrorResponseDTO;

@Provider
public class AmazonServiceExceptionMapper
implements ExceptionMapper<AmazonServiceException> {
    public Response toResponse(AmazonServiceException ase) {
        Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
        switch (ase.getErrorType()) {
            case Client: {
                status = Response.Status.BAD_REQUEST;
                break;
            }
            case Service: {
                status = Response.Status.INTERNAL_SERVER_ERROR;
                break;
            }
            case Unknown: {
                status = Response.Status.INTERNAL_SERVER_ERROR;
                break;
            }
            default: {
                status = Response.Status.INTERNAL_SERVER_ERROR;
            }
        }
        ErrorResponseDTO responseEntity = new ErrorResponseDTO((Response.StatusType)status, ase.getErrorCode(), AmazonServiceException.class.getSimpleName());
        if (null != ase.getErrorMessage()) {
            responseEntity.addErrorMessage(ase.getErrorMessage());
        }
        return Response.status((Response.StatusType)responseEntity.getStatus()).entity((Object)responseEntity).build();
    }
}

