/*
 * Decompiled with CFR 0.152.
 */
package net.utoolity.atlassian.ifaws.model;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.services.securitytoken.model.PolicyDescriptorType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import net.utoolity.atlassian.ifaws.IAMPolicyValidator;
import net.utoolity.atlassian.ifaws.ao.AWSConnector;
import net.utoolity.atlassian.ifaws.ao.AWSConnectorGroup;
import net.utoolity.atlassian.ifaws.ao.DefaultCloudProvider;
import net.utoolity.atlassian.ifaws.api.AWSConnectorScope;
import net.utoolity.atlassian.ifaws.api.AWSConnectorType;
import net.utoolity.atlassian.ifaws.api.ExternalCredentialsProviderService;
import net.utoolity.atlassian.ifaws.model.AWSAccountEntity;
import net.utoolity.atlassian.ifaws.model.AWSAccountEntityImpl;
import net.utoolity.atlassian.ifaws.model.AWSConnectorEntity;

public class AWSConnectorEntityImpl
implements AWSConnectorEntity {
    private final AWSConnector awsConnector;

    public AWSConnectorEntityImpl(AWSConnector awsConnector) {
        if (null == awsConnector) {
            throw new RuntimeException("AWSConnectorEntity can not be null");
        }
        this.awsConnector = awsConnector;
    }

    @Override
    public AWSCredentials getLongLivedCredentials() {
        AWSAccountEntity awsAccount = this.getAWSAccount();
        if (ExternalCredentialsProviderService.isPlaceholderAccount(awsAccount)) {
            AWSCredentialsProvider provider = ExternalCredentialsProviderService.getExternalCredentialsProvider(awsAccount);
            AWSCredentials credentials = provider.getCredentials();
            return credentials;
        }
        return this.getAWSAccount().getAWSCredentials();
    }

    @Override
    public AWSCredentialsProvider getLongLivedCredentialsProvider() {
        AWSAccountEntity awsAccount = this.getAWSAccount();
        if (ExternalCredentialsProviderService.isPlaceholderAccount(awsAccount)) {
            return ExternalCredentialsProviderService.getExternalCredentialsProvider(awsAccount);
        }
        AWSCredentials credentials = this.getAWSAccount().getAWSCredentials();
        return new AWSStaticCredentialsProvider(credentials);
    }

    @Override
    public String[] getGroupNames() {
        AWSConnectorGroup[] groups = this.awsConnector.getGroups();
        ArrayList<String> groupNames = new ArrayList<String>();
        for (AWSConnectorGroup group : groups) {
            groupNames.add(group.getName());
        }
        return groupNames.toArray(new String[groupNames.size()]);
    }

    @Override
    public void setType(String typeName) throws IllegalArgumentException {
        AWSConnectorType type = AWSConnectorType.valueOf(typeName);
        this.setTypeFromEnum(type);
    }

    @Override
    public void setTypeFromEnum(AWSConnectorType type) {
        this.awsConnector.setType(type.name());
    }

    @Override
    public AWSConnectorType getTypeAsEnum() {
        return AWSConnectorType.valueOf(this.awsConnector.getType());
    }

    @Override
    public boolean hasScope(AWSConnectorScope scope) {
        return this.awsConnector.getScope() == scope;
    }

    @Override
    public DefaultCloudProvider getCloudProvider() {
        if (null != this.getAWSAccount()) {
            return this.getAWSAccount().getCloudProvider();
        }
        return null;
    }

    @Override
    public String getId() {
        return this.awsConnector.getId();
    }

    @Override
    public String getName() {
        return this.awsConnector.getName();
    }

    @Override
    public void setName(String name) {
        this.awsConnector.setName(name);
    }

    @Override
    public String getType() {
        return this.awsConnector.getType();
    }

    @Override
    public AWSConnectorScope getScope() {
        return this.awsConnector.getScope();
    }

    @Override
    public void setScope(AWSConnectorScope scope) {
        this.awsConnector.setScope(scope);
    }

    @Override
    public AWSAccountEntity getAWSAccount() {
        return new AWSAccountEntityImpl(this.awsConnector.getAWSAccount());
    }

    @Override
    public void setAWSAccount(AWSAccountEntity awsAccount) {
        this.awsConnector.setAWSAccount(awsAccount.getAWSAccountEntity());
    }

    @Override
    public String getRoleArn() {
        return this.awsConnector.getRoleArn();
    }

    @Override
    public void setRoleArn(String roleArn) {
        this.awsConnector.setRoleArn(roleArn);
    }

    @Override
    public String getExternalId() {
        return this.awsConnector.getExternalId();
    }

    @Override
    public void setExternalId(String externalId) {
        this.awsConnector.setExternalId(externalId);
    }

    @Override
    public String getIAMPolicy() {
        return this.awsConnector.getIAMPolicy();
    }

    @Override
    public void setIAMPolicy(String policy) {
        this.awsConnector.setIAMPolicy(policy);
    }

    @Override
    public Collection<PolicyDescriptorType> getIAMPolicyArnsCollection() {
        String policyArnsJson = this.awsConnector.getIAMPolicyArns();
        Collection<PolicyDescriptorType> parsedJson = IAMPolicyValidator.parsePolicyArns(policyArnsJson);
        return parsedJson;
    }

    @Override
    public void setIAMPolicyArnsCollection(Collection<PolicyDescriptorType> policyArns) {
        String policyArnsJson = IAMPolicyValidator.serializePolicyArns(policyArns);
        this.awsConnector.setIAMPolicyArns(policyArnsJson);
    }

    @Override
    public String getIAMPolicyArns() {
        return this.awsConnector.getIAMPolicyArns();
    }

    @Override
    public void setIAMPolicyArns(String policyArnsJson) {
        Collection<PolicyDescriptorType> parsedPolicyArns = IAMPolicyValidator.parsePolicyArns(policyArnsJson);
        this.awsConnector.setIAMPolicyArns(policyArnsJson);
    }

    @Override
    public Integer getDurationSecondsMax() {
        return this.awsConnector.getDurationSecondsMax();
    }

    @Override
    public void setDurationSecondsMax(Integer durationSecondsMax) {
        this.awsConnector.setDurationSecondsMax(durationSecondsMax);
    }

    @Override
    public int getV1Id() {
        return this.awsConnector.getV1Id();
    }

    @Override
    public void setV1Id(int v1Id) {
        this.awsConnector.setV1Id(v1Id);
    }

    @Override
    public AWSConnectorGroup[] getGroups() {
        return this.awsConnector.getGroups();
    }

    @Override
    public AWSConnector getAWSConnectorEntity() {
        return this.awsConnector;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AWSConnectorEntityImpl)) {
            return false;
        }
        AWSConnectorEntityImpl other = (AWSConnectorEntityImpl)obj;
        return this.awsConnector.equals(other.getAWSConnectorEntity());
    }

    public int hashCode() {
        return Objects.hash(this.awsConnector);
    }
}

