/*
 * Decompiled with CFR 0.152.
 */
package net.utoolity.atlassian.ifaws.api.impl;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSSessionCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import net.utoolity.atlassian.dry.AWSStaticSessionCredentialsProvider;
import net.utoolity.atlassian.dry.LicenseHelper;
import net.utoolity.atlassian.ifaws.api.AWSConnectorService2;
import net.utoolity.atlassian.ifaws.api.CodeArtifactCredentialsDTO;
import net.utoolity.atlassian.ifaws.api.CodeArtifactCredentialsService;
import net.utoolity.atlassian.ifaws.api.LicenseException;
import net.utoolity.atlassian.ifaws.api.NotAuthorizedException;
import net.utoolity.atlassian.ifaws.api.STSCredentialsDTO;
import net.utoolity.atlassian.ifaws.aws.CodeArtifact;

public class CodeArtifactCredentialsServiceImpl
implements CodeArtifactCredentialsService {
    private final LicenseHelper licenseHelper;
    private final AWSConnectorService2 awsConnectorService2;

    public CodeArtifactCredentialsServiceImpl(LicenseHelper licenseHelper, AWSConnectorService2 awsConnectorService2) {
        this.licenseHelper = licenseHelper;
        this.awsConnectorService2 = awsConnectorService2;
    }

    @Override
    public CodeArtifactCredentialsDTO getCredentials(String connectorId, String domain, String regionName) throws NotAuthorizedException, LicenseException {
        return this.getCredentials(connectorId, domain, null, null, regionName);
    }

    @Override
    public CodeArtifactCredentialsDTO getCredentials(String connectorId, String domain, Integer durationSeconds, String regionName) throws NotAuthorizedException, LicenseException {
        return this.getCredentials(connectorId, domain, null, durationSeconds, regionName);
    }

    @Override
    public CodeArtifactCredentialsDTO getCredentials(String connectorId, String domain, String domainOwner, String regionName) throws NotAuthorizedException, LicenseException {
        return this.getCredentials(connectorId, domain, domainOwner, null, regionName);
    }

    @Override
    public CodeArtifactCredentialsDTO getCredentials(String connectorId, String domain, String domainOwner, Integer durationSeconds, String regionName) throws NotAuthorizedException, LicenseException {
        this.licenseHelper.ensureValidLicense();
        STSCredentialsDTO stsCredentialsDTO = this.awsConnectorService2.getCredentials(connectorId);
        if (null == stsCredentialsDTO) {
            return null;
        }
        BasicSessionCredentials awsSessionCredentials = new BasicSessionCredentials(stsCredentialsDTO.getAccessKeyId(), stsCredentialsDTO.getSecretAccessKey(), stsCredentialsDTO.getSessionToken());
        AWSStaticSessionCredentialsProvider credentialsProvider = new AWSStaticSessionCredentialsProvider((AWSSessionCredentials)awsSessionCredentials);
        CodeArtifactCredentialsDTO credentialsDTO = CodeArtifact.getCodeArtifactCredentials((AWSCredentialsProvider)credentialsProvider, domain, domainOwner, durationSeconds, regionName, null);
        return credentialsDTO;
    }
}

