/*
 * Decompiled with CFR 0.152.
 */
package net.utoolity.atlassian.ifaws.api.impl;

import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import java.util.ArrayList;
import java.util.List;
import net.utoolity.atlassian.dry.LicenseHelper;
import net.utoolity.atlassian.ifaws.AWSSecurityTokenClientProxy;
import net.utoolity.atlassian.ifaws.PluginConfiguration;
import net.utoolity.atlassian.ifaws.ao.AWSConnectorPersistenceService;
import net.utoolity.atlassian.ifaws.api.AWSConnectorDTO22;
import net.utoolity.atlassian.ifaws.api.AWSConnectorScope;
import net.utoolity.atlassian.ifaws.api.AWSConnectorService22;
import net.utoolity.atlassian.ifaws.api.LicenseException;
import net.utoolity.atlassian.ifaws.api.NotAuthorizedException;
import net.utoolity.atlassian.ifaws.api.impl.AWSConnectorService2ImplBase;
import net.utoolity.atlassian.ifaws.model.AWSConnectorEntity;

public class AWSConnectorService22Impl
extends AWSConnectorService2ImplBase
implements AWSConnectorService22 {
    public AWSConnectorService22Impl(LicenseHelper licenseHelper, AWSConnectorPersistenceService awsConnectorPersistenceService, AWSSecurityTokenClientProxy tokenClientProxy, UserManager userManager, PluginConfiguration pluginConfiguration) {
        super(licenseHelper, awsConnectorPersistenceService, tokenClientProxy, userManager, pluginConfiguration);
    }

    @Override
    public List<AWSConnectorDTO22> getConnectors() throws LicenseException {
        return this.getConnectors(null);
    }

    @Override
    public List<AWSConnectorDTO22> getConnectors(AWSConnectorScope awsConnectorScope) throws LicenseException {
        this.licenseHelper.ensureValidLicense();
        UserKey userKey = this.findCurrentUserKey();
        AWSConnectorEntity[] matches = null != awsConnectorScope ? this.awsConnectorPersistenceService.findByScope(awsConnectorScope) : this.awsConnectorPersistenceService.findAll();
        ArrayList<AWSConnectorDTO22> result = new ArrayList<AWSConnectorDTO22>();
        for (AWSConnectorEntity awsConnector : matches) {
            if (!this.hasAccess(userKey, awsConnector, null)) continue;
            result.add(AWSConnectorService22Impl.createAWSConnectorDTO22(awsConnector));
        }
        return result;
    }

    @Override
    public AWSConnectorDTO22 getConnector(String connectorId) throws NotAuthorizedException, LicenseException {
        return this.getConnector(connectorId, null);
    }

    @Override
    public AWSConnectorDTO22 getConnector(String connectorId, AWSConnectorScope awsConnectorScope) throws NotAuthorizedException, LicenseException {
        this.licenseHelper.ensureValidLicense();
        AWSConnectorEntity awsConnector = this.awsConnectorPersistenceService.getById(connectorId);
        UserKey userKey = this.findCurrentUserKey();
        if (null == awsConnector) {
            return null;
        }
        if (!this.hasAccess(userKey, awsConnector, awsConnectorScope)) {
            throw new NotAuthorizedException("Requesting user is not authorized to access this Connector");
        }
        return AWSConnectorService22Impl.createAWSConnectorDTO22(awsConnector);
    }

    public static AWSConnectorDTO22 createAWSConnectorDTO22(AWSConnectorEntity awsConnector) {
        AWSConnectorDTO22 AWSConnectorDTO222 = new AWSConnectorDTO22();
        AWSConnectorDTO222.setId(awsConnector.getId());
        AWSConnectorDTO222.setName(awsConnector.getName());
        AWSConnectorDTO222.setType(awsConnector.getType());
        AWSConnectorDTO222.setScope(null != awsConnector.getScope() ? awsConnector.getScope().name() : null);
        AWSConnectorDTO222.setDurationSecondsMax(awsConnector.getDurationSecondsMax());
        if (null != awsConnector.getCloudProvider()) {
            AWSConnectorDTO222.setPartition(awsConnector.getCloudProvider().getPartitionKey());
        }
        AWSConnectorDTO222.setAccountId(awsConnector.getAWSAccount().getId());
        AWSConnectorDTO222.setRoleArn(awsConnector.getRoleArn());
        AWSConnectorDTO222.setExternalId(awsConnector.getExternalId());
        AWSConnectorDTO222.setIamPolicy(awsConnector.getIAMPolicy());
        AWSConnectorDTO222.setIamPolicyArns(awsConnector.getIAMPolicyArns());
        AWSConnectorDTO222.setGroups(awsConnector.getGroupNames());
        return AWSConnectorDTO222;
    }
}

