/*
 * Decompiled with CFR 0.152.
 */
package net.utoolity.atlassian.ifaws.ao;

import com.google.common.base.Predicate;
import javax.annotation.Nullable;
import net.utoolity.atlassian.ifaws.ao.AWSConnector;
import org.apache.commons.lang3.StringUtils;

public final class AWSConnectorPredicates {
    private AWSConnectorPredicates() {
    }

    public static Predicate<AWSConnector> nameEquals(final String searchTerm) {
        return new Predicate<AWSConnector>(){

            public boolean apply(@Nullable AWSConnector input) {
                return StringUtils.equals((CharSequence)input.getName(), (CharSequence)searchTerm);
            }
        };
    }

    public static Predicate<AWSConnector> nameEqualsIgnoreCase(final String searchTerm) {
        return new Predicate<AWSConnector>(){

            public boolean apply(@Nullable AWSConnector input) {
                return StringUtils.equalsIgnoreCase((CharSequence)input.getName(), (CharSequence)searchTerm);
            }
        };
    }

    public static Predicate<AWSConnector> nameContainsIgnoreCase(final String searchTerm) {
        return new Predicate<AWSConnector>(){

            public boolean apply(@Nullable AWSConnector input) {
                return StringUtils.containsIgnoreCase((CharSequence)input.getName(), (CharSequence)searchTerm);
            }
        };
    }

    public static Predicate<AWSConnector> connectorContainsIgnoreCase(final String searchTerm) {
        return new Predicate<AWSConnector>(){

            public boolean apply(@Nullable AWSConnector input) {
                boolean nameMatch = StringUtils.containsIgnoreCase((CharSequence)input.getName(), (CharSequence)searchTerm);
                boolean accountNameMatch = StringUtils.containsIgnoreCase((CharSequence)input.getAWSAccount().getName(), (CharSequence)searchTerm);
                boolean accountKeyIdMatch = StringUtils.containsIgnoreCase((CharSequence)input.getAWSAccount().getAWSAccessKeyId(), (CharSequence)searchTerm);
                boolean idMatch = StringUtils.equalsIgnoreCase((CharSequence)input.getId(), (CharSequence)searchTerm);
                return nameMatch || idMatch || accountNameMatch || accountKeyIdMatch;
            }
        };
    }
}

