/*
 * Decompiled with CFR 0.152.
 */
package net.utoolity.atlassian.dry;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import net.utoolity.atlassian.dry.ExtendedApplicationProperties;
import net.utoolity.atlassian.dry.PluginFileStorage;
import net.utoolity.atlassian.dry.PluginInfo;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.WildcardFileFilter;

public class PluginFileStorageImpl
implements PluginFileStorage {
    private final ExtendedApplicationProperties extendedApplicationProperties;
    private final String pluginKey = PluginInfo.PLUGIN_KEY;
    private final File dataHome;
    private final File pluginHome;
    private final String encoding = "UTF-8";

    public PluginFileStorageImpl(ExtendedApplicationProperties extendedApplicationProperties) {
        this.extendedApplicationProperties = extendedApplicationProperties;
        File appHome = extendedApplicationProperties.getSharedHomeDirectory();
        this.dataHome = new File(appHome, "data");
        this.ensureAbsoluteDirectoryExists(this.dataHome);
        this.pluginHome = new File(this.dataHome, this.pluginKey);
        this.ensureAbsoluteDirectoryExists(this.pluginHome);
    }

    @Override
    public String readTextFile(String filename) throws IOException {
        File requestedFile = new File(this.pluginHome, filename);
        return this.readTextFile(requestedFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String readTextFile(File requestedFile) throws IOException {
        String content;
        try (FileInputStream inputStream = new FileInputStream(requestedFile);){
            content = IOUtils.toString((InputStream)inputStream, (String)"UTF-8");
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTextFile(String filename, String content) throws IOException {
        File targetFile = new File(this.pluginHome, filename);
        try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(targetFile), "UTF-8");){
            out.write(content);
        }
    }

    @Override
    public File[] findFiles(String directoryname, String pattern) {
        if (null == pattern) {
            pattern = "*";
        }
        File dir = new File(this.pluginHome, directoryname);
        WildcardFileFilter fileFilter = new WildcardFileFilter(pattern);
        File[] files = dir.listFiles((FileFilter)fileFilter);
        return files;
    }

    @Override
    public void ensureDirectoryExists(String directoryName) {
        File targetDir = new File(this.pluginHome, directoryName);
        if (!targetDir.exists()) {
            targetDir.mkdir();
        }
    }

    private void ensureAbsoluteDirectoryExists(File directory) {
        if (!directory.exists()) {
            directory.mkdir();
        }
    }
}

