/*
 * Decompiled with CFR 0.152.
 */
package net.utoolity.atlassian.bamboo.ifaws;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import net.utoolity.atlassian.bamboo.ifaws.BaseTaskConfigurator;
import net.utoolity.atlassian.ifaws.aws.AWS;
import net.utoolity.atlassian.ifaws.aws.CodeArtifact;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class CodeArtifactCredentialsVariablesTaskConfigurator
extends BaseTaskConfigurator {
    public static final String DOMAIN = "domain";
    public static final String DOMAIN_OWNER = "domainOwner";
    public static final String DURATION_SECONDS = "durationSeconds";
    private static final Set<String> FIELD_COLLECTION = ImmutableSet.builder().add((Object[])new String[]{"domain", "domainOwner", "durationSeconds"}).build();

    @Override
    protected Set<String> getFieldCollection() {
        return FIELD_COLLECTION;
    }

    @Override
    public void validate(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        super.validate(params, errorCollection);
        this.validateDomain(params, errorCollection);
        this.validateDomainOwner(params, errorCollection);
        this.validateDurationSeconds(params, errorCollection);
    }

    private void validateDomain(ActionParametersMap params, ErrorCollection errorCollection) {
        String domain = params.getString(DOMAIN);
        if (CodeArtifactCredentialsVariablesTaskConfigurator.isVariable(domain)) {
            return;
        }
        if (!CodeArtifact.isValidDomain(domain)) {
            errorCollection.addError(DOMAIN, this.getI18nBean().getText("net.utoolity.atlassian.bamboo.ifaws.codeartifactcredentialsvariables.domain.error"));
        }
    }

    private void validateDomainOwner(ActionParametersMap params, ErrorCollection errorCollection) {
        String domainOwner = params.getString(DOMAIN_OWNER);
        if (StringUtils.isBlank((CharSequence)domainOwner) || CodeArtifactCredentialsVariablesTaskConfigurator.isVariable(domainOwner)) {
            return;
        }
        if (!CodeArtifact.isValidDomainOwner(domainOwner)) {
            errorCollection.addError(DOMAIN_OWNER, this.getI18nBean().getText("net.utoolity.atlassian.bamboo.ifaws.codeartifactcredentialsvariables.domainOwner.error"));
        }
    }

    private void validateDurationSeconds(ActionParametersMap params, ErrorCollection errorCollection) {
        String durationSecondsString = params.getString(DURATION_SECONDS);
        if (StringUtils.isBlank((CharSequence)durationSecondsString) || CodeArtifactCredentialsVariablesTaskConfigurator.isVariable(durationSecondsString)) {
            return;
        }
        Integer durationSeconds = null;
        if (StringUtils.isNotBlank((CharSequence)durationSecondsString)) {
            try {
                durationSeconds = Integer.parseInt(durationSecondsString);
            }
            catch (NumberFormatException nfe) {
                errorCollection.addError(DURATION_SECONDS, this.getI18nBean().getText("net.utoolity.atlassian.bamboo.ifaws.codeartifactcredentialsvariables.durationSeconds.errorParsing"));
                return;
            }
        }
        if (!CodeArtifact.isValidDurationSeconds(durationSeconds)) {
            errorCollection.addError(DURATION_SECONDS, this.getI18nBean().getText("net.utoolity.atlassian.bamboo.ifaws.codeartifactcredentialsvariables.durationSeconds.errorValue"));
        }
    }

    @Override
    protected Map<String, String> getRegionMap() {
        return AWS.getRegionMap("codeartifact");
    }
}

