/*
 * Decompiled with CFR 0.152.
 */
package net.utoolity.atlassian.ifaws.rest.v2;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.atlassian.sal.api.message.I18nResolver;
import java.util.ArrayList;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import net.utoolity.atlassian.dry.LicenseHelper;
import net.utoolity.atlassian.ifaws.AWSSecurityTokenClientProxy;
import net.utoolity.atlassian.ifaws.ao.AWSAccountPersistenceService;
import net.utoolity.atlassian.ifaws.ao.DefaultCloudProvider;
import net.utoolity.atlassian.ifaws.ao.IAMRoleForEC2AndECSService;
import net.utoolity.atlassian.ifaws.api.AWSAccountDTO2;
import net.utoolity.atlassian.ifaws.api.STSCallerIdentityDTO;
import net.utoolity.atlassian.ifaws.model.AWSAccountEntity;
import net.utoolity.atlassian.ifaws.rest.common.DTOCollectionImpl;
import net.utoolity.atlassian.ifaws.rest.common.GenericRestException;
import org.apache.commons.lang3.StringUtils;

@Path(value="/accounts")
public class AWSAccountResource {
    private final LicenseHelper licenseHelper;
    private final AWSAccountPersistenceService awsAccountPersistenceService;
    private final AWSSecurityTokenClientProxy tokenClientProxy;
    private final I18nResolver i18n;

    @Inject
    public AWSAccountResource(LicenseHelper licenseHelper, AWSAccountPersistenceService awsAccountPersistenceService, AWSSecurityTokenClientProxy tokenClientProxy, I18nResolver i18n) {
        this.licenseHelper = licenseHelper;
        this.awsAccountPersistenceService = awsAccountPersistenceService;
        this.tokenClientProxy = tokenClientProxy;
        this.i18n = i18n;
    }

    @GET
    @Produces(value={"application/json"})
    public Response findAccounts() {
        this.licenseHelper.ensureValidLicense();
        AWSAccountEntity[] accounts = this.awsAccountPersistenceService.findAll();
        ArrayList<AWSAccountDTO2> accountDataList = new ArrayList<AWSAccountDTO2>();
        for (AWSAccountEntity account : accounts) {
            accountDataList.add(AWSAccountResource.fromAWSAccount(account));
        }
        DTOCollectionImpl accountDataCollection = new DTOCollectionImpl(accountDataList);
        return Response.ok(accountDataCollection).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response post(@DefaultValue(value="false") @QueryParam(value="skipValidation") boolean skipValidation, AWSAccountDTO2 accountData, @Context HttpServletRequest request) {
        this.licenseHelper.ensureValidLicense();
        if (this.accountWithNameExists(accountData.getName(), null)) {
            throw new GenericRestException(this.i18n.getText("ifaws.accountCRUD.errorMessage.duplicateName")).withResponseStatus(Response.Status.CONFLICT);
        }
        if (!skipValidation) {
            this.validateAccessKeyId(accountData.getAWSAccessKeyId().trim());
            try {
                STSCallerIdentityDTO sTSCallerIdentityDTO = this.validateViaCallerIdentityRequest(accountData.getAWSAccessKeyId().trim(), accountData.getAWSSecretKey().trim(), accountData.getCloudProviderKey().trim());
            }
            catch (AmazonServiceException ase) {
                throw new GenericRestException(this.i18n.getText("ifaws.accountCRUD.errorMessage.invalidCredentials"));
            }
            catch (AmazonClientException ace) {
                throw new GenericRestException(this.i18n.getText("ifaws.accountCRUD.errorMessage.unableToValidate"));
            }
        }
        Map<String, Object> propertyMap = this.awsAccountPersistenceService.createEmptyPropertyMap();
        propertyMap.remove("ID");
        propertyMap.remove("V1_ID");
        propertyMap.put("NAME", accountData.getName().trim());
        propertyMap.put("AWS_ACCESS_KEY_ID", accountData.getAWSAccessKeyId().trim());
        propertyMap.put("AWS_SECRET_KEY", accountData.getAWSSecretKey().trim());
        propertyMap.put("CLOUD_PROVIDER_KEY", accountData.getCloudProviderKey().trim());
        AWSAccountEntity account = this.awsAccountPersistenceService.create(propertyMap);
        return Response.ok((Object)AWSAccountResource.fromAWSAccount(account)).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{id}")
    public Response getAccount(@PathParam(value="id") String accountId) {
        this.licenseHelper.ensureValidLicense();
        AWSAccountEntity account = null;
        account = this.awsAccountPersistenceService.getById(accountId);
        if (null == account) {
            throw new GenericRestException().withResponseStatus(Response.Status.NOT_FOUND);
        }
        return Response.ok((Object)AWSAccountResource.fromAWSAccount(account)).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{id}/caller-identity")
    public Response getCallerIdentity(@PathParam(value="id") String accountId) {
        this.licenseHelper.ensureValidLicense();
        AWSAccountEntity account = null;
        account = this.awsAccountPersistenceService.getById(accountId);
        if (null == account) {
            throw new GenericRestException().withResponseStatus(Response.Status.NOT_FOUND);
        }
        STSCallerIdentityDTO stsCallerIdentityDTO = null;
        stsCallerIdentityDTO = this.tokenClientProxy.getCallerIdentity(account.getAWSCredentials(), account.getCloudProvider());
        return Response.ok((Object)stsCallerIdentityDTO).build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/{id}")
    public Response put(@DefaultValue(value="false") @QueryParam(value="skipValidation") boolean skipValidation, @PathParam(value="id") String accountId, AWSAccountDTO2 accountData, @Context HttpServletRequest request) {
        Object persistedCredentials;
        boolean secretKeyChanged;
        this.licenseHelper.ensureValidLicense();
        AWSAccountEntity account = null;
        account = this.awsAccountPersistenceService.getById(accountId);
        if (null == account) {
            throw new GenericRestException().withResponseStatus(Response.Status.NOT_FOUND);
        }
        if (IAMRoleForEC2AndECSService.isEC2PlaceholderAccount(account)) {
            throw new GenericRestException(this.i18n.getText("ifaws.accountCRUD.errorMessage.ec2PlaceholderAccount")).withResponseStatus(Response.Status.FORBIDDEN);
        }
        if (!accountId.equals(accountData.getId())) {
            throw new GenericRestException().withResponseStatus(Response.Status.CONFLICT);
        }
        if (this.accountWithNameExists(accountData.getName(), account.getId())) {
            throw new GenericRestException(this.i18n.getText("ifaws.accountCRUD.errorMessage.duplicateName")).withResponseStatus(Response.Status.CONFLICT);
        }
        account.setName(accountData.getName().trim());
        account.setAWSAccessKeyId(accountData.getAWSAccessKeyId().trim());
        String secretKey = null;
        boolean bl = secretKeyChanged = !accountData.getAWSSecretKey().equals("Secret key intentionally retained");
        if (secretKeyChanged) {
            secretKey = accountData.getAWSSecretKey().trim();
            account.setAWSSecretKey(secretKey);
        } else {
            persistedCredentials = account.getAWSCredentials();
            secretKey = persistedCredentials.getAWSSecretKey();
        }
        account.setCloudProviderKey(accountData.getCloudProviderKey().trim());
        if (!skipValidation) {
            this.validateAccessKeyId(accountData.getAWSAccessKeyId().trim());
            try {
                persistedCredentials = this.validateViaCallerIdentityRequest(accountData.getAWSAccessKeyId().trim(), secretKey, accountData.getCloudProviderKey().trim());
            }
            catch (AmazonServiceException ase) {
                throw new GenericRestException(this.i18n.getText("ifaws.accountCRUD.errorMessage.invalidCredentials"));
            }
            catch (AmazonClientException ace) {
                throw new GenericRestException(this.i18n.getText("ifaws.accountCRUD.errorMessage.unableToValidate"));
            }
        }
        account = this.awsAccountPersistenceService.save(account, secretKeyChanged);
        return Response.ok((Object)AWSAccountResource.fromAWSAccount(account)).build();
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/{id}")
    public Response delete(@PathParam(value="id") String accountId) {
        this.licenseHelper.ensureValidLicense();
        AWSAccountEntity account = null;
        account = this.awsAccountPersistenceService.getById(accountId);
        if (null == account) {
            throw new GenericRestException().withResponseStatus(Response.Status.NOT_FOUND);
        }
        if (IAMRoleForEC2AndECSService.isEC2PlaceholderAccount(account)) {
            throw new GenericRestException(this.i18n.getText("ifaws.accountCRUD.errorMessage.ec2PlaceholderAccount")).withResponseStatus(Response.Status.FORBIDDEN);
        }
        this.awsAccountPersistenceService.delete(account);
        return Response.ok().build();
    }

    private STSCallerIdentityDTO validateViaCallerIdentityRequest(String accessKey, String secretKey, String cloudProviderKey) {
        BasicAWSCredentials awsCredentials = new BasicAWSCredentials(accessKey, secretKey);
        DefaultCloudProvider cloudProvider = DefaultCloudProvider.getByKey(cloudProviderKey);
        STSCallerIdentityDTO stsCallerIdentityDTO = null;
        stsCallerIdentityDTO = this.tokenClientProxy.getCallerIdentity((AWSCredentials)awsCredentials, cloudProvider);
        return stsCallerIdentityDTO;
    }

    private boolean accountWithNameExists(String name, String accountId) {
        AWSAccountEntity[] matches = this.awsAccountPersistenceService.findByExactNameCI(name);
        if (matches.length > 0) {
            AWSAccountEntity match;
            if (StringUtils.isBlank((CharSequence)accountId)) {
                return true;
            }
            int n = 0;
            AWSAccountEntity[] aWSAccountEntityArray = matches;
            int n2 = aWSAccountEntityArray.length;
            if (n < n2 && !(match = aWSAccountEntityArray[n]).getId().equals(accountId)) {
                return true;
            }
        }
        return false;
    }

    private void validateAccessKeyId(String accessKeyId) {
        if (StringUtils.startsWithIgnoreCase((CharSequence)accessKeyId, (CharSequence)"ASIA")) {
            throw new GenericRestException(this.i18n.getText("ifaws.accountCRUD.errorMessage.invalidAccessKeyIdTemporary"));
        }
        if (!StringUtils.startsWithIgnoreCase((CharSequence)accessKeyId, (CharSequence)"AKIA")) {
            throw new GenericRestException(this.i18n.getText("ifaws.accountCRUD.errorMessage.invalidAccessKeyIdGeneric"));
        }
    }

    public static AWSAccountDTO2 fromAWSAccount(AWSAccountEntity awsAccount) {
        AWSAccountDTO2 awsAccountData = new AWSAccountDTO2();
        awsAccountData.setId(awsAccount.getId());
        awsAccountData.setName(awsAccount.getName());
        awsAccountData.setAWSAccessKeyId(awsAccount.getAWSAccessKeyId());
        awsAccountData.setAWSSecretKey("Secret key intentionally retained");
        awsAccountData.setCloudProviderKey(awsAccount.getCloudProviderKey());
        boolean hasConnectors = 1 <= awsAccount.getAWSConnectors().length;
        boolean isEC2PlaceholderAccount = IAMRoleForEC2AndECSService.isEC2PlaceholderAccount(awsAccount);
        awsAccountData.setIsDeletable(!hasConnectors && !isEC2PlaceholderAccount);
        return awsAccountData;
    }
}

