/*
 * Decompiled with CFR 0.152.
 */
package net.utoolity.atlassian.ifaws;

import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import net.utoolity.atlassian.ifaws.AWSConnectorValidationResult;
import net.utoolity.atlassian.ifaws.IAMPolicyValidator;
import net.utoolity.atlassian.ifaws.ao.AWSAccountPersistenceService;
import net.utoolity.atlassian.ifaws.ao.AWSConnectorPersistenceService;
import net.utoolity.atlassian.ifaws.ao.DefaultCloudProvider;
import net.utoolity.atlassian.ifaws.ao.IAMRoleForEC2AndECSService;
import net.utoolity.atlassian.ifaws.api.AWSConnectorScope;
import net.utoolity.atlassian.ifaws.api.AWSConnectorType;
import net.utoolity.atlassian.ifaws.model.AWSAccountEntity;
import net.utoolity.atlassian.ifaws.model.AWSConnectorEntity;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AWSConnectorValidator {
    private static final Logger log = LoggerFactory.getLogger(AWSConnectorValidator.class);
    private static final int ROLE_ARN_LENGTH_MAX = 2048;
    private static final int ROLE_ARN_LENGTH_MIN = 2;
    private static final int EXTERNAL_ID_LENGTH_MAX = 96;
    private static final int EXTERNAL_ID_LENGTH_MIN = 2;
    private final I18nResolver i18n;
    private final AWSConnectorPersistenceService awsConnectorPersistenceService;
    private final AWSAccountPersistenceService awsAccountPersistenceService;
    private final IAMRoleForEC2AndECSService iamRoleForEC2AndECSService;

    public AWSConnectorValidator(I18nResolver i18n, AWSConnectorPersistenceService awsConnectorPersistenceService, AWSAccountPersistenceService awsAccountPersistenceService, IAMRoleForEC2AndECSService iamRoleForEC2AndECSService) {
        this.i18n = i18n;
        this.awsConnectorPersistenceService = awsConnectorPersistenceService;
        this.awsAccountPersistenceService = awsAccountPersistenceService;
        this.iamRoleForEC2AndECSService = iamRoleForEC2AndECSService;
    }

    public AWSConnectorValidationResult validateValueMap(Map<String, Object> awsConnectorProperties, Boolean isAddNew, boolean allowNoIamPolicies) {
        return this.validateValueMap(awsConnectorProperties, isAddNew, allowNoIamPolicies, false);
    }

    public AWSConnectorValidationResult validateValueMapRemovingNonApplicableEntries(Map<String, Object> awsConnectorProperties, Boolean isAddNew, boolean allowNoIamPolicies) {
        return this.validateValueMap(awsConnectorProperties, isAddNew, allowNoIamPolicies, true);
    }

    private AWSConnectorValidationResult validateValueMap(Map<String, Object> awsConnectorProperties, Boolean isAddNew, boolean allowNoIamPolicies, boolean removeNonApplicableEntries) {
        AWSConnectorValidationResult validationResult = new AWSConnectorValidationResult();
        this.validateAWSAccount(awsConnectorProperties, validationResult);
        this.validateName(awsConnectorProperties, validationResult);
        this.validateType(awsConnectorProperties, validationResult);
        this.validateSystemScope(awsConnectorProperties, validationResult);
        this.validateRoleArn(awsConnectorProperties, validationResult, removeNonApplicableEntries);
        this.validateExternalId(awsConnectorProperties, validationResult, removeNonApplicableEntries);
        boolean hasIAMPolicyArns = StringUtils.isNotBlank((CharSequence)((String)awsConnectorProperties.get("IAM_POLICY_ARNS")));
        boolean allowEmptyIamPolicy = allowNoIamPolicies ? true : hasIAMPolicyArns;
        this.validateIAMPolicy(awsConnectorProperties, allowEmptyIamPolicy, validationResult, removeNonApplicableEntries);
        boolean hasIAMPolicy = StringUtils.isNotBlank((CharSequence)((String)awsConnectorProperties.get("IAM_POLICY")));
        boolean allowEmptyIamPolicyArns = allowNoIamPolicies ? true : hasIAMPolicy;
        this.validateIAMPolicyArns(awsConnectorProperties, allowEmptyIamPolicyArns, validationResult, removeNonApplicableEntries);
        this.validateDurationSecondsMax(awsConnectorProperties, validationResult, removeNonApplicableEntries);
        return validationResult;
    }

    private void validateAWSAccount(Map<String, Object> awsConnectorProperties, AWSConnectorValidationResult validationResult) {
        String awsAccountId = (String)awsConnectorProperties.get("AWS_ACCOUNTID");
        if (StringUtils.isBlank((CharSequence)awsAccountId) || "-1" == awsAccountId) {
            validationResult.addFullError("awsAccountId", this.i18n.getText("ifaws.configAWSConnectorEdit.validationError.missingAccount"));
        } else {
            try {
                AWSAccountEntity awsAccount = this.awsAccountPersistenceService.getById(awsAccountId);
                if (null == awsAccount) {
                    validationResult.addFullError("awsAccountId", this.i18n.getText("ifaws.configAWSConnectorEdit.validationError.unknownAccount"));
                } else {
                    awsConnectorProperties.put("AWS_ACCOUNTID", awsAccountId);
                    awsConnectorProperties.put("AWS_ACCOUNT", awsAccount);
                }
            }
            catch (NumberFormatException nfe) {
                validationResult.addFullError("awsAccountId", this.i18n.getText("ifaws.configAWSConnectorEdit.validationError.invalidAccountId"));
            }
        }
    }

    private void validateName(Map<String, Object> awsConnectorProperties, AWSConnectorValidationResult validationResult) {
        String name = (String)awsConnectorProperties.get("NAME");
        if (StringUtils.isBlank((CharSequence)name)) {
            validationResult.addFullError("name", this.i18n.getText("ifaws.configAWSConnectorEdit.validationError.missingName"));
        } else if (!this.isUniqueName(name, (String)awsConnectorProperties.get("ID"))) {
            validationResult.addConsistencyError("name", this.i18n.getText("ifaws.configAWSConnectorEdit.validationError.duplicateName"));
        }
    }

    private void validateType(Map<String, Object> awsConnectorProperties, AWSConnectorValidationResult validationResult) {
        String type = (String)awsConnectorProperties.get("TYPE");
        if (StringUtils.isBlank((CharSequence)type)) {
            validationResult.addFullError("type", this.i18n.getText("ifaws.configAWSConnectorEdit.validationError.missingType"));
        } else {
            try {
                boolean isEC2PlaceholderCompatibleType;
                AWSConnectorType parsedType = AWSConnectorType.valueOf(type);
                String awsAccountId = (String)awsConnectorProperties.get("AWS_ACCOUNTID");
                boolean isEC2PlaceholderAccountID = this.iamRoleForEC2AndECSService.isEC2PlaceholderAccountID(awsAccountId);
                if (AWSConnectorType.PROVIDED.equals((Object)parsedType) && !isEC2PlaceholderAccountID) {
                    validationResult.addFullError("type", this.i18n.getText("ifaws.configAWSConnectorEdit.validationError.providedTypeNoEC2AccountMismatch"));
                    validationResult.addFullError("awsAccountId", this.i18n.getText("ifaws.configAWSConnectorEdit.validationError.providedTypeNoEC2AccountMismatch"));
                }
                boolean bl = isEC2PlaceholderCompatibleType = AWSConnectorType.ASSUME_ROLE.equals((Object)parsedType) || AWSConnectorType.PROVIDED.equals((Object)parsedType);
                if (isEC2PlaceholderAccountID && !isEC2PlaceholderCompatibleType) {
                    validationResult.addFullError("type", this.i18n.getText("ifaws.configAWSConnectorEdit.validationError.ec2AccountTypeMismatch"));
                    validationResult.addFullError("awsAccountId", this.i18n.getText("ifaws.configAWSConnectorEdit.validationError.ec2AccountTypeMismatch"));
                }
            }
            catch (IllegalArgumentException iae) {
                validationResult.addFullError("type", this.i18n.getText("ifaws.configAWSConnectorEdit.validationError.invalidType"));
            }
        }
    }

    private void validateSystemScope(Map<String, Object> awsConnectorProperties, AWSConnectorValidationResult validationResult) {
        AWSConnectorScope scope = (AWSConnectorScope)awsConnectorProperties.get("SCOPE");
        if (null != scope && scope != AWSConnectorScope.SYSTEM) {
            validationResult.addFullError("type", this.i18n.getText("ifaws.configAWSConnectorEdit.validationError.invalidSystemScope"));
        }
    }

    private void validateRoleArn(Map<String, Object> awsConnectorProperties, AWSConnectorValidationResult validationResult, boolean removeNonApplicableEntries) {
        String roleArn = (String)awsConnectorProperties.get("ROLE_ARN");
        String type = (String)awsConnectorProperties.get("TYPE");
        if (null == type) {
            type = "";
        }
        if (type.equals(AWSConnectorType.ASSUME_ROLE.name())) {
            if (StringUtils.isBlank((CharSequence)roleArn)) {
                validationResult.addFullError("roleArn", this.i18n.getText("ifaws.configAWSConnectorEdit.validationError.missingRoleArn"));
            } else if (roleArn.length() > 2048) {
                validationResult.addFullError("roleArn", this.i18n.getText("ifaws.configAWSConnectorEdit.validationError.roleArnTooLong", new Serializable[]{Integer.valueOf(2048)}));
            } else if (roleArn.length() < 2) {
                validationResult.addFullError("roleArn", this.i18n.getText("ifaws.configAWSConnectorEdit.validationError.roleArnTooShort", new Serializable[]{Integer.valueOf(2)}));
            }
        } else if (StringUtils.isNotBlank((CharSequence)roleArn)) {
            if (removeNonApplicableEntries) {
                awsConnectorProperties.put("ROLE_ARN", "");
            } else {
                validationResult.addConsistencyError("roleArn", this.i18n.getText("ifaws.configAWSConnectorEdit.validationError.roleArnNotApplicable"));
            }
        }
    }

    private void validateExternalId(Map<String, Object> awsConnectorProperties, AWSConnectorValidationResult validationResult, boolean removeNonApplicableEntries) {
        String externalId = (String)awsConnectorProperties.get("EXTERNAL_ID");
        String type = (String)awsConnectorProperties.get("TYPE");
        if (null == type) {
            type = "";
        }
        if (type.equals(AWSConnectorType.ASSUME_ROLE.name())) {
            if (StringUtils.isNotBlank((CharSequence)externalId)) {
                if (externalId.length() > 96) {
                    validationResult.addFullError("externalId", this.i18n.getText("ifaws.configAWSConnectorEdit.validationError.externalIdTooLong", new Serializable[]{Integer.valueOf(96)}));
                } else if (externalId.length() < 2) {
                    validationResult.addFullError("externalId", this.i18n.getText("ifaws.configAWSConnectorEdit.validationError.externalIdTooShort", new Serializable[]{Integer.valueOf(2)}));
                }
            }
        } else if (StringUtils.isNotBlank((CharSequence)externalId)) {
            if (removeNonApplicableEntries) {
                awsConnectorProperties.put("ROLE_ARN", "");
            } else {
                validationResult.addConsistencyError("externalId", this.i18n.getText("ifaws.configAWSConnectorEdit.validationError.externalIdNotApplicable"));
            }
        }
    }

    private void validateIAMPolicy(Map<String, Object> awsConnectorProperties, boolean allowEmptyIamPolicy, AWSConnectorValidationResult validationResult, boolean removeNonApplicableEntries) {
        boolean isNotApplicable;
        String iamPolicy = (String)awsConnectorProperties.get("IAM_POLICY");
        String type = (String)awsConnectorProperties.get("TYPE");
        if (null == type) {
            type = "";
        }
        boolean bl = isNotApplicable = type.equals(AWSConnectorType.SESSION_TOKEN.name()) || type.equals(AWSConnectorType.PROVIDED.name());
        if (StringUtils.isNotBlank((CharSequence)iamPolicy) && isNotApplicable) {
            if (removeNonApplicableEntries) {
                awsConnectorProperties.put("IAM_POLICY", "");
            } else {
                validationResult.addConsistencyError("iamPolicy", this.i18n.getText("ifaws.configAWSConnectorEdit.validationError.invalidPolicyNotApplicableForPrincipalType"));
            }
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)iamPolicy)) {
            String expectedARNKey;
            List<String> mismatches;
            DefaultCloudProvider cloudProvider;
            AWSAccountEntity awsAccount;
            List<String> invalidChars;
            if (!IAMPolicyValidator.validateJSON(iamPolicy)) {
                validationResult.addFullError("iamPolicy", this.i18n.getText("ifaws.configAWSConnectorEdit.validationError.invalidPolicyJSON"));
            }
            if (!(invalidChars = IAMPolicyValidator.validatePolicyChars(iamPolicy)).isEmpty()) {
                String charListing = StringUtils.join(invalidChars, (String)"\", \"");
                String errorMessage = this.i18n.getText("ifaws.configAWSConnectorEdit.validationError.invalidPolicyChars", new Serializable[]{charListing});
                validationResult.addFullError("iamPolicy", errorMessage);
            }
            if (!IAMPolicyValidator.validatePolicyLength(iamPolicy)) {
                String errorMessage = this.i18n.getText("ifaws.configAWSConnectorEdit.validationError.invalidPolicyLength", new Serializable[]{Integer.valueOf(2048)});
                validationResult.addFullError("iamPolicy", errorMessage);
            }
            if (null != (awsAccount = (AWSAccountEntity)awsConnectorProperties.get("AWS_ACCOUNT")) && null != (cloudProvider = DefaultCloudProvider.getByKey(awsAccount.getCloudProviderKey())) && !(mismatches = IAMPolicyValidator.validateCloudProviderArnFormat(iamPolicy, expectedARNKey = cloudProvider.getPartitionKey())).isEmpty()) {
                String expectedFormat = "arn:" + expectedARNKey + ":";
                ImmutableSet uniqueMismatches = ImmutableSet.copyOf(mismatches);
                String mismatchListing = StringUtils.join((Iterable)uniqueMismatches, (String)"\", \"");
                String errorMessage = this.i18n.getText("ifaws.configAWSConnectorEdit.validationError.invalidCloudProviderArn", new Serializable[]{Integer.valueOf(mismatches.size()), expectedFormat, cloudProvider.getDisplayName(), mismatchListing});
                validationResult.addFullError("iamPolicy", errorMessage);
            }
        } else if (type.equals(AWSConnectorType.FEDERATION_TOKEN.name()) && !allowEmptyIamPolicy) {
            String message = this.i18n.getText("ifaws.configAWSConnectorEdit.validationError.emptyPolicyForFederationToken");
            validationResult.addFullError("iamPolicy", message);
            validationResult.addFullError("policyArns", message);
        }
    }

    private void validateIAMPolicyArns(Map<String, Object> awsConnectorProperties, boolean allowEmptyIamPolicyArns, AWSConnectorValidationResult validationResult, boolean removeNonApplicableEntries) {
        boolean isNotApplicable;
        String policyArnsJson = (String)awsConnectorProperties.get("IAM_POLICY_ARNS");
        String type = (String)awsConnectorProperties.get("TYPE");
        if (null == type) {
            type = "";
        }
        boolean bl = isNotApplicable = type.equals(AWSConnectorType.SESSION_TOKEN.name()) || type.equals(AWSConnectorType.PROVIDED.name());
        if (StringUtils.isNotBlank((CharSequence)policyArnsJson) && isNotApplicable) {
            if (removeNonApplicableEntries) {
                awsConnectorProperties.put("IAM_POLICY", "");
            } else {
                validationResult.addConsistencyError("policyArns", this.i18n.getText("ifaws.configAWSConnectorEdit.validationError.invalidPolicyArnsNotApplicableForPrincipalType"));
            }
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)policyArnsJson)) {
            if (!IAMPolicyValidator.validatePolicyArnsJsonFormat(policyArnsJson)) {
                validationResult.addFullError("policyArns", this.i18n.getText("ifaws.configAWSConnectorEdit.validationError.invalidPolicyArnsJSON"));
                return;
            }
            if (!IAMPolicyValidator.validatePolicyArnsJsonNumber(policyArnsJson)) {
                String errorMessage = this.i18n.getText("ifaws.configAWSConnectorEdit.validationError.invalidPolicyArnsNumber", new Serializable[]{Integer.valueOf(10)});
                validationResult.addFullError("policyArns", errorMessage);
                return;
            }
            List<String> arnFormatErrors = IAMPolicyValidator.validatePolicyArnsFormat(policyArnsJson);
            if (0 < arnFormatErrors.size()) {
                String errorsCollapsed = StringUtils.join(arnFormatErrors, (String)" | ");
                String errorMessage = this.i18n.getText("ifaws.configAWSConnectorEdit.validationError.invalidPolicyArnsFormat", new Serializable[]{errorsCollapsed});
                validationResult.addFullError("policyArns", errorMessage);
                return;
            }
        } else if (type.equals(AWSConnectorType.FEDERATION_TOKEN.name()) && !allowEmptyIamPolicyArns) {
            String message = this.i18n.getText("ifaws.configAWSConnectorEdit.validationError.emptyPolicyForFederationToken");
            validationResult.addFullError("iamPolicy", message);
            validationResult.addFullError("policyArns", message);
        }
    }

    private void validateDurationSecondsMax(Map<String, Object> awsConnectorProperties, AWSConnectorValidationResult validationResult, boolean removeNonApplicableEntries) {
        Object durationSecondsMaxRaw = awsConnectorProperties.get("DURATION_SECONDS_MAX");
        if (null == durationSecondsMaxRaw) {
            return;
        }
        int durationSecondsMax = 0;
        if (durationSecondsMaxRaw instanceof String) {
            String durationSecondsMaxString = (String)durationSecondsMaxRaw;
            if (durationSecondsMaxString.isEmpty()) {
                awsConnectorProperties.put("DURATION_SECONDS_MAX", null);
                return;
            }
            try {
                durationSecondsMax = Integer.parseInt(durationSecondsMaxString);
                awsConnectorProperties.put("DURATION_SECONDS_MAX", durationSecondsMax);
            }
            catch (NumberFormatException nfe) {
                validationResult.addFullError("durationSecondsMax", this.i18n.getText("ifaws.configAWSConnectorEdit.validationError.durationSecondsMaxInvalidFormat"));
                return;
            }
        } else {
            durationSecondsMax = (Integer)durationSecondsMaxRaw;
        }
        String typeName = (String)awsConnectorProperties.get("TYPE");
        AWSConnectorType type = null;
        try {
            type = AWSConnectorType.valueOf(typeName);
        }
        catch (IllegalArgumentException iae) {
            type = null;
        }
        if (null != type) {
            if (type.equals((Object)AWSConnectorType.PROVIDED)) {
                if (removeNonApplicableEntries) {
                    awsConnectorProperties.put("DURATION_SECONDS_MAX", "");
                } else {
                    validationResult.addConsistencyError("durationSecondsMax", this.i18n.getText("ifaws.configAWSConnectorEdit.validationError.durationSecondsMaxNotApplicableForPrincipalType"));
                }
                return;
            }
            if (durationSecondsMax < type.getDurationSecondsMin()) {
                validationResult.addFullError("durationSecondsMax", this.i18n.getText("ifaws.configAWSConnectorEdit.validationError.durationSecondsMaxTooShort", new Serializable[]{Integer.valueOf(type.getDurationSecondsMin())}));
            } else if (durationSecondsMax > type.getDurationSecondsMax()) {
                validationResult.addFullError("durationSecondsMax", this.i18n.getText("ifaws.configAWSConnectorEdit.validationError.durationSecondsMaxTooLong", new Serializable[]{Integer.valueOf(type.getDurationSecondsMax())}));
            }
        }
    }

    private boolean isUniqueName(String name, String idParam) {
        AWSConnectorEntity[] matches = this.awsConnectorPersistenceService.findByExactNameCI(name);
        if (0 == matches.length) {
            return true;
        }
        if (1 < matches.length) {
            return false;
        }
        if (StringUtils.isBlank((CharSequence)idParam)) {
            return false;
        }
        return idParam.equals(matches[0].getId());
    }
}

