/*
 * Decompiled with CFR 0.152.
 */
package net.utoolity.atlassian.dry;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.license.LicenseHandler;
import com.atlassian.upm.api.license.HostLicenseInformation;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class PluginInfo {
    public static final String PLUGIN_GROUP_ID;
    public static final String PLUGIN_ARTIFACT_ID;
    public static final String UTOOLITY_PROJECT_KEY;
    public static final String PLUGIN_KEY;
    public static final String PLUGIN_SERVLET_PATH = "/plugins/servlet/identity-federation-for-aws";
    public static final String PLUGIN_CONFIGURATION_PATH = "/plugins/servlet/identity-federation-for-aws/configuration";
    public static final String PLUGIN_CONNECTOR_OVERVIEW_PATH = "/plugins/servlet/identity-federation-for-aws/configuration/aws-connector";
    public static final String PLUGIN_SETTINGS_NAMESPACE;
    public static final String PLUGIN_RESOURCE_BASE_URL;
    private final ApplicationProperties applicationProperties;
    private final Plugin plugin;
    private final HostLicenseInformation hostLicenseInformation;

    public PluginInfo(ApplicationProperties applicationProperties, PluginAccessor pluginAccessor, HostLicenseInformation hostLicenseInformation, LicenseHandler licenseHandler) {
        this.applicationProperties = applicationProperties;
        this.plugin = pluginAccessor.getPlugin(PLUGIN_KEY);
        this.hostLicenseInformation = hostLicenseInformation;
    }

    public String getApplicationName() {
        return this.applicationProperties.getDisplayName();
    }

    public String getApplicationVersion() {
        return this.applicationProperties.getVersion();
    }

    public String getPluginName() {
        return this.plugin.getName();
    }

    public String getPluginVersion() {
        return this.plugin.getPluginInformation().getVersion();
    }

    public String getHostIsDataCenter() {
        return String.valueOf(this.hostLicenseInformation.isDataCenter());
    }

    public String getHostIsEvaluation() {
        return String.valueOf(this.hostLicenseInformation.isEvaluation());
    }

    public String getHostSen() {
        return (String)this.hostLicenseInformation.hostSen().map(i -> i.toString()).getOrElse((Object)"unknown");
    }

    public String getHostEdition() {
        return (String)this.hostLicenseInformation.getEdition().map(i -> i.toString()).getOrElse((Object)"unlimited");
    }

    static {
        Properties properties = new Properties();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        InputStream stream = loader.getResourceAsStream("identity-federation-for-aws.properties");
        try {
            properties.load(stream);
            PLUGIN_GROUP_ID = properties.getProperty("plugin.groupId");
            PLUGIN_ARTIFACT_ID = properties.getProperty("plugin.artifactId");
            UTOOLITY_PROJECT_KEY = properties.getProperty("utoolity.project.key");
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read 'identity-federation-for-aws.properties'!");
        }
        PLUGIN_KEY = PLUGIN_GROUP_ID + "." + PLUGIN_ARTIFACT_ID;
        PLUGIN_SETTINGS_NAMESPACE = "net.utoolity." + UTOOLITY_PROJECT_KEY.toLowerCase();
        PLUGIN_RESOURCE_BASE_URL = "/download/resources/" + PLUGIN_KEY + ":";
    }
}

