/*
 * Decompiled with CFR 0.152.
 */
package net.utoolity.atlassian.bamboo.ifaws.vcs;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.vcs.viewer.configuration.VcsRepositoryViewerDefinition;
import com.atlassian.bamboo.vcs.viewer.configurator.VcsRepositoryViewerConfigurator;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.message.I18nResolver;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.utoolity.atlassian.dry.AUIMessage;
import net.utoolity.atlassian.dry.LicenseHelper;
import net.utoolity.atlassian.ifaws.AWSConsoleLoginConnectorFilter;
import net.utoolity.atlassian.ifaws.api.AWSConnectorDTO2;
import net.utoolity.atlassian.ifaws.api.AWSConnectorService2;
import net.utoolity.atlassian.ifaws.api.LicenseException;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeCommitVcsRepositoryViewerConfigurator
implements VcsRepositoryViewerConfigurator {
    private static final Logger log = LoggerFactory.getLogger(CodeCommitVcsRepositoryViewerConfigurator.class);
    public static final String AWS_CONNECTOR_ID = "awsConnectorId";
    public static final String AWS_CONNECTOR_ID_VARIABLE = "awsConnectorIdVariable";
    public static final String AWS_CONNECTOR_VARIABLE_KEY = "AWS_CONNECTOR_VARIABLE_KEY";
    public static final String AWS_CONNECTOR_NO_CONNECTOR_KEY = "AWS_CONNECTOR_NO_CONNECTOR_KEY";
    private static final String AWS_CONNECTOR_ID_OPTIONS = "awsConnectorIdOptions";
    private static final String IFAWS_CONNECTOR_CONFIG_PATH = "/plugins/servlet/identity-federation-for-aws/configuration/aws-connector";
    private static final String IFAWS_STATIC_RESOURCE_PATH = "/download/resources/net.utoolity.atlassian.bamboo.identity-federation-for-aws-bamboo/ifaws-resources";
    private static final String VARIABLE_PATTERN = "\\$\\{\\S+?}";
    private final LicenseHelper licenseHelper;
    private final AWSConnectorService2 awsConnectorService2;
    private final ApplicationProperties applicationProperties;
    private final I18nResolver i18n;

    public CodeCommitVcsRepositoryViewerConfigurator(LicenseHelper licenseHelper, AWSConnectorService2 awsConnectorService2, ApplicationProperties applicationProperties, I18nResolver i18n) {
        this.licenseHelper = licenseHelper;
        this.awsConnectorService2 = awsConnectorService2;
        this.applicationProperties = applicationProperties;
        this.i18n = i18n;
    }

    public void populateContextForCreate(Map<String, Object> context) {
        this.populateContextForAllOperations(context);
    }

    public void populateContextForEdit(Map<String, Object> context, VcsRepositoryViewerDefinition vcsRepositoryViewerDefinition) {
        this.populateContextForAllOperations(context);
        this.populateContextForEditAndView(context, vcsRepositoryViewerDefinition);
    }

    public void populateContextForView(Map<String, Object> context, VcsRepositoryViewerDefinition vcsRepositoryViewerDefinition) {
        this.populateContextForAllOperations(context);
        this.populateContextForEditAndView(context, vcsRepositoryViewerDefinition);
    }

    private void populateContextForAllOperations(@NotNull Map<String, Object> context) {
        context.put("messages", this.createMessages().toString());
        String baseUrl = this.applicationProperties.getBaseUrl(UrlMode.RELATIVE);
        String connectorConfigUrl = baseUrl + IFAWS_CONNECTOR_CONFIG_PATH;
        context.put("showIfawsNotConfiguredMessage", !this.hasIfawsConnectors());
        if (!this.hasIfawsConnectors()) {
            String messageParagraph = MessageFormat.format(this.i18n.getText("You need to <a href=\"{0}\" target=\"_blank\" >configure at least one AWS Connector</a> first."), connectorConfigUrl);
            context.put("ifawsNotConfiguredMessageWarn", new AUIMessage(AUIMessage.Type.WARNING).addMessageParagraphHtml(messageParagraph).asHtml());
        }
        String pathToStaticResources = baseUrl + IFAWS_STATIC_RESOURCE_PATH;
        context.put("pathToStaticResources", pathToStaticResources);
        context.put(AWS_CONNECTOR_ID_OPTIONS, this.getAWSConnectorMap());
    }

    private void populateContextForEditAndView(@NotNull Map<String, Object> context, @NotNull VcsRepositoryViewerDefinition vcsRepositoryViewerDefinition) {
        Map config = vcsRepositoryViewerDefinition.getConfiguration();
        context.put(AWS_CONNECTOR_ID, config.get(AWS_CONNECTOR_ID));
        context.put(AWS_CONNECTOR_ID_VARIABLE, config.get(AWS_CONNECTOR_ID_VARIABLE));
    }

    public void validate(ActionParametersMap actionParametersMap, ErrorCollection errorCollection) {
        this.validateAWSConnectorId(actionParametersMap, errorCollection);
    }

    public Map<String, String> generateConfigMap(ActionParametersMap actionParametersMap, VcsRepositoryViewerDefinition previousViewerDefinition) {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put(AWS_CONNECTOR_ID, actionParametersMap.getString(AWS_CONNECTOR_ID));
        config.put(AWS_CONNECTOR_ID_VARIABLE, actionParametersMap.getString(AWS_CONNECTOR_ID_VARIABLE));
        return config;
    }

    protected StringBuilder createMessages() {
        StringBuilder messages = new StringBuilder();
        try {
            this.licenseHelper.ensureValidLicense();
        }
        catch (LicenseException le) {
            AUIMessage message = this.licenseHelper.createAUIErrorMessage(le, AUIMessage.Type.WARNING, false);
            messages.append(message.asHtml());
        }
        return messages;
    }

    private boolean hasIfawsConnectors() {
        return this.getAWSConnectorMap().size() > 1;
    }

    private Map<String, String> getAWSConnectorMap() {
        LinkedHashMap<String, String> awsConnectorMap = new LinkedHashMap<String, String>();
        String noConnectorPlaceholder = this.i18n.getText("net.utoolity.atlassian.bamboo.ifaws.codeCommitRepositoryViewer.awsConnectorOptionNoSelection");
        awsConnectorMap.put(AWS_CONNECTOR_NO_CONNECTOR_KEY, noConnectorPlaceholder);
        if (null != this.awsConnectorService2) {
            try {
                AWSConsoleLoginConnectorFilter loginConnectorFilter = new AWSConsoleLoginConnectorFilter(this.awsConnectorService2);
                List<AWSConnectorDTO2> connectors = loginConnectorFilter.getAvailableSSOConnectors();
                for (AWSConnectorDTO2 awsConnectorEntity : connectors) {
                    awsConnectorMap.put(awsConnectorEntity.getId(), awsConnectorEntity.getName());
                }
                String variablePlaceholder = this.i18n.getText("net.utoolity.atlassian.bamboo.ifaws.codeCommitRepositoryViewer.awsConnectorOptionIfawsConnectorVariable");
                awsConnectorMap.put(AWS_CONNECTOR_VARIABLE_KEY, variablePlaceholder);
            }
            catch (LicenseException le) {
                String licenseError = this.i18n.getText("net.utoolity.atlassian.bamboo.ifaws.codeCommitRepositoryViewer.awsConnectorId.errorMissingLicense");
                awsConnectorMap.put(String.valueOf(-1), licenseError);
            }
        } else {
            log.error("Missing injected dependency on AWSConnectorService2.");
        }
        return awsConnectorMap;
    }

    private void validateAWSConnectorId(ActionParametersMap params, ErrorCollection errorCollection) {
        String awsConnectorId = params.getString(AWS_CONNECTOR_ID, "-1");
        if (awsConnectorId.equals("-1")) {
            errorCollection.addError(AWS_CONNECTOR_ID, this.i18n.getText("net.utoolity.atlassian.bamboo.ifaws.codeCommitRepositoryViewer.awsConnectorId.errorMissing"));
            return;
        }
        if (awsConnectorId.equals(AWS_CONNECTOR_VARIABLE_KEY)) {
            this.validateAWSCredentialsSourceIfawsVariable(params, errorCollection);
            return;
        }
        if (awsConnectorId.equals(AWS_CONNECTOR_NO_CONNECTOR_KEY)) {
            return;
        }
        AWSConnectorDTO2 selectedConnector = this.awsConnectorService2.getConnector(awsConnectorId);
        if (null == selectedConnector) {
            errorCollection.addError(AWS_CONNECTOR_ID, this.i18n.getText("net.utoolity.atlassian.bamboo.ifaws.codeCommitRepositoryViewer.awsConnectorId.errorUnknown"));
        }
    }

    private void validateAWSCredentialsSourceIfawsVariable(ActionParametersMap params, ErrorCollection errorCollection) {
        String awsConnectorIdVariable = params.getString(AWS_CONNECTOR_ID_VARIABLE);
        if (StringUtils.isBlank((CharSequence)awsConnectorIdVariable) || !this.isVariable(awsConnectorIdVariable)) {
            errorCollection.addError(AWS_CONNECTOR_ID_VARIABLE, this.i18n.getText("net.utoolity.atlassian.bamboo.ifaws.codeCommitRepositoryViewer.awsConnectorIdVariable.error"));
        }
    }

    private boolean isVariable(String candidate) {
        String pattern = "^\\$\\{\\S+?}$";
        return candidate.matches(pattern);
    }
}

