/*
 * Decompiled with CFR 0.152.
 */
package net.utoolity.atlassian.ifaws.ui;

import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.utoolity.atlassian.dry.AUIMessage;
import net.utoolity.atlassian.dry.LicenseHelper;
import net.utoolity.atlassian.dry.PluginInfo;
import net.utoolity.atlassian.ifaws.FeatureFlag;
import net.utoolity.atlassian.ifaws.PluginConfiguration;
import net.utoolity.atlassian.ifaws.api.AWSConnectorDTO2;
import net.utoolity.atlassian.ifaws.api.AWSConnectorService2;
import net.utoolity.atlassian.ifaws.api.ExternalCredentialsProviderService;
import net.utoolity.atlassian.ifaws.api.LicenseException;
import net.utoolity.atlassian.ifaws.model.ExternalCredentialsProviderType;

public class ConfigFeaturesServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private final LicenseHelper licenseHelper;
    private final TemplateRenderer templateRenderer;
    private final I18nResolver i18n;
    private final PluginConfiguration pluginConfiguration;
    private final AWSConnectorService2 awsConnectorService2;
    private final ExternalCredentialsProviderService externalCredentialsProviderService;

    public ConfigFeaturesServlet(LicenseHelper licenseHelper, TemplateRenderer templateRenderer, I18nResolver i18n, PluginConfiguration pluginConfiguration, AWSConnectorService2 awsConnectorService2, ExternalCredentialsProviderService externalCredentialsProviderService) {
        this.templateRenderer = templateRenderer;
        this.i18n = i18n;
        this.pluginConfiguration = pluginConfiguration;
        this.awsConnectorService2 = awsConnectorService2;
        this.externalCredentialsProviderService = externalCredentialsProviderService;
        this.licenseHelper = licenseHelper;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ArrayList<AUIMessage> messages = new ArrayList<AUIMessage>();
        Map<String, Object> context = this.prepareCommonRenderingContext(request, messages);
        response.setContentType("text/html;charset=utf-8");
        this.templateRenderer.render("net/utoolity/atlassian/ifaws/templates/configFeatures.vm", context, (Writer)response.getWriter());
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            if (null != request.getParameter("enableGovCloud")) {
                this.pluginConfiguration.enableFeature(FeatureFlag.ENABLE_GOV_CLOUD);
            } else {
                this.pluginConfiguration.disableFeature(FeatureFlag.ENABLE_GOV_CLOUD);
            }
            if (null != request.getParameter("enableChinaPartition")) {
                this.pluginConfiguration.enableFeature(FeatureFlag.ENABLE_CHINA_PARTITION);
            } else {
                this.pluginConfiguration.disableFeature(FeatureFlag.ENABLE_CHINA_PARTITION);
            }
            if (null != request.getParameter("disableImplicitAdminConnectorUsage")) {
                this.pluginConfiguration.enableFeature(FeatureFlag.DISABLE_IMPLICIT_ADMIN_CONNECTOR_USAGE);
            } else {
                this.pluginConfiguration.disableFeature(FeatureFlag.DISABLE_IMPLICIT_ADMIN_CONNECTOR_USAGE);
            }
            if (null != request.getParameter("enableRestrictedAdminConnectorManagement")) {
                this.pluginConfiguration.enableFeature(FeatureFlag.ENABLE_RESTRICTED_ADMIN_CONNECTOR_MANAGEMENT);
            } else {
                this.pluginConfiguration.disableFeature(FeatureFlag.ENABLE_RESTRICTED_ADMIN_CONNECTOR_MANAGEMENT);
            }
            if (Boolean.valueOf(request.getParameter("wasIAMRoleForEC2CredentialsProviderOptionEnabled")).booleanValue()) {
                if (null != request.getParameter("enableIAMRoleForEC2CredentialsProvider")) {
                    this.externalCredentialsProviderService.enableExternalCredentialsProviderSource(ExternalCredentialsProviderType.IAMRoleForEC2AndECS);
                } else {
                    this.externalCredentialsProviderService.disableExternalCredentialsProviderSource(ExternalCredentialsProviderType.IAMRoleForEC2AndECS);
                }
            }
            if (Boolean.valueOf(request.getParameter("wasWebIdentityTokenCredentialsProviderOptionEnabled")).booleanValue()) {
                if (null != request.getParameter("enableWebIdentityTokenCredentialsProvider")) {
                    this.externalCredentialsProviderService.enableExternalCredentialsProviderSource(ExternalCredentialsProviderType.WebIdentityToken);
                } else {
                    this.externalCredentialsProviderService.disableExternalCredentialsProviderSource(ExternalCredentialsProviderType.WebIdentityToken);
                }
            }
            response.sendRedirect(this.createConnectorOverviewPath(request));
            return;
        }
        catch (Exception e) {
            ArrayList<AUIMessage> messages = new ArrayList<AUIMessage>();
            AUIMessage message = new AUIMessage(AUIMessage.Type.ERROR, this.i18n.getText("ifaws.configGeneric.genericErrorMessage.title"), e.getMessage());
            messages.add(message);
            Map<String, Object> context = this.prepareCommonRenderingContext(request, messages);
            response.setContentType("text/html;charset=utf-8");
            this.templateRenderer.render("net/utoolity/atlassian/ifaws/templates/configFeatures.vm", context, (Writer)response.getWriter());
            return;
        }
    }

    private Map<String, Object> prepareCommonRenderingContext(HttpServletRequest request, List<AUIMessage> messages) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        try {
            context.put("isConnectorAvailable", this.isConnectorAvailable());
        }
        catch (LicenseException le) {
            messages.add(this.licenseHelper.createAUIErrorMessage(le, AUIMessage.Type.WARNING));
        }
        context.put("pluginKey", PluginInfo.PLUGIN_KEY);
        context.put("connectorOverviewPath", this.createConnectorOverviewPath(request));
        context.put("enableGovCloud", this.pluginConfiguration.isFeatureEnabled(FeatureFlag.ENABLE_GOV_CLOUD));
        context.put("enableChinaPartition", this.pluginConfiguration.isFeatureEnabled(FeatureFlag.ENABLE_CHINA_PARTITION));
        context.put("disableImplicitAdminConnectorUsage", this.pluginConfiguration.isFeatureEnabled(FeatureFlag.DISABLE_IMPLICIT_ADMIN_CONNECTOR_USAGE));
        context.put("enableRestrictedAdminConnectorManagement", this.pluginConfiguration.isFeatureEnabled(FeatureFlag.ENABLE_RESTRICTED_ADMIN_CONNECTOR_MANAGEMENT));
        this.addIAMRoleForEC2ContextEntries(context);
        this.addWebIdentityTokenContextEntries(context);
        context.put("messages", messages);
        return context;
    }

    private void addIAMRoleForEC2ContextEntries(Map<String, Object> context) {
        boolean isIAMRoleForEC2OrECSEnabled = this.externalCredentialsProviderService.isExternalCredentialsProviderSourceEnabled(ExternalCredentialsProviderType.IAMRoleForEC2AndECS);
        context.put("enableIAMRoleForEC2CredentialsProvider", isIAMRoleForEC2OrECSEnabled);
        boolean isIAMRoleForEC2OrECSSupported = ExternalCredentialsProviderService.isExternalCredentialsProviderSourceSupported(ExternalCredentialsProviderType.IAMRoleForEC2AndECS);
        context.put("isIAMRoleForEC2OrECSSupported", isIAMRoleForEC2OrECSSupported);
        boolean allowIAMRoleForEC2CredentialsProviderOptionChange = isIAMRoleForEC2OrECSSupported;
        String iamRoleForEC2DisabledReason = "";
        if (!isIAMRoleForEC2OrECSSupported) {
            iamRoleForEC2DisabledReason = this.i18n.getText("ifaws.configFeaturesServlet.feature.enableIAMRoleForEC2CredentialsProvider.disabled.explanationNotSupported");
        }
        if (isIAMRoleForEC2OrECSEnabled) {
            allowIAMRoleForEC2CredentialsProviderOptionChange = this.externalCredentialsProviderService.canDeletePlaceholderAccount(ExternalCredentialsProviderType.IAMRoleForEC2AndECS);
            iamRoleForEC2DisabledReason = this.i18n.getText("ifaws.configFeaturesServlet.feature.enableIAMRoleForEC2CredentialsProvider.disabled.explanationInUse");
        }
        context.put("allowIAMRoleForEC2CredentialsProviderOptionChange", allowIAMRoleForEC2CredentialsProviderOptionChange);
        context.put("disabledIAMRoleForEC2CredentialsProviderOptionChangeDescription", iamRoleForEC2DisabledReason);
    }

    private void addWebIdentityTokenContextEntries(Map<String, Object> context) {
        boolean isWebIdentityTokenEnabled = this.externalCredentialsProviderService.isExternalCredentialsProviderSourceEnabled(ExternalCredentialsProviderType.WebIdentityToken);
        context.put("enableWebIdentityTokenCredentialsProvider", isWebIdentityTokenEnabled);
        boolean isWebIdentityTokenSupported = ExternalCredentialsProviderService.isExternalCredentialsProviderSourceSupported(ExternalCredentialsProviderType.WebIdentityToken);
        context.put("isWebIdentityTokenSupported", isWebIdentityTokenSupported);
        boolean allowWebIdentityTokenCredentialsProviderOptionChange = isWebIdentityTokenSupported;
        String webIdentityTokenDisabledReason = "";
        if (!isWebIdentityTokenSupported) {
            webIdentityTokenDisabledReason = this.i18n.getText("ifaws.configFeaturesServlet.feature.enableWebIdentityTokenCredentialsProvider.disabled.explanationNotSupported");
        }
        if (isWebIdentityTokenEnabled) {
            allowWebIdentityTokenCredentialsProviderOptionChange = this.externalCredentialsProviderService.canDeletePlaceholderAccount(ExternalCredentialsProviderType.WebIdentityToken);
            webIdentityTokenDisabledReason = this.i18n.getText("ifaws.configFeaturesServlet.feature.enableWebIdentityTokenCredentialsProvider.disabled.explanationInUse");
        }
        context.put("allowWebIdentityTokenCredentialsProviderOptionChange", allowWebIdentityTokenCredentialsProviderOptionChange);
        context.put("disabledWebIdentityTokenCredentialsProviderOptionChangeDescription", webIdentityTokenDisabledReason);
    }

    private String createConnectorOverviewPath(HttpServletRequest request) {
        return request.getContextPath() + "/plugins/servlet/identity-federation-for-aws/configuration/aws-connector";
    }

    private boolean isConnectorAvailable() {
        boolean isAvailable = false;
        if (null != this.awsConnectorService2) {
            List<AWSConnectorDTO2> connectors = this.awsConnectorService2.getConnectors();
            isAvailable = !connectors.isEmpty();
        }
        return isAvailable;
    }
}

