/*
 * Decompiled with CFR 0.152.
 */
package net.utoolity.atlassian.ifaws.rest.common;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="error-response")
@XmlAccessorType(value=XmlAccessType.PUBLIC_MEMBER)
public class ErrorResponseDTO {
    private final Response.StatusType status;
    private final String errorCode;
    private final String error;
    private final List<String> errorMessages = new ArrayList<String>();

    public ErrorResponseDTO(Response.StatusType status, String errorCode, String error) {
        this.status = status;
        this.errorCode = errorCode;
        this.error = error;
    }

    public ErrorResponseDTO(Response.StatusType status, String errorCode, String error, String errorMessage) {
        this(status, errorCode, error);
        this.addErrorMessage(errorMessage);
    }

    public ErrorResponseDTO addErrorMessage(String errorMessage) {
        this.errorMessages.add(errorMessage);
        return this;
    }

    public int getStatusCode() {
        return this.status.getStatusCode();
    }

    public Response.StatusType getStatus() {
        return this.status;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getError() {
        return this.error;
    }

    public List<String> getErrorMessages() {
        if (this.errorMessages.isEmpty()) {
            ArrayList<String> constructedMessages = new ArrayList<String>();
            constructedMessages.add(this.errorCode + ": " + this.error);
            return constructedMessages;
        }
        return this.errorMessages;
    }
}

